/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.PrimaryKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbcopy.I18NBaseObject;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbcopy.UICallbacks;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.AnalysisEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.CopyEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.CopyTableListener;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.ErrorEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.RecordEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.StatementEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.TableEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.prefs.DBCopyPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.dbcopy.prefs.PreferencesManager;
import net.sourceforge.squirrel_sql.plugins.dbcopy.util.DBUtil;
import org.hibernate.MappingException;

public class CopyExecutor
extends I18NBaseObject {
    SessionInfoProvider prov = null;
    ISession sourceSession = null;
    ISession destSession = null;
    private Thread execThread = null;
    private boolean originalAutoCommitValue = true;
    private boolean currentAutoCommitValue = true;
    private static DBCopyPreferenceBean prefs = PreferencesManager.getPreferences();
    private static final ILogger log = LoggerController.createLogger(CopyExecutor.class);
    private ArrayList<ITableInfo> selectedTableInfos = null;
    private ArrayList<CopyTableListener> listeners = new ArrayList();
    private volatile boolean cancelled = false;
    private UICallbacks pref = null;
    private long start = 0L;
    private long end = 0L;

    public CopyExecutor(SessionInfoProvider p) {
        this.prov = p;
        this.sourceSession = this.prov.getSourceSession();
        this.destSession = this.prov.getDestSession();
    }

    public void execute() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CopyExecutor.this._execute();
            }
        };
        this.execThread = new Thread(runnable);
        this.execThread.setName("DBCopy Executor Thread");
        this.execThread.start();
    }

    public void cancel() {
        this.cancelled = true;
        this.execThread.interrupt();
    }

    private void _execute() {
        this.start = System.currentTimeMillis();
        boolean encounteredException = false;
        ISQLConnection destConn = this.destSession.getSQLConnection();
        if (!this.analyzeTables()) {
            return;
        }
        this.setupAutoCommit(destConn);
        List<IDatabaseObjectInfo> sourceObjs = this.prov.getSourceDatabaseObjects();
        int[] counts = this.getTableCounts();
        this.sendCopyStarted(counts);
        String destSchema = this.prov.getDestDatabaseObject().getSimpleName();
        String destCatalog = this.prov.getDestDatabaseObject().getCatalogName();
        int sourceObjectCount = 0;
        for (IDatabaseObjectInfo info : sourceObjs) {
            block16: {
                if (!(info instanceof ITableInfo)) continue;
                ITableInfo sourceTI = (ITableInfo)info;
                this.sendTableCopyStarted(sourceTI, sourceObjectCount + 1);
                try {
                    block15: {
                        int destTableCount = DBUtil.getTableCount(this.destSession, destCatalog, destSchema, sourceTI.getSimpleName(), 1);
                        if (destTableCount == -1) {
                            this.createTable(sourceTI);
                        }
                        if (destTableCount > 0) {
                            try {
                                String t = sourceTI.getSimpleName();
                                if (this.pref.appendRecordsToExisting(t)) break block15;
                                if (!this.pref.deleteTableData(sourceTI.getSimpleName())) continue;
                                DBUtil.deleteDataInExistingTable(this.destSession, destCatalog, destSchema, sourceTI.getSimpleName());
                            }
                            catch (UserCancelledOperationException e) {
                                this.cancelled = true;
                                break;
                            }
                        }
                    }
                    this.copyTable(sourceTI, counts[sourceObjectCount]);
                    if (sourceObjectCount == sourceObjs.size() - 1 && !this.cancelled) {
                        this.copyConstraints(sourceObjs);
                    }
                    if (this.cancelled) break block16;
                    this.sendTableCopyFinished(sourceTI, sourceObjectCount + 1);
                    this.sleep(prefs.getTableDelayMillis());
                }
                catch (SQLException e) {
                    encounteredException = true;
                    this.sendErrorEvent(2, e);
                    break;
                }
                catch (MappingException e) {
                    encounteredException = true;
                    this.sendErrorEvent(3, e);
                    break;
                }
                catch (UserCancelledOperationException e) {
                    this.cancelled = true;
                    break;
                }
                catch (Exception e) {
                    encounteredException = true;
                    this.sendErrorEvent(5, e);
                    break;
                }
            }
            ++sourceObjectCount;
        }
        this.restoreAutoCommit(destConn);
        if (this.cancelled) {
            this.sendErrorEvent(4);
            return;
        }
        if (encounteredException) {
            return;
        }
        this.end = System.currentTimeMillis();
        ISession session = this.prov.getDestSession();
        if (session.getSessionSheet() != null) {
            session.getSchemaInfo().reload(this.prov.getDestDatabaseObject());
            session.getSchemaInfo().fireSchemaInfoUpdate();
        }
        this.notifyCopyFinished();
    }

    public void addListener(CopyTableListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.listeners.add(listener);
    }

    private void sleep(long sleepTime) {
        boolean shouldSleep = prefs.isDelayBetweenObjects();
        if (!shouldSleep || sleepTime <= 0L) {
            return;
        }
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private boolean analyzeTables() {
        boolean result = true;
        if (!prefs.isTestColumnNames()) {
            return true;
        }
        if (DBUtil.sameDatabaseType(this.prov.getSourceSession(), this.prov.getDestSession())) {
            return true;
        }
        this.sendAnalysisStarted();
        try {
            List<IDatabaseObjectInfo> dbObjs = this.prov.getSourceDatabaseObjects();
            int sourceObjectCount = 0;
            for (IDatabaseObjectInfo info : dbObjs) {
                ITableInfo ti = (ITableInfo)info;
                this.sendAnalyzingTable(ti, sourceObjectCount + 1);
                DBUtil.validateColumnNames(ti, this.prov);
                ++sourceObjectCount;
            }
        }
        catch (MappingException e) {
            this.sendErrorEvent(3, e);
            result = false;
        }
        catch (UserCancelledOperationException e) {
            this.sendErrorEvent(4, e);
            result = false;
        }
        return result;
    }

    private void setupAutoCommit(ISQLConnection con) {
        boolean autoCommitPref = prefs.isAutoCommitEnabled();
        try {
            this.currentAutoCommitValue = this.originalAutoCommitValue = con.getAutoCommit();
            if (autoCommitPref != this.originalAutoCommitValue) {
                con.setAutoCommit(autoCommitPref);
                this.currentAutoCommitValue = autoCommitPref;
            }
        }
        catch (SQLException e) {
            this.currentAutoCommitValue = true;
            this.sendErrorEvent(0, e);
        }
    }

    private void restoreAutoCommit(ISQLConnection con) {
        if (this.originalAutoCommitValue == this.currentAutoCommitValue) {
            return;
        }
        try {
            con.setAutoCommit(this.originalAutoCommitValue);
        }
        catch (SQLException e) {
            this.sendErrorEvent(1, e);
        }
    }

    private int[] getTableCounts() {
        int[] result = null;
        ISession sourceSession = this.prov.getSourceSession();
        List<IDatabaseObjectInfo> dbObjs = this.prov.getSourceDatabaseObjects();
        if (dbObjs != null) {
            result = new int[dbObjs.size()];
            this.selectedTableInfos = new ArrayList();
            int sourceObjectCount = 0;
            for (IDatabaseObjectInfo info : dbObjs) {
                if (!(info instanceof ITableInfo)) continue;
                try {
                    ITableInfo ti = (ITableInfo)info;
                    this.selectedTableInfos.add(ti);
                    result[sourceObjectCount] = DBUtil.getTableCount(sourceSession, ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), 0);
                }
                catch (Exception e) {
                    log.error("", e);
                    result[sourceObjectCount] = 0;
                }
                ++sourceObjectCount;
            }
        }
        return result;
    }

    private void sendAnalysisStarted() {
        AnalysisEvent event = new AnalysisEvent(this.prov);
        for (CopyTableListener listener : this.listeners) {
            listener.tableAnalysisStarted(event);
        }
    }

    private void sendAnalyzingTable(ITableInfo ti, int number) {
        TableEvent event = new TableEvent(this.prov);
        event.setTableCount(this.prov.getSourceDatabaseObjects().size());
        event.setTableNumber(number);
        Iterator<CopyTableListener> i = this.listeners.iterator();
        event.setTableName(ti.getSimpleName());
        while (i.hasNext()) {
            CopyTableListener listener = i.next();
            listener.analyzingTable(event);
        }
    }

    private void sendCopyStarted(int[] tableCounts) {
        CopyEvent event = new CopyEvent(this.prov);
        event.setTableCounts(tableCounts);
        for (CopyTableListener listener : this.listeners) {
            listener.copyStarted(event);
        }
    }

    private void sendTableCopyStarted(ITableInfo ti, int number) {
        TableEvent event = new TableEvent(this.prov);
        event.setTableNumber(number);
        event.setTableCount(this.prov.getSourceDatabaseObjects().size());
        event.setTableName(ti.getSimpleName());
        for (CopyTableListener listener : this.listeners) {
            listener.tableCopyStarted(event);
        }
    }

    private void sendTableCopyFinished(ITableInfo ti, int number) {
        TableEvent event = new TableEvent(this.prov);
        event.setTableNumber(number);
        event.setTableCount(this.prov.getSourceDatabaseObjects().size());
        event.setTableName(ti.getSimpleName());
        for (CopyTableListener listener : this.listeners) {
            listener.tableCopyFinished(event);
        }
    }

    private void sendErrorEvent(int type) {
        this.sendErrorEvent(type, null);
    }

    private void sendErrorEvent(int type, Exception e) {
        ErrorEvent event = new ErrorEvent(this.prov, type);
        event.setException(e);
        for (CopyTableListener listener : this.listeners) {
            listener.handleError(event);
        }
    }

    private void sendRecordEvent(int number, int count) {
        RecordEvent event = new RecordEvent(this.prov, number, count);
        for (CopyTableListener listener : this.listeners) {
            listener.recordCopied(event);
        }
    }

    private void sendStatementEvent(String sql, String[] vals) {
        StatementEvent event = new StatementEvent(sql, 3);
        event.setBindValues(vals);
        for (CopyTableListener listener : this.listeners) {
            listener.statementExecuted(event);
        }
    }

    private void notifyCopyFinished() {
        int seconds = (int)this.getElapsedSeconds();
        for (CopyTableListener listener : this.listeners) {
            listener.copyFinished(seconds);
        }
    }

    private long getElapsedSeconds() {
        long result = 1L;
        double elapsed = this.end - this.start;
        if (elapsed > 1000.0) {
            result = Math.round(elapsed / 1000.0);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTable(ITableInfo sourceTableInfo, int sourceTableCount) throws MappingException, SQLException, UserCancelledOperationException {
        PreparedStatement insertStmt = null;
        ResultSet rs = null;
        if (this.cancelled) {
            return;
        }
        if (!PreferencesManager.getPreferences().isCopyData()) {
            return;
        }
        ISQLConnection sourceConn = this.prov.getSourceSession().getSQLConnection();
        ISQLConnection destConn = this.prov.getDestSession().getSQLConnection();
        SQLDatabaseMetaData sourceMetaData = sourceConn.getSQLMetaData();
        SQLDatabaseMetaData destMetaData = destConn.getSQLMetaData();
        try {
            String destSchema = this.prov.getDestDatabaseObject().getSimpleName();
            ITableInfo destTableInfo = DBUtil.getTableInfo(this.prov.getDestSession(), destSchema, sourceTableInfo.getSimpleName());
            TableColumnInfo[] sourceInfos = sourceMetaData.getColumnInfo(sourceTableInfo);
            TableColumnInfo[] destInfos = destMetaData.getColumnInfo(destTableInfo);
            destInfos = this.sort(sourceInfos, destInfos, sourceTableInfo.getQualifiedName(), destTableInfo.getQualifiedName());
            String sourceColList = DBUtil.getColumnList(sourceInfos);
            String destColList = DBUtil.getColumnList(destInfos);
            String selectSQL = DBUtil.getSelectQuery(this.prov, sourceColList, sourceTableInfo);
            String insertSQL = DBUtil.getInsertSQL(this.prov, destColList, sourceTableInfo, destInfos.length);
            insertStmt = destConn.prepareStatement(insertSQL);
            int count = 1;
            int commitCount = prefs.getCommitCount();
            int columnCount = destInfos.length;
            String[] bindVarVals = new String[columnCount];
            boolean foundLOBType = false;
            DBUtil.setLastStatement(selectSQL);
            rs = DBUtil.executeQuery(this.prov.getSourceSession(), selectSQL);
            DBUtil.setLastStatement(insertSQL);
            boolean isMysql = DialectFactory.isMySQL(this.destSession.getMetaData());
            boolean isSourceOracle = DialectFactory.isOracle(this.sourceSession.getMetaData());
            boolean isDestOracle = DialectFactory.isOracle(this.destSession.getMetaData());
            while (rs.next() && !this.cancelled) {
                if (isMysql && foundLOBType) {
                    insertStmt.clearParameters();
                }
                StringBuilder lastStmtValuesBuffer = new StringBuilder();
                lastStmtValuesBuffer.append("\n(Bind variable values: ");
                for (int i = 0; i < columnCount; ++i) {
                    String bindVal;
                    int sourceColType = sourceInfos[i].getDataType();
                    sourceColType = DBUtil.replaceOtherDataType(sourceInfos[i], this.prov.getSourceSession());
                    sourceColType = this.getDateReplacement(sourceColType, isSourceOracle);
                    int destColType = destInfos[i].getDataType();
                    destColType = DBUtil.replaceOtherDataType(destInfos[i], this.prov.getDestSession());
                    destColType = this.getDateReplacement(destColType, isDestOracle);
                    bindVarVals[i] = bindVal = DBUtil.bindVariable(insertStmt, sourceColType, destColType, i + 1, rs);
                    lastStmtValuesBuffer.append(bindVal);
                    if (i + 1 < columnCount) {
                        lastStmtValuesBuffer.append(", ");
                    }
                    if (!this.isLOBType(destColType)) continue;
                    foundLOBType = true;
                }
                lastStmtValuesBuffer.append(")");
                DBUtil.setLastStatementValues(lastStmtValuesBuffer.toString());
                this.sendStatementEvent(insertSQL, bindVarVals);
                insertStmt.executeUpdate();
                this.sendRecordEvent(count, sourceTableCount);
                if (!this.currentAutoCommitValue && ++count % commitCount == 0) {
                    this.commitConnection(destConn);
                }
                this.sleep(prefs.getRecordDelayMillis());
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            SQLUtilities.closeStatement(insertStmt);
            if (!this.currentAutoCommitValue) {
                this.commitConnection(destConn);
            }
            throw throwable;
        }
        SQLUtilities.closeResultSet(rs);
        SQLUtilities.closeStatement(insertStmt);
        if (!this.currentAutoCommitValue) {
            this.commitConnection(destConn);
        }
    }

    private int getDateReplacement(int type, boolean isOracle) {
        int result = type;
        if (isOracle && type == 91) {
            result = 93;
        }
        return result;
    }

    private boolean isLOBType(int columnType) {
        return columnType == 2004 || columnType == 2005 || columnType == -4 || columnType == -2;
    }

    private TableColumnInfo[] sort(TableColumnInfo[] sourceInfos, TableColumnInfo[] destInfos, String sourceTableName, String destTableName) throws MappingException {
        if (sourceInfos.length != destInfos.length) {
            String msg = CopyExecutor.getMessage("CopyExecutor.tablecolmismatch", new Object[]{sourceTableName, sourceInfos.length, destTableName, destInfos.length});
            throw new MappingException(msg);
        }
        ArrayList<TableColumnInfo> result = new ArrayList<TableColumnInfo>();
        for (int sourceIdx = 0; sourceIdx < sourceInfos.length; ++sourceIdx) {
            TableColumnInfo sourceInfo = sourceInfos[sourceIdx];
            String sourceColumnName = sourceInfo.getColumnName().trim();
            boolean found = false;
            for (int destIdx = 0; !found && destIdx < destInfos.length; ++destIdx) {
                TableColumnInfo destInfo = destInfos[destIdx];
                String destColumnName = destInfo.getColumnName().trim();
                if (!destColumnName.equalsIgnoreCase(sourceColumnName)) continue;
                result.add(destInfo);
                found = true;
            }
            if (found) continue;
            throw new MappingException("Destination table " + destTableName + " doesn't appear to have a column named " + sourceInfo.getColumnName());
        }
        return result.toArray(new TableColumnInfo[destInfos.length]);
    }

    private void commitConnection(ISQLConnection connection) {
        try {
            connection.commit();
        }
        catch (SQLException e) {
            log.error("Failed to commit connection - " + connection, e);
        }
    }

    private void copyConstraints(List<IDatabaseObjectInfo> dbObjs) throws SQLException, UserCancelledOperationException {
        if (!prefs.isCopyForeignKeys() || DialectFactory.isAxion(this.prov.getSourceSession().getMetaData())) {
            return;
        }
        ISQLConnection destConn = this.prov.getDestSession().getSQLConnection();
        for (IDatabaseObjectInfo info : dbObjs) {
            ITableInfo ti = (ITableInfo)info;
            Set<String> fkStmts = DBUtil.getForeignKeySQL(this.prov, ti, this.selectedTableInfos);
            for (String fkSQL : fkStmts) {
                DBUtil.setLastStatementValues("");
                try {
                    DBUtil.executeUpdate(destConn, fkSQL, true);
                }
                catch (SQLException e) {
                    log.error("Unexpected exception while attempting to create FK constraint using sql = " + fkSQL, e);
                }
            }
        }
    }

    private void createTable(ITableInfo ti) throws SQLException, UserCancelledOperationException, MappingException {
        if (this.cancelled) {
            return;
        }
        ISQLConnection destCon = this.prov.getDestSession().getSQLConnection();
        String createTableSql = DBUtil.getCreateTableSql(this.prov, ti);
        if (log.isDebugEnabled()) {
            log.debug("Creating table in dest db with SQL: " + createTableSql);
        }
        DBUtil.executeUpdate(destCon, createTableSql, true);
        if (prefs.isCommitAfterTableDefs() && !this.currentAutoCommitValue) {
            this.commitConnection(destCon);
        }
        if (prefs.isCopyIndexDefs()) {
            List<String> indices = null;
            ISQLDatabaseMetaData sqlmd = this.sourceSession.getMetaData();
            if (prefs.isCopyPrimaryKeys()) {
                PrimaryKeyInfo[] pkList = sqlmd.getPrimaryKey(ti);
                List<PrimaryKeyInfo> pkList2 = Arrays.asList(pkList);
                indices = DialectUtils.createIndexes(ti, sqlmd, pkList2, new CreateScriptPreferences());
            } else {
                indices = DialectUtils.createIndexes(ti, sqlmd, null, new CreateScriptPreferences());
            }
            for (String createIndicesSql : indices) {
                DBUtil.executeUpdate(destCon, createIndicesSql, true);
            }
        }
    }

    public void setPref(UICallbacks pref) {
        this.pref = pref;
    }

    public UICallbacks getPref() {
        return this.pref;
    }
}

