/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.fw.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbcopy.CopyExecutor;
import net.sourceforge.squirrel_sql.plugins.dbcopy.I18NBaseObject;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbcopy.UICallbacks;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.AnalysisEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.CopyEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.CopyTableListener;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.ErrorEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.RecordEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.StatementEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.TableEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.gui.DualProgressBarDialog;
import net.sourceforge.squirrel_sql.plugins.dbcopy.util.DBUtil;

public class CopyProgressMonitor
extends I18NBaseObject
implements CopyTableListener,
UICallbacks {
    private SessionInfoProvider prov = null;
    private JFrame parent = null;
    private boolean deleteAllTableData = false;
    private CopyExecutor executor = null;
    private static final ILogger log = LoggerController.createLogger(CopyProgressMonitor.class);
    private ProgressMonitor pm = null;
    private static CommentSpec[] commentSpecs = new CommentSpec[]{new CommentSpec("/*", "*/"), new CommentSpec("--", "\n")};
    private static CodeReformator formatter = new CodeReformator(";", commentSpecs);

    public CopyProgressMonitor(SessionInfoProvider provider) {
        this.prov = provider;
        this.parent = this.prov.getDestSession().getApplication().getMainFrame();
    }

    @Override
    public void copyStarted(CopyEvent e) {
        if (this.pm != null) {
            this.pm.setProgress(this.pm.getMaximum());
        }
        this.prov = e.getSessionInfoProvider();
        int numTables = this.prov.getSourceDatabaseObjects().size();
        int[] tableCounts = e.getTableCounts();
        this.createProgressDialog();
        DualProgressBarDialog.setBottomBarMinMax(0, numTables);
        DualProgressBarDialog.setBottomBarValue(0);
        DualProgressBarDialog.setTopBarValue(0);
        DualProgressBarDialog.setTableCounts(tableCounts);
    }

    @Override
    public void tableCopyStarted(TableEvent e) {
        String bottomMessage = CopyProgressMonitor.getMessage("CopyProgressMonitor.copyingTable", new String[]{e.getTableName(), "" + e.getTableNumber(), "" + e.getTableCount()});
        DualProgressBarDialog.setBottomMessage(bottomMessage);
    }

    @Override
    public void recordCopied(RecordEvent e) {
        DualProgressBarDialog.setTopBarMinMax(0, e.getRecordCount());
        String topMessage = CopyProgressMonitor.getMessage("CopyProgressMonitor.copyingRecords", new String[]{"" + e.getRecordNumber(), "" + e.getRecordCount()});
        DualProgressBarDialog.setTopMessage(topMessage);
        DualProgressBarDialog.incrementTopBar(1);
    }

    @Override
    public void statementExecuted(StatementEvent e) {
    }

    @Override
    public void tableCopyFinished(TableEvent e) {
        DualProgressBarDialog.setTopBarValue(0);
        DualProgressBarDialog.incrementBottomBar(1);
    }

    @Override
    public void copyFinished(int seconds) {
        DualProgressBarDialog.stopTimer();
        DualProgressBarDialog.setVisible(false);
        DualProgressBarDialog.dispose();
        String title = CopyProgressMonitor.getMessage("CopyProgressMonitor.successTitle");
        String message = CopyProgressMonitor.getMessage("CopyProgressMonitor.successMessage", seconds);
        this.showMessageDialog(message, title, 1);
    }

    private String wordWrap(String data, int length) {
        String result = "";
        if (data.length() > length) {
            String[] parts = data.split("\\s");
            StringBuffer tmp = new StringBuffer();
            int count = 0;
            for (int i = 0; i < parts.length; ++i) {
                if ((count += parts[i].length()) > length) {
                    count = 0;
                    tmp.append("\n");
                } else {
                    tmp.append(" ");
                }
                tmp.append(parts[i]);
            }
            result = tmp.toString();
        } else {
            result = data;
        }
        return result;
    }

    @Override
    public void handleError(ErrorEvent e) {
        String title;
        int messageType;
        String title2;
        String message;
        String exMsg;
        DualProgressBarDialog.stopTimer();
        DualProgressBarDialog.setVisible(false);
        if (e.getType() == 0) {
            exMsg = "";
            if (e.getException() != null) {
                exMsg = e.getException().getMessage();
            }
            message = CopyProgressMonitor.getMessage("CopyProgressMonitor.setupAutoCommitException", exMsg);
            title2 = CopyProgressMonitor.getMessage("CopyProgressMonitor.setupAutoCommitExceptionTitle");
            messageType = 0;
            this.showMessageDialog(message, title2, messageType);
        }
        if (e.getType() == 1) {
            exMsg = "";
            if (e.getException() != null) {
                exMsg = e.getException().getMessage();
            }
            message = CopyProgressMonitor.getMessage("CopyProgressMonitor.restoreAutoCommitException", exMsg);
            title2 = CopyProgressMonitor.getMessage("CopyProgressMonitor.restoreAutoCommitExceptionTitle");
            messageType = 0;
            this.showMessageDialog(message, title2, messageType);
        }
        if (e.getType() == 2) {
            String exMessage = this.wordWrap(e.getException().getMessage(), 80);
            String sql = formatter.reformat(DBUtil.getLastStatement());
            String values = DBUtil.getLastStatementValues();
            String sqlAndValues = sql;
            sqlAndValues = values != null ? sqlAndValues + values : sqlAndValues + "\n(No bind variables)";
            int errorCode = ((SQLException)e.getException()).getErrorCode();
            log.error("SQL Error code = " + errorCode + " sql = " + sqlAndValues, e.getException());
            String message2 = CopyProgressMonitor.getMessage("CopyProgressMonitor.sqlErrorMessage", new String[]{exMessage, "" + errorCode, sqlAndValues});
            String title3 = CopyProgressMonitor.getMessage("CopyProgressMonitor.sqlErrorTitle");
            this.showMessageDialog(message2, title3, 0);
        }
        if (e.getType() == 3) {
            title = CopyProgressMonitor.getMessage("CopyProgressMonitor.mappingErrorTitle");
            message = this.getMappingExceptionMessage(e.getException());
            log.error(message, e.getException());
            this.showMessageDialog(message, title, 0);
            if (this.pm != null) {
                this.pm.setProgress(this.pm.getMaximum());
            }
        }
        if (e.getType() == 4) {
            title = CopyProgressMonitor.getMessage("CopyProgressMonitor.cancelledTitle");
            message = CopyProgressMonitor.getMessage("CopyProgressMonitor.cancelledMessage");
            this.showMessageDialog(message, title, 1);
        }
        if (e.getType() == 5) {
            String exmessage = e.getException().getMessage();
            message = CopyProgressMonitor.getMessage("CopyProgressMonitor.errorMessage", new String[]{exmessage});
            title2 = CopyProgressMonitor.getMessage("CopyProgressMonitor.errorTitle");
            this.showMessageDialog(message, title2, 1);
        }
        if (e.getException() != null) {
            log.error("handleError: exception=" + e.getException().getMessage(), e.getException());
        }
    }

    private String getMappingExceptionMessage(Exception e) {
        String message = "";
        if (e.getMessage().indexOf(":") != -1) {
            String[] parts = e.getMessage().split(":");
            try {
                int typeCode = Integer.parseInt(parts[1].trim());
                String typeName = JDBCTypeMapper.getJdbcTypeName(typeCode);
                message = CopyProgressMonitor.getMessage("CopyProgressMonitor.mappingErrorMessage", new String[]{e.getMessage(), typeName});
            }
            catch (NumberFormatException nfe) {
                message = e.getMessage();
            }
        } else {
            message = e.getMessage();
        }
        return message;
    }

    private void showMessageDialog(final String message, final String title, final int messageType) {
        final JFrame f = this.parent;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(f, message, title, messageType);
            }
        });
    }

    private void createProgressDialog() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CopyProgressMonitor.this.executor.cancel();
            }
        };
        DualProgressBarDialog.getDialog(this.parent, CopyProgressMonitor.getMessage("CopyProgressMonitor.copyProgressDialogTitle"), false, listener);
        DualProgressBarDialog.startTimer();
    }

    public void setExecutor(CopyExecutor executor) {
        this.executor = executor;
    }

    public CopyExecutor getExecutor() {
        return this.executor;
    }

    private int showConfirmDeleteDialog(String tableName) {
        final String message = CopyProgressMonitor.getMessage("CopyProgressMonitor.deleteRecordsMessage", tableName);
        final ConfirmMessageResult result = new ConfirmMessageResult();
        Object[] buttons = new String[]{"Yes", "Yes to all", "No", "Cancel"};
        if (SwingUtilities.isEventDispatchThread()) {
            result.option = JOptionPane.showOptionDialog(this.parent, message, "Confirmation", -1, 3, null, buttons, buttons[2]);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable((String[])buttons){
                    final /* synthetic */ String[] val$buttons;
                    {
                        this.val$buttons = stringArray;
                    }

                    @Override
                    public void run() {
                        result.option = JOptionPane.showOptionDialog(CopyProgressMonitor.this.parent, message, "Confirmation", -1, 3, null, this.val$buttons, this.val$buttons[2]);
                    }
                });
            }
            catch (Exception e) {
                log.error("showConfirmDeleteDialog: encountered unexpected exception ", e);
            }
        }
        return result.option;
    }

    private String showTextInputDialog(final Object message, final String title, final int messageType, final Icon icon, final Object initialValue) {
        final StringBuffer result = new StringBuffer();
        if (SwingUtilities.isEventDispatchThread()) {
            String tmp = (String)JOptionPane.showInputDialog(this.parent, message, title, messageType, icon, null, initialValue);
            result.append(tmp);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String tmp = (String)JOptionPane.showInputDialog(CopyProgressMonitor.this.parent, message, title, messageType, icon, null, initialValue);
                        result.append(tmp);
                    }
                });
            }
            catch (Exception e) {
                log.error("showTextInputDialog: encountered unexpected exception ", e);
            }
        }
        return result.toString();
    }

    @Override
    public boolean deleteTableData(String tableName) throws UserCancelledOperationException {
        if (this.deleteAllTableData) {
            return true;
        }
        int option = this.showConfirmDeleteDialog(tableName);
        if (option == 0) {
            return true;
        }
        if (option == 1) {
            this.deleteAllTableData = true;
            return true;
        }
        if (option == 2) {
            return false;
        }
        if (option == 3) {
            throw new UserCancelledOperationException();
        }
        return false;
    }

    @Override
    public boolean appendRecordsToExisting(String tableName) {
        return false;
    }

    @Override
    public void analyzingTable(TableEvent e) {
        if (this.pm.isCanceled()) {
            // empty if block
        }
        this.pm.setNote(CopyProgressMonitor.getMessage("CopyProgressMonitor.analyzingTableMessage") + e.getTableName());
        this.pm.setProgress(e.getTableNumber());
    }

    @Override
    public void tableAnalysisStarted(AnalysisEvent e) {
        SessionInfoProvider prov = e.getSessionInfoProvider();
        this.pm = new ProgressMonitor(this.parent, "Analyzing column names in tables to be copied", "", 0, prov.getSourceDatabaseObjects().size());
    }

    class ConfirmMessageResult {
        int option;

        ConfirmMessageResult() {
        }
    }
}

