/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.actions;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbcopy.DBCopyPlugin;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbcopy.commands.PasteTableCommand;

public class PasteTableAction
extends SquirrelAction
implements ISessionAction {
    private static final long serialVersionUID = 1L;
    private final SessionInfoProvider sessionInfoProv;
    private IApplication app = null;
    private static final ILogger log = LoggerController.createLogger(PasteTableAction.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PasteTableAction.class);

    public PasteTableAction(IApplication app, Resources rsrc, DBCopyPlugin plugin) {
        super(app, rsrc);
        this.app = app;
        this.sessionInfoProv = plugin;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ISession destSession = this.sessionInfoProv.getDestSession();
        IObjectTreeAPI api = destSession.getObjectTreeAPIOfActiveSessionWindow();
        if (api == null) {
            return;
        }
        IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
        if (dbObjs.length > 1) {
            this.sessionInfoProv.setDestDatabaseObject(null);
            String msg = s_stringMgr.getString("PasteTableAction.error.multischemapaste");
            this.app.showErrorDialog(msg);
            return;
        }
        if (DatabaseObjectType.TABLE_TYPE_DBO.equals(dbObjs[0].getDatabaseObjectType())) {
            IDatabaseObjectInfo tableLabelInfo = dbObjs[0];
            ISQLConnection destCon = destSession.getSQLConnection();
            SQLDatabaseMetaData md = null;
            if (destCon != null) {
                md = destCon.getSQLMetaData();
            }
            DatabaseObjectInfo schema = new DatabaseObjectInfo(null, tableLabelInfo.getSchemaName(), tableLabelInfo.getSchemaName(), DatabaseObjectType.SCHEMA, md);
            this.sessionInfoProv.setDestDatabaseObject(schema);
        } else {
            this.sessionInfoProv.setDestDatabaseObject(dbObjs[0]);
        }
        try {
            IDatabaseObjectInfo info = this.sessionInfoProv.getDestDatabaseObject();
            if (info == null || destSession == null) {
                return;
            }
            if (!this.checkSession(destSession, info)) {
                return;
            }
        }
        catch (UserCancelledOperationException e) {
            return;
        }
        if (this.sessionInfoProv.getSourceSession() == null) {
            return;
        }
        if (!this.sourceDestSchemasDiffer()) {
            return;
        }
        new PasteTableCommand(this.sessionInfoProv).execute();
    }

    @Override
    public void setSession(ISession session) {
        this.sessionInfoProv.setDestSession(session);
    }

    private boolean checkSession(ISession session, IDatabaseObjectInfo dbObj) throws UserCancelledOperationException {
        if (session == null || dbObj == null) {
            return true;
        }
        String typeName = dbObj.getDatabaseObjectType().getName();
        log.debug("PasteTableAction.checkSession: dbObj type=" + typeName + " name=" + dbObj.getSimpleName());
        HibernateDialect d = DialectFactory.getDialect(1, session.getApplication().getMainFrame(), session.getMetaData());
        if (!d.canPasteTo(dbObj)) {
            String errmsg = s_stringMgr.getString("PasteTableAction.error.destdbobj", typeName);
            this.app.showErrorDialog(errmsg);
            return false;
        }
        return true;
    }

    private boolean sourceDestSchemasDiffer() {
        return true;
    }
}

