/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineArgumentProcessor {
    public static final String SOURCE_CATALOG = "source-catalog";
    public static final String SOURCE_SCHEMA = "source-schema";
    public static final String DEST_CATALOG = "dest-catalog";
    public static final String DEST_SCHEMA = "dest-schema";
    public static final String TABLE_PATTERN = "table-pattern";
    public static final String TABLE_LIST = "table-list";
    public static final String DEST_SESSION = "dest-alias";
    public static final String SOURCE_SESSION = "source-alias";
    private Options options = new Options();
    private CommandLine cmd = null;

    public CommandLineArgumentProcessor(String[] args) throws ParseException {
        this.createOptions();
        GnuParser parser = new GnuParser();
        try {
            this.cmd = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            System.out.println(e.getMessage());
            System.out.println();
            formatter.printHelp("DBCopyCLI", this.options, true);
            throw e;
        }
    }

    private void createOptions() {
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt(SOURCE_SESSION);
        OptionBuilder.withDescription("The name of the source alias to copy tables from");
        Option sourceOption = OptionBuilder.create();
        this.options.addOption(sourceOption);
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt(DEST_SESSION);
        OptionBuilder.withDescription("The name of the destination alias to copy tables to");
        Option destOption = OptionBuilder.create();
        this.options.addOption(destOption);
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt(SOURCE_SCHEMA);
        OptionBuilder.withDescription("The source schema to copy tables from");
        Option sourceSchemaOption = OptionBuilder.create();
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt(SOURCE_CATALOG);
        OptionBuilder.withDescription("The source catalog to copy tables from");
        Option sourceCatalogOption = OptionBuilder.create();
        OptionGroup sourceSchemaGroup = new OptionGroup();
        sourceSchemaGroup.setRequired(true);
        sourceSchemaGroup.addOption(sourceSchemaOption);
        sourceSchemaGroup.addOption(sourceCatalogOption);
        this.options.addOptionGroup(sourceSchemaGroup);
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt(TABLE_LIST);
        OptionBuilder.withDescription("A comma-delimited list of tables to copy");
        Option listOption = OptionBuilder.create();
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt(TABLE_PATTERN);
        OptionBuilder.withDescription("A regexp pattern to match source table names");
        Option patternOption = OptionBuilder.create();
        OptionGroup tableGroup = new OptionGroup();
        tableGroup.setRequired(true);
        tableGroup.addOption(listOption);
        tableGroup.addOption(patternOption);
        this.options.addOptionGroup(tableGroup);
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt(DEST_SCHEMA);
        OptionBuilder.withDescription("The destination schema to copy tables into");
        Option destSchemaOption = OptionBuilder.create();
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt(DEST_CATALOG);
        OptionBuilder.withDescription("The destination catalog to copy tables into");
        Option destCatalogOption = OptionBuilder.create();
        OptionGroup destSchemaGroup = new OptionGroup();
        destSchemaGroup.setRequired(true);
        destSchemaGroup.addOption(destSchemaOption);
        destSchemaGroup.addOption(destCatalogOption);
        this.options.addOptionGroup(destSchemaGroup);
    }

    public String getSourceAliasName() {
        return this.cmd.getOptionValue(SOURCE_SESSION);
    }

    public String getDestAliasName() {
        return this.cmd.getOptionValue(DEST_SESSION);
    }

    public String getDestSchemaName() {
        return this.cmd.getOptionValue(DEST_SCHEMA);
    }

    public String getDestCatalogName() {
        return this.cmd.getOptionValue(DEST_CATALOG);
    }

    public String getSourceCatalogName() {
        return this.cmd.getOptionValue(SOURCE_CATALOG);
    }

    public String getSourceSchemaName() {
        return this.cmd.getOptionValue(SOURCE_SCHEMA);
    }

    public String getTablePattern() {
        return this.cmd.getOptionValue(TABLE_PATTERN);
    }

    public List<String> getTableList() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.hasTableList()) {
            String tableListStr = this.cmd.getOptionValue(TABLE_LIST);
            if (tableListStr.contains(",")) {
                String[] parts;
                for (String part : parts = tableListStr.split(",")) {
                    result.add(part);
                }
            } else {
                result.add(tableListStr);
            }
        }
        return result;
    }

    public boolean hasTableList() {
        return this.cmd.hasOption(TABLE_LIST);
    }
}

