/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.cli;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.plugins.dbcopy.CopyExecutor;
import net.sourceforge.squirrel_sql.plugins.dbcopy.DBCopyPlugin;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbcopy.cli.CLCopyListener;
import net.sourceforge.squirrel_sql.plugins.dbcopy.cli.CLCopyUICallback;
import net.sourceforge.squirrel_sql.plugins.dbcopy.cli.SessionInfoProviderImpl;
import net.sourceforge.squirrel_sql.plugins.dbcopy.prefs.PreferencesManager;
import net.sourceforge.squirrel_sql.plugins.dbcopy.util.DBUtil;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCopyRunner {
    private SessionInfoProvider sessionInfoProvider = new SessionInfoProviderImpl();
    private ArrayList<ITableInfo> tables = new ArrayList();
    private CLCopyListener listener = new CLCopyListener();
    private String sourceSchemaName = null;
    private String sourceCatalogName = null;
    private String destSchemaName = null;
    private String destCatalogName = null;

    public void run() throws Exception {
        String simpleName = StringUtils.isEmpty(this.destSchemaName) ? this.destCatalogName : this.destSchemaName;
        this.sessionInfoProvider.setSourceDatabaseObjects(DBUtil.convertTableToObjectList(this.tables));
        DatabaseObjectInfo destObject = new DatabaseObjectInfo(this.destCatalogName, this.destSchemaName, simpleName, DatabaseObjectType.SCHEMA, this.sessionInfoProvider.getDestSession().getMetaData());
        this.sessionInfoProvider.setDestDatabaseObject(destObject);
        PreferencesManager.initialize(new DBCopyPlugin());
        DBUtil.setPreferences(PreferencesManager.getPreferences());
        DialectFactory.isPromptForDialect = false;
        CopyExecutor executor = new CopyExecutor(this.sessionInfoProvider);
        executor.addListener(this.listener);
        executor.setPref(new CLCopyUICallback());
        executor.execute();
        while (!this.listener.isCopyFinished()) {
            Thread.sleep(2000L);
        }
        this.listener.checkErrors();
    }

    public void setSourceSession(ISession sourceSession) {
        this.sessionInfoProvider.setSourceSession(sourceSession);
    }

    public void setDestSession(ISession destSession) {
        this.sessionInfoProvider.setDestSession(destSession);
    }

    private ITableInfo getTableInfo(ISession session, String schemaName, String catalogName, String tableName) throws SQLException {
        ISQLDatabaseMetaData md = session.getMetaData();
        ITableInfo[] result = md.getTables(catalogName, schemaName, tableName, new String[]{"TABLE"}, null);
        if (result.length == 0) {
            throw new IllegalStateException("Source table to be copied (" + tableName + ") could not be located in schema (" + schemaName + ") and/or catalog (" + catalogName + ") for alias: " + session.getAlias().getName());
        }
        return result[0];
    }

    public void setSourceSchemaName(String sourceSchemaName) {
        this.sourceSchemaName = sourceSchemaName;
    }

    public void setSourceCatalogName(String sourceCatalogName) {
        this.sourceCatalogName = sourceCatalogName;
    }

    public void setTablePattern(String pattern) throws SQLException {
        ISession sourceSession = this.sessionInfoProvider.getSourceSession();
        String catalog = this.sourceCatalogName == null || this.sourceCatalogName.equals("") ? null : this.sourceCatalogName;
        String schema = this.sourceSchemaName == null || this.sourceSchemaName.equals("") ? null : this.sourceSchemaName;
        ISQLDatabaseMetaData md = sourceSession.getMetaData();
        ITableInfo[] infos = md.getTables(catalog, schema, pattern, new String[]{"TABLE"}, null);
        if (infos == null || infos.length == 0) {
            System.err.println("No tables were found that match the specified :");
            System.err.println(" catalog: " + catalog);
            System.err.println(" schema: " + schema);
            System.err.println(" pattern: " + pattern);
        }
        for (ITableInfo info : infos) {
            this.tables.add(info);
        }
    }

    public void setTableList(List<String> tableList) throws SQLException {
        for (String tableStr : tableList) {
            this.tables.add(this.getTableInfo(this.sessionInfoProvider.getSourceSession(), this.sourceSchemaName, this.sourceCatalogName, tableStr));
        }
    }

    public void setTableList(String tableListStr) throws SQLException {
        String[] parts;
        for (String tableStr : parts = tableListStr.split(",")) {
            this.tables.add(this.getTableInfo(this.sessionInfoProvider.getSourceSession(), this.sourceSchemaName, this.sourceCatalogName, tableStr));
        }
    }

    public void setDestSchemaName(String destSchemaName) {
        this.destSchemaName = destSchemaName;
    }

    public void setDestCatalogName(String destCatalogName) {
        this.destCatalogName = destCatalogName;
    }
}

