/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.cli;

import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.DataCache;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionManager;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.plugins.dbcopy.cli.ApplicationStub;

public class SessionUtil {
    private DataCache dataCache = null;
    private IApplication applicationStub = new ApplicationStub();
    private SQLDriverManager sqlDriverManager = new SQLDriverManager();
    private ApplicationFiles applicationFiles = new ApplicationFiles();
    private SquirrelResources squirrelResources = new SquirrelResources("net.sourceforge.squirrel_sql.client.resources.squirrel");

    public SessionUtil() {
        this.dataCache = new DataCache(this.sqlDriverManager, this.applicationFiles.getDatabaseDriversFile(), this.applicationFiles.getDatabaseAliasesFile(), this.squirrelResources.getDefaultDriversUrl(), this.applicationStub);
    }

    public ISession getSessionForAlias(String alias) throws Exception {
        System.out.println("Creating session for alias: " + alias);
        Iterator<ISQLAlias> i = this.dataCache.aliases();
        while (i.hasNext()) {
            ISQLAlias sqlAlias = i.next();
            if (!alias.equals(sqlAlias.getName())) continue;
            ISQLDriver sqlDriver = this.dataCache.getDriver(sqlAlias.getDriverIdentifier());
            this.sqlDriverManager.registerSQLDriver(sqlDriver);
            SQLConnection conn = this.sqlDriverManager.getConnection(sqlDriver, sqlAlias, sqlAlias.getUserName(), sqlAlias.getPassword(), sqlAlias.getDriverPropertiesClone());
            SessionManager sessionManager = this.applicationStub.getSessionManager();
            ISession result = sessionManager.createSession(this.applicationStub, sqlDriver, (SQLAlias)sqlAlias, conn, sqlAlias.getUserName(), sqlAlias.getPassword());
            return result;
        }
        throw new RuntimeException("Alias (" + alias + ") was not found");
    }
}

