/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DualProgressBarDialog {
    private static JProgressBar topBar = null;
    private static JLabel topMessage = null;
    private static JProgressBar bottomBar = null;
    private static JLabel bottomMessage = null;
    private static JButton cancelButton = null;
    private static JDialog dialog = null;
    private static JLabel elapsedTime = null;
    private static TimeCounter elapsedTimeCounter = null;
    private static JLabel remainingTime = null;
    private static TimeCounter remainingTimeCounter = null;
    private static TimeTracker timeTracker = null;
    private static RemainingTimeCalculator remainingCalc = null;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DualProgressBarDialog.class);
    private static final ILogger log = LoggerController.createLogger(DualProgressBarDialog.class);

    public static JDialog getDialog(final Frame owner, final String title, final boolean modal, final ActionListener listener) {
        if (SwingUtilities.isEventDispatchThread()) {
            DualProgressBarDialog._getDialog(owner, title, modal, listener);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DualProgressBarDialog._getDialog(owner, title, modal, listener);
                    }
                });
            }
            catch (Exception e) {
                log.error(s_stringMgr.getString("DualProgressBarDialog.error.getdialog"), e);
            }
        }
        return dialog;
    }

    public static void startTimer() {
        if (timeTracker != null) {
            timeTracker.setRunning(false);
        }
        remainingCalc = new RemainingTimeCalculator();
        timeTracker = new TimeTracker();
    }

    public static void stopTimer() {
        if (timeTracker != null) {
            timeTracker.setRunning(false);
        }
    }

    private static void _getDialog(Frame owner, String title, boolean modal, ActionListener listener) {
        dialog = new JDialog(owner, title, modal);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)DualProgressBarDialog.buildPanel(), "Center");
        dialog.getContentPane().add((Component)DualProgressBarDialog.buildButtonPanel(listener), "South");
        dialog.setSize(350, 205);
        dialog.setLocationRelativeTo(owner);
        cancelButton.addActionListener(new CancelButtonListener(dialog));
        dialog.setVisible(true);
    }

    private static JPanel buildPanel() {
        JPanel dataPanel = new JPanel();
        dataPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        GridBagLayout gl = new GridBagLayout();
        dataPanel.setLayout(gl);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        String topLabelText = s_stringMgr.getString("DualProgressBarDialog.copyingRecordsLabel");
        topMessage = new JLabel(topLabelText);
        dataPanel.add((Component)topMessage, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 10, 0);
        c.weightx = 1.0;
        topBar = new JProgressBar(0, 10);
        dataPanel.add((Component)topBar, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 17;
        String bottomLabelText = s_stringMgr.getString("DualProgressBarDialog.copyingTablesLabel");
        bottomMessage = new JLabel(bottomLabelText);
        dataPanel.add((Component)bottomMessage, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 10, 0);
        bottomBar = new JProgressBar(0, 10);
        dataPanel.add((Component)bottomBar, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.ipadx = 5;
        c.anchor = 10;
        c.fill = 2;
        dataPanel.add((Component)DualProgressBarDialog.buildTimePanel(), c);
        return dataPanel;
    }

    public static JPanel buildTimePanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridLayout(2, 2, 5, 5));
        JLabel elapsedTimeLabel = new JLabel(s_stringMgr.getString("DualProgressBarDialog.elapsedTimeLabel"));
        elapsedTimeCounter = new TimeCounter();
        elapsedTime = new JLabel(elapsedTimeCounter.toString());
        JLabel remainingTimeLabel = new JLabel(s_stringMgr.getString("DualProgressBarDialog.remainingTimeLabel"));
        remainingTimeCounter = new TimeCounter();
        remainingTime = new JLabel(remainingTimeCounter.toString());
        elapsedTimeLabel.setHorizontalAlignment(4);
        result.add(elapsedTimeLabel);
        elapsedTime.setHorizontalAlignment(2);
        result.add(elapsedTime);
        remainingTimeLabel.setHorizontalAlignment(4);
        result.add(remainingTimeLabel);
        remainingTime.setHorizontalAlignment(2);
        result.add(remainingTime);
        return result;
    }

    public static JPanel buildButtonPanel(ActionListener listener) {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        String buttonText = s_stringMgr.getString("DualProgressBarDialog.cancelButtonLabel");
        cancelButton = new JButton(buttonText);
        if (listener != null) {
            cancelButton.addActionListener(listener);
        }
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    public static void setTopMessage(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            topMessage.setText(message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    topMessage.setText(message);
                }
            });
        }
    }

    public static void setBottomMessage(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            bottomMessage.setText(message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    bottomMessage.setText(message);
                }
            });
        }
    }

    public static void setTopBarMinMax(final int min, final int max) {
        if (topBar.getMinimum() == min && topBar.getMaximum() == max) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            topBar.setMinimum(min);
            topBar.setMaximum(max);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    topBar.setMinimum(min);
                    topBar.setMaximum(max);
                }
            });
        }
    }

    public static void setBottomBarMinMax(final int min, final int max) {
        if (bottomBar.getMinimum() == min && bottomBar.getMaximum() == max) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            bottomBar.setMinimum(min);
            bottomBar.setMaximum(max);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    bottomBar.setMinimum(min);
                    bottomBar.setMaximum(max);
                }
            });
        }
    }

    public static void setTopBarValue(final int value) {
        if (SwingUtilities.isEventDispatchThread()) {
            topBar.setValue(value);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    topBar.setValue(value);
                }
            });
        }
    }

    public static void setTableCounts(int[] tableCounts) {
        for (int i = 0; i < tableCounts.length; ++i) {
            remainingCalc.setTotalItems(remainingCalc.getTotalItems() + (long)tableCounts[i]);
        }
    }

    public static void setBottomBarValue(final int value) {
        if (SwingUtilities.isEventDispatchThread()) {
            bottomBar.setValue(value);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    bottomBar.setValue(value);
                }
            });
        }
    }

    public static void incrementTopBar(int value) {
        final int newValue = topBar.getValue() + value;
        remainingCalc.incrementCurrentItem();
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                topBar.setValue(newValue);
            }
        }, true);
    }

    public static void incrementBottomBar(int value) {
        final int newValue = bottomBar.getValue() + value;
        if (SwingUtilities.isEventDispatchThread()) {
            bottomBar.setValue(newValue);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    bottomBar.setValue(newValue);
                }
            });
        }
    }

    public static void setVisible(final boolean visible) {
        if (dialog == null) {
            return;
        }
        if (dialog.isVisible() != visible) {
            if (SwingUtilities.isEventDispatchThread()) {
                dialog.setVisible(visible);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dialog.setVisible(visible);
                    }
                });
            }
        }
    }

    public static void dispose() {
        if (dialog == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            dialog.dispose();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dialog.dispose();
                }
            });
        }
    }

    public static void addCancelButtonActionListener(ActionListener listener) {
        if (cancelButton != null) {
            cancelButton.addActionListener(listener);
        }
    }

    private static class RemainingTimeCalculator {
        private long currentItem = 0L;
        private long totalItems = 0L;
        private long secondsElapsed = 0L;
        private long secondsRemaining = 0L;

        private RemainingTimeCalculator() {
        }

        public void incrementCurrentItem() {
            if (this.currentItem < this.totalItems) {
                ++this.currentItem;
            }
        }

        public void setCurrentItem(long anInt) {
            if (this.currentItem <= this.totalItems) {
                this.currentItem = anInt;
            } else {
                System.err.println("currentItem(" + this.currentItem + ") > totalItems(" + this.totalItems + ") ");
            }
        }

        public long getTotalItems() {
            return this.totalItems;
        }

        public void setTotalItems(long anInt) {
            this.totalItems = anInt;
        }

        public void setTimeElapsed(TimeCounter counter) {
            this.secondsElapsed = 0L;
            this.secondsElapsed += (long)(counter.getHours() * 3600);
            this.secondsElapsed += (long)(counter.getMinutes() * 60);
            this.secondsElapsed += (long)counter.getSeconds();
            this.calculateRemaining();
        }

        public TimeCounter getTimeRemaining(TimeCounter counter) {
            int hoursRemaining = (int)(this.secondsRemaining / 3600L);
            counter.setHours(hoursRemaining);
            long hoursRemainder = this.secondsRemaining - (long)(hoursRemaining * 3600);
            int minutesRemaining = (int)(hoursRemainder / 60L);
            counter.setMinutes(minutesRemaining);
            int secondsRemaining = (int)(hoursRemainder - (long)(minutesRemaining * 60));
            counter.setSeconds(secondsRemaining);
            return counter;
        }

        private void calculateRemaining() {
            float avgTimePerItem = 0.0f;
            avgTimePerItem = this.currentItem > 1L ? (float)this.secondsElapsed / (float)(this.currentItem - 1L) : (float)this.secondsElapsed;
            long itemsLeft = this.totalItems - this.currentItem + 1L;
            this.secondsRemaining = (int)((float)itemsLeft * avgTimePerItem);
        }
    }

    private static class TimeCounter {
        private int seconds = 0;
        private int minutes = 0;
        private int hours = 0;

        private TimeCounter() {
        }

        public void reset() {
            this.seconds = 0;
            this.minutes = 0;
            this.hours = 0;
        }

        public void increment() {
            if (this.seconds < 59) {
                ++this.seconds;
                return;
            }
            if (this.minutes < 59) {
                this.seconds = 0;
                ++this.minutes;
                return;
            }
            ++this.hours;
            this.minutes = 0;
            this.seconds = 0;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public void setSeconds(int seconds) {
            this.seconds = seconds;
        }

        public int getMinutes() {
            return this.minutes;
        }

        public void setMinutes(int minutes) {
            this.minutes = minutes;
        }

        public int getHours() {
            return this.hours;
        }

        public void setHours(int hours) {
            this.hours = hours;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            if (this.hours < 10) {
                result.append("0");
            }
            result.append(this.hours);
            result.append(":");
            if (this.minutes < 10) {
                result.append("0");
            }
            result.append(this.minutes);
            result.append(":");
            if (this.seconds < 10) {
                result.append("0");
            }
            result.append(this.seconds);
            return result.toString();
        }
    }

    private static class TimeTracker
    implements Runnable {
        private Thread t = new Thread(this);
        private boolean running = true;

        public TimeTracker() {
            this.t.setName("DBCopy Time Tracker");
            this.t.start();
        }

        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                elapsedTimeCounter.increment();
                remainingCalc.setTimeElapsed(elapsedTimeCounter);
                remainingCalc.getTimeRemaining(remainingTimeCounter);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String timeStr = elapsedTimeCounter.toString();
                        elapsedTime.setText(timeStr);
                        remainingTime.setText(remainingTimeCounter.toString());
                    }
                });
            }
        }

        public void setRunning(boolean aBoolean) {
            this.running = aBoolean;
        }
    }

    private static class CancelButtonListener
    implements ActionListener {
        JDialog _dialog = null;

        public CancelButtonListener(JDialog dialog) {
            this._dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._dialog != null) {
                DualProgressBarDialog.setVisible(false);
                this._dialog.dispose();
            }
        }
    }
}

