/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.prefs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PreferenceUtil;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.dbcopy.prefs.DBCopyPreferenceBean;

public class PreferencesManager {
    private static final ILogger s_log = LoggerController.createLogger(PreferencesManager.class);
    private static final String USER_PREFS_FILE_NAME = "prefs.xml";
    private static FileWrapper _userSettingsFolder;
    private static FileWrapperFactory fileWrapperFactory;
    private static DBCopyPreferenceBean _prefs;
    private static IPlugin plugin;

    public static void initialize(IPlugin thePlugin) throws PluginException {
        plugin = thePlugin;
        try {
            _userSettingsFolder = plugin.getPluginUserSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException(ex);
        }
        PreferencesManager.loadPrefs();
    }

    public static DBCopyPreferenceBean getPreferences() {
        return _prefs;
    }

    public static void unload() {
        PreferencesManager.savePrefs();
    }

    public static void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        Utilities.checkNull("setFileWrapperFactory", "fileWrapperFactory", fileWrapperFactory);
        PreferencesManager.fileWrapperFactory = fileWrapperFactory;
    }

    public static void savePrefs() {
        try {
            XMLBeanWriter wtr = new XMLBeanWriter(_prefs);
            wtr.save(fileWrapperFactory.create(_userSettingsFolder, USER_PREFS_FILE_NAME));
        }
        catch (Exception ex) {
            s_log.error("Error occured writing to preferences file: prefs.xml", ex);
        }
    }

    private static void loadPrefs() {
        FileWrapper prefFile = null;
        try {
            XMLBeanReader doc = new XMLBeanReader();
            prefFile = PreferenceUtil.getPreferenceFileToReadFrom(plugin);
            doc.load(prefFile, DBCopyPreferenceBean.class.getClassLoader());
            Iterator<Object> it = doc.iterator();
            if (it.hasNext()) {
                _prefs = (DBCopyPreferenceBean)it.next();
            }
        }
        catch (FileNotFoundException ignore) {
            s_log.info("prefs.xml(" + prefFile.getAbsolutePath() + ") not found - will be created");
        }
        catch (Exception ex) {
            s_log.error("Error occured reading from preferences file: prefs.xml", ex);
        }
        if (_prefs == null) {
            _prefs = new DBCopyPreferenceBean();
        }
        _prefs.setClientName(Version.getApplicationName() + "/" + plugin.getDescriptiveName());
        _prefs.setClientVersion(Version.getShortVersion() + "/" + plugin.getVersion());
    }

    static {
        fileWrapperFactory = new FileWrapperFactoryImpl();
        _prefs = null;
        plugin = null;
    }
}

