/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context;

import java.util.Hashtable;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.classic.Session;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.util.JTAHelper;

public class JTASessionContext
implements CurrentSessionContext {
    private static final Log log = LogFactory.getLog(JTASessionContext.class);
    protected final SessionFactoryImplementor factory;
    private transient Map currentSessionMap = new Hashtable();

    public JTASessionContext(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    public Session currentSession() throws HibernateException {
        TransactionManager transactionManager = this.factory.getTransactionManager();
        if (transactionManager == null) {
            throw new HibernateException("No TransactionManagerLookup specified");
        }
        Transaction txn = null;
        try {
            txn = transactionManager.getTransaction();
            if (txn == null) {
                throw new HibernateException("Unable to locate current JTA transaction");
            }
            if (!JTAHelper.isInProgress(txn.getStatus())) {
                throw new HibernateException("Current transaction is not in progress");
            }
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new HibernateException("Problem locating/validating JTA transaction", t);
        }
        Session currentSession = (Session)this.currentSessionMap.get(txn);
        if (currentSession == null) {
            currentSession = this.buildOrObtainSession();
            try {
                txn.registerSynchronization((Synchronization)this.buildCleanupSynch(txn));
            }
            catch (Throwable t) {
                try {
                    currentSession.close();
                }
                catch (Throwable ignore) {
                    log.debug("Unable to release generated current-session on failed synch registration", ignore);
                }
                throw new HibernateException("Unable to register cleanup Synchronization with TransactionManager");
            }
            this.currentSessionMap.put(txn, currentSession);
        }
        return currentSession;
    }

    private CleanupSynch buildCleanupSynch(Transaction txn) {
        return new CleanupSynch(txn, this);
    }

    protected Session buildOrObtainSession() {
        return this.factory.openSession(null, this.isAutoFlushEnabled(), this.isAutoCloseEnabled(), this.getConnectionReleaseMode());
    }

    protected boolean isAutoCloseEnabled() {
        return true;
    }

    protected boolean isAutoFlushEnabled() {
        return true;
    }

    protected ConnectionReleaseMode getConnectionReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    protected static class CleanupSynch
    implements Synchronization {
        private Transaction txn;
        private JTASessionContext context;

        public CleanupSynch(Transaction txn, JTASessionContext context) {
            this.txn = txn;
            this.context = context;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
            this.context.currentSessionMap.remove(this.txn);
        }
    }
}

