/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.action.CollectionRecreateAction;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.action.CollectionUpdateAction;
import org.hibernate.action.EntityDeleteAction;
import org.hibernate.action.EntityIdentityInsertAction;
import org.hibernate.action.EntityInsertAction;
import org.hibernate.action.EntityUpdateAction;
import org.hibernate.action.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.SessionImplementor;

public class ActionQueue {
    private static final Log log = LogFactory.getLog(ActionQueue.class);
    private static final int INIT_QUEUE_LIST_SIZE = 5;
    private SessionImplementor session;
    private ArrayList insertions;
    private ArrayList deletions;
    private ArrayList updates;
    private ArrayList collectionCreations;
    private ArrayList collectionUpdates;
    private ArrayList collectionRemovals;
    private ArrayList executions;

    public ActionQueue(SessionImplementor session) {
        this.session = session;
        this.init();
    }

    private void init() {
        this.insertions = new ArrayList(5);
        this.deletions = new ArrayList(5);
        this.updates = new ArrayList(5);
        this.collectionCreations = new ArrayList(5);
        this.collectionRemovals = new ArrayList(5);
        this.collectionUpdates = new ArrayList(5);
        this.executions = new ArrayList(15);
    }

    public void clear() {
        this.updates.clear();
        this.insertions.clear();
        this.deletions.clear();
        this.collectionCreations.clear();
        this.collectionRemovals.clear();
        this.collectionUpdates.clear();
    }

    public void addAction(EntityInsertAction action) {
        this.insertions.add(action);
    }

    public void addAction(EntityDeleteAction action) {
        this.deletions.add(action);
    }

    public void addAction(EntityUpdateAction action) {
        this.updates.add(action);
    }

    public void addAction(CollectionRecreateAction action) {
        this.collectionCreations.add(action);
    }

    public void addAction(CollectionRemoveAction action) {
        this.collectionRemovals.add(action);
    }

    public void addAction(CollectionUpdateAction action) {
        this.collectionUpdates.add(action);
    }

    public void addAction(EntityIdentityInsertAction insert) {
        this.insertions.add(insert);
    }

    public void addAction(BulkOperationCleanupAction cleanupAction) {
        this.executions.add(cleanupAction);
    }

    public void executeInserts() throws HibernateException {
        this.executeActions(this.insertions);
    }

    public void executeActions() throws HibernateException {
        this.executeActions(this.insertions);
        this.executeActions(this.updates);
        this.executeActions(this.collectionRemovals);
        this.executeActions(this.collectionUpdates);
        this.executeActions(this.collectionCreations);
        this.executeActions(this.deletions);
    }

    public void prepareActions() throws HibernateException {
        this.prepareActions(this.collectionRemovals);
        this.prepareActions(this.collectionUpdates);
        this.prepareActions(this.collectionCreations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTransactionCompletion(boolean success) {
        int size = this.executions.size();
        boolean invalidateQueryCache = this.session.getFactory().getSettings().isQueryCacheEnabled();
        for (int i = 0; i < size; ++i) {
            try {
                Object var7_8;
                Executable exec = (Executable)this.executions.get(i);
                try {
                    exec.afterTransactionCompletion(success);
                    var7_8 = null;
                    if (!invalidateQueryCache) continue;
                }
                catch (Throwable throwable) {
                    var7_8 = null;
                    if (invalidateQueryCache) {
                        this.session.getFactory().getUpdateTimestampsCache().invalidate(exec.getPropertySpaces());
                    }
                    throw throwable;
                }
                this.session.getFactory().getUpdateTimestampsCache().invalidate(exec.getPropertySpaces());
                {
                    continue;
                }
            }
            catch (CacheException ce) {
                log.error("could not release a cache lock", ce);
                continue;
            }
            catch (Exception e) {
                throw new AssertionFailure("Exception releasing cache locks", e);
            }
        }
        this.executions.clear();
    }

    public boolean areTablesToBeUpdated(Set tables) {
        return ActionQueue.areTablesToUpdated(this.updates, tables) || ActionQueue.areTablesToUpdated(this.insertions, tables) || ActionQueue.areTablesToUpdated(this.deletions, tables) || ActionQueue.areTablesToUpdated(this.collectionUpdates, tables) || ActionQueue.areTablesToUpdated(this.collectionCreations, tables) || ActionQueue.areTablesToUpdated(this.collectionRemovals, tables);
    }

    public boolean areInsertionsOrDeletionsQueued() {
        return this.insertions.size() > 0 || this.deletions.size() > 0;
    }

    private static boolean areTablesToUpdated(List executables, Set tablespaces) {
        int size = executables.size();
        for (int j = 0; j < size; ++j) {
            Serializable[] spaces = ((Executable)executables.get(j)).getPropertySpaces();
            for (int i = 0; i < spaces.length; ++i) {
                if (!tablespaces.contains(spaces[i])) continue;
                if (log.isDebugEnabled()) {
                    log.debug("changes must be flushed to space: " + spaces[i]);
                }
                return true;
            }
        }
        return false;
    }

    private void executeActions(List list) throws HibernateException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.execute((Executable)list.get(i));
        }
        list.clear();
        this.session.getBatcher().executeBatch();
    }

    public void execute(Executable executable) {
        boolean lockQueryCache = this.session.getFactory().getSettings().isQueryCacheEnabled();
        if (executable.hasAfterTransactionCompletion() || lockQueryCache) {
            this.executions.add(executable);
        }
        if (lockQueryCache) {
            this.session.getFactory().getUpdateTimestampsCache().preinvalidate(executable.getPropertySpaces());
        }
        executable.execute();
    }

    private void prepareActions(List queue) throws HibernateException {
        int size = queue.size();
        for (int i = 0; i < size; ++i) {
            Executable executable = (Executable)queue.get(i);
            executable.beforeExecutions();
        }
    }

    public String toString() {
        return "ActionQueue[insertions=" + this.insertions + " updates=" + this.updates + " deletions=" + this.deletions + " collectionCreations=" + this.collectionCreations + " collectionRemovals=" + this.collectionRemovals + " collectionUpdates=" + this.collectionUpdates + "]";
    }

    public int numberOfCollectionRemovals() {
        return this.collectionRemovals.size();
    }

    public int numberOfCollectionUpdates() {
        return this.collectionUpdates.size();
    }

    public int numberOfCollectionCreations() {
        return this.collectionCreations.size();
    }

    public int numberOfDeletions() {
        return this.deletions.size();
    }

    public int numberOfUpdates() {
        return this.updates.size();
    }

    public int numberOfInsertions() {
        return this.insertions.size();
    }

    public void sortCollectionActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.collectionCreations);
            Collections.sort(this.collectionUpdates);
            Collections.sort(this.collectionRemovals);
        }
    }

    public void sortActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.updates);
        }
        if (this.session.getFactory().getSettings().isOrderInsertsEnabled()) {
            this.sortInsertActions();
        }
    }

    private void sortInsertActions() {
        HashMap positionToAction = new HashMap();
        ArrayList<String> nameList = new ArrayList<String>();
        block0: while (!this.insertions.isEmpty()) {
            EntityInsertAction action = (EntityInsertAction)this.insertions.remove(0);
            String thisEntityName = action.getEntityName();
            if (!nameList.contains(thisEntityName)) {
                ArrayList<EntityInsertAction> segmentedActionQueue = new ArrayList<EntityInsertAction>();
                segmentedActionQueue.add(action);
                nameList.add(thisEntityName);
                positionToAction.put(new Integer(nameList.indexOf(thisEntityName)), segmentedActionQueue);
                continue;
            }
            int lastPos = nameList.lastIndexOf(thisEntityName);
            Object[] states = action.getState();
            for (int i = 0; i < states.length; ++i) {
                for (int j = 0; j < nameList.size(); ++j) {
                    ArrayList tmpList = (ArrayList)positionToAction.get(new Integer(j));
                    for (int k = 0; k < tmpList.size(); ++k) {
                        EntityInsertAction checkAction = (EntityInsertAction)tmpList.get(k);
                        if (checkAction.getInstance() != states[i] || j <= lastPos) continue;
                        ArrayList<EntityInsertAction> segmentedActionQueue = new ArrayList<EntityInsertAction>();
                        segmentedActionQueue.add(action);
                        nameList.add(thisEntityName);
                        positionToAction.put(new Integer(nameList.lastIndexOf(thisEntityName)), segmentedActionQueue);
                        continue block0;
                    }
                }
            }
            ArrayList actionQueue = (ArrayList)positionToAction.get(new Integer(lastPos));
            actionQueue.add(action);
        }
        for (int p = 0; p < nameList.size(); ++p) {
            ArrayList actionQueue = (ArrayList)positionToAction.get(new Integer(p));
            Iterator itr = actionQueue.iterator();
            while (itr.hasNext()) {
                this.insertions.add(itr.next());
            }
        }
    }

    public ArrayList cloneDeletions() {
        return (ArrayList)this.deletions.clone();
    }

    public void clearFromFlushNeededCheck(int previousCollectionRemovalSize) {
        this.collectionCreations.clear();
        this.collectionUpdates.clear();
        this.updates.clear();
        for (int i = this.collectionRemovals.size() - 1; i >= previousCollectionRemovalSize; --i) {
            this.collectionRemovals.remove(i);
        }
    }

    public boolean hasAnyQueuedActions() {
        return this.updates.size() > 0 || this.insertions.size() > 0 || this.deletions.size() > 0 || this.collectionUpdates.size() > 0 || this.collectionRemovals.size() > 0 || this.collectionCreations.size() > 0;
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        int i;
        log.trace("serializing action-queue");
        int queueSize = this.insertions.size();
        log.trace("starting serialization of [" + queueSize + "] insertions entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.insertions.get(i));
        }
        queueSize = this.deletions.size();
        log.trace("starting serialization of [" + queueSize + "] deletions entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.deletions.get(i));
        }
        queueSize = this.updates.size();
        log.trace("starting serialization of [" + queueSize + "] updates entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.updates.get(i));
        }
        queueSize = this.collectionUpdates.size();
        log.trace("starting serialization of [" + queueSize + "] collectionUpdates entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.collectionUpdates.get(i));
        }
        queueSize = this.collectionRemovals.size();
        log.trace("starting serialization of [" + queueSize + "] collectionRemovals entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.collectionRemovals.get(i));
        }
        queueSize = this.collectionCreations.size();
        log.trace("starting serialization of [" + queueSize + "] collectionCreations entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.collectionCreations.get(i));
        }
    }

    public static ActionQueue deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        int i;
        log.trace("deserializing action-queue");
        ActionQueue rtn = new ActionQueue(session);
        int queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] insertions entries");
        rtn.insertions = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.insertions.add(ois.readObject());
        }
        queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] deletions entries");
        rtn.deletions = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.deletions.add(ois.readObject());
        }
        queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] updates entries");
        rtn.updates = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.updates.add(ois.readObject());
        }
        queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] collectionUpdates entries");
        rtn.collectionUpdates = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.collectionUpdates.add(ois.readObject());
        }
        queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] collectionRemovals entries");
        rtn.collectionRemovals = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.collectionRemovals.add(ois.readObject());
        }
        queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] collectionCreations entries");
        rtn.collectionCreations = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.collectionCreations.add(ois.readObject());
        }
        return rtn;
    }
}

