/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.validator.Email;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailValidator
implements Validator<Email>,
Serializable {
    private static String ATOM = "[^\\x00-\\x1F^\\(^\\)^\\<^\\>^\\@^\\,^\\(;^\\:^\\\\^\\\"^\\.^\\[^\\]^\\s]";
    private static String DOMAIN = "(" + ATOM + "+(\\." + ATOM + "+)*";
    private static String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";
    private Pattern pattern;

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String string = (String)value;
        if (string.length() == 0) {
            return true;
        }
        Matcher m = this.pattern.matcher(string);
        return m.matches();
    }

    @Override
    public void initialize(Email parameters) {
        this.pattern = Pattern.compile("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*$", 2);
        this.pattern = Pattern.compile("^" + ATOM + "+(\\." + ATOM + "+)*@" + DOMAIN + "|" + IP_DOMAIN + ")$", 2);
    }
}

