/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.db2;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallbackAdaptor;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.db2.DB2JCCExceptionFormatter;
import net.sourceforge.squirrel_sql.plugins.db2.exp.DB2TableIndexExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.db2.exp.DB2TableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.db2.exp.SchemaExpander;
import net.sourceforge.squirrel_sql.plugins.db2.tab.IndexDetailsTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.ProcedureSourceTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.SequenceDetailsTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.TableSourceTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.TriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.UDFDetailsTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.UDFSourceTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.ViewSourceTab;
import net.sourceforge.squirrel_sql.plugins.db2.types.DB2XmlTypeDataTypeComponentFactory;

public class DB2Plugin
extends DefaultSessionPlugin {
    private static final String JCC_DRIVER_NAME = "IBM DB2 JDBC Universal Driver Architecture";
    private static final String OS_400_PRODUCT_NAME = "DB2 UDB for AS/400";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DB2Plugin.class);
    private static final ILogger s_log = LoggerController.createLogger(DB2Plugin.class);
    private IObjectTreeAPI _treeAPI;

    public String getInternalName() {
        return "db2";
    }

    public String getDescriptiveName() {
        return "DB2 Plugin";
    }

    public String getVersion() {
        return "0.04";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "Christoph Schmitz, Tilmann Brenk, Lars Heller";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void load(IApplication app) throws PluginException {
        super.load(app);
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        CellComponentFactory.registerDataTypeFactory((IDataTypeComponentFactory)new DB2XmlTypeDataTypeComponentFactory(), (int)1111, (String)"XML");
    }

    public void unload() {
        super.unload();
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                DB2Plugin.this.updateTreeApi(session);
            }
        });
        try {
            if (JCC_DRIVER_NAME.equals(session.getMetaData().getJDBCMetaData().getDriverName())) {
                session.setExceptionFormatter((ExceptionFormatter)new DB2JCCExceptionFormatter());
            }
        }
        catch (SQLException e) {
            s_log.error((Object)("Problem installing exception formatter: " + e.getMessage()));
        }
        return new PluginSessionCallbackAdaptor((IPlugin)this);
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isDB2((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void updateTreeApi(ISession session) {
        String stmtSep = session.getQueryTokenizer().getSQLStatementSeparator();
        boolean isOS400 = this.isOS400(session);
        this._treeAPI = session.getSessionInternalFrame().getObjectTreeAPI();
        this._treeAPI.addDetailTab(DatabaseObjectType.PROCEDURE, (IObjectTab)new ProcedureSourceTab(i18n.SHOW_PROCEDURE_SOURCE, isOS400, stmtSep));
        this._treeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(i18n.SHOW_VIEW_SOURCE, stmtSep, isOS400));
        this._treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexDetailsTab(isOS400));
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new SequenceDetailsTab(isOS400));
        this._treeAPI.addDetailTab(DatabaseObjectType.UDF, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.UDF, (IObjectTab)new UDFSourceTab(i18n.SHOW_UDF_SOURCE, stmtSep, isOS400));
        this._treeAPI.addDetailTab(DatabaseObjectType.UDF, (IObjectTab)new UDFDetailsTab(isOS400));
        this._treeAPI.addDetailTab(DatabaseObjectType.TABLE, (IObjectTab)new TableSourceTab("Show MQT Source", stmtSep, isOS400));
        this._treeAPI.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander(isOS400));
        TableWithChildNodesExpander tableExpander = new TableWithChildNodesExpander();
        DB2TableIndexExtractorImpl indexExtractor = new DB2TableIndexExtractorImpl(isOS400);
        tableExpander.setTableIndexExtractor((ITableIndexExtractor)indexExtractor);
        DB2TableTriggerExtractorImpl triggerExtractor = new DB2TableTriggerExtractorImpl(isOS400);
        tableExpander.setTableTriggerExtractor((ITableTriggerExtractor)triggerExtractor);
        this._treeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)tableExpander);
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab(i18n.SHOW_TRIGGER_SOURCE, isOS400, stmtSep));
    }

    private boolean isOS400(ISession session) {
        boolean result = false;
        try {
            String prodName = session.getMetaData().getDatabaseProductName();
            if (prodName == null || prodName.equals("")) {
                s_log.info((Object)"isOS400: product name is null or empty.  Assuming not an OS/400 DB2 session.");
            } else if (prodName.equals(OS_400_PRODUCT_NAME)) {
                s_log.info((Object)"isOS400: session appears to be an OS/400 DB2");
                result = true;
            } else {
                s_log.info((Object)"isOS400: session doesn't appear to be an OS/400 DB2");
            }
        }
        catch (SQLException e) {
            s_log.error((Object)("isOS400: unable to determine the product name: " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String SHOW_UDF_SOURCE = DB2Plugin.access$000().getString("DB2Plugin.showUdfSource");
        public static final String SHOW_VIEW_SOURCE = DB2Plugin.access$000().getString("DB2Plugin.showViewSource");
        public static final String SHOW_PROCEDURE_SOURCE = DB2Plugin.access$000().getString("DB2Plugin.showProcedureSource");
        public static final String SHOW_TRIGGER_SOURCE = DB2Plugin.access$000().getString("DB2Plugin.showTriggerSource");
    }
}

