/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.db2.tab;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BasePreparedStatementTab;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.db2.tab.TriggerDetailsTab;

public class UDFDetailsTab
extends BasePreparedStatementTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TriggerDetailsTab.class);
    private static String SQL = "select name, schema, definer, function_id, parm_count, side_effects, fenced, language, contains_sql, result_cols, class, jar_id from sysibm.SYSFUNCTIONS where schema = ? and name = ? ";
    private static String OS_400_SQL = "select routine_name as name, routine_schema as schema, routine_definer as definer, in_parms as parm_count, case external_action     when 'E' then 'has external side effects'     when 'N' then 'has no external side effects' end as side_effects, fenced, external_language as language, sql_data_access as contains_sql, number_of_results as result_cols, external_name from qsys2.SYSFUNCS where routine_schema = ? and routine_name = ? ";
    private static final ILogger s_log = LoggerController.createLogger(TriggerDetailsTab.class);
    private boolean isOS400 = false;

    public UDFDetailsTab(boolean isOS400) {
        super(i18n.TITLE, i18n.HINT, true);
        this.isOS400 = isOS400;
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        String sql = SQL;
        if (this.isOS400) {
            sql = OS_400_SQL;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("UDF details SQL: " + sql));
            s_log.debug((Object)("UDF schema: " + doi.getSchemaName()));
            s_log.debug((Object)("UDF name: " + doi.getSimpleName()));
        }
        PreparedStatement pstmt = session.getSQLConnection().prepareStatement(sql);
        pstmt.setString(1, doi.getSchemaName());
        pstmt.setString(2, doi.getSimpleName());
        return pstmt;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String TITLE = UDFDetailsTab.access$000().getString("UdfDetailsTab.title");
        public static final String HINT = UDFDetailsTab.access$000().getString("UdfDetailsTab.hint");
    }
}

