/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.squirrel;

import javax.swing.Action;
import javax.swing.JMenu;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.firebirdsql.squirrel.IObjectTypes;
import org.firebirdsql.squirrel.act.ActivateIndexAction;
import org.firebirdsql.squirrel.act.DeactivateIndexAction;
import org.firebirdsql.squirrel.exp.AllIndexesParentExpander;
import org.firebirdsql.squirrel.exp.DatabaseExpander;
import org.firebirdsql.squirrel.exp.FirebirdTableIndexExtractorImpl;
import org.firebirdsql.squirrel.exp.FirebirdTableTriggerExtractorImpl;
import org.firebirdsql.squirrel.tab.DomainDetailsTab;
import org.firebirdsql.squirrel.tab.GeneratorDetailsTab;
import org.firebirdsql.squirrel.tab.IndexInfoTab;
import org.firebirdsql.squirrel.tab.ProcedureSourceTab;
import org.firebirdsql.squirrel.tab.TriggerDetailsTab;
import org.firebirdsql.squirrel.tab.TriggerSourceTab;
import org.firebirdsql.squirrel.tab.ViewSourceTab;

public class FirebirdPlugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FirebirdPlugin.class);
    private IObjectTreeAPI _treeAPI;
    private IResources _resources;
    private IPluginResourcesFactory _resourcesFactory = new PluginResourcesFactory();
    private JMenu _firebirdMenu;

    public void setResourcesFactory(IPluginResourcesFactory resourcesFactory) {
        this._resourcesFactory = resourcesFactory;
    }

    public String getInternalName() {
        return "firebird";
    }

    public String getDescriptiveName() {
        return "Firebird Plugin";
    }

    public String getVersion() {
        return "0.02";
    }

    public String getAuthor() {
        return "Roman Rokytskyy";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void load(IApplication app) throws PluginException {
        super.load(app);
        this._resources = this._resourcesFactory.createResource(((Object)((Object)this)).getClass().getName(), (IPlugin)this);
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new ActivateIndexAction(app, this._resources, (IPlugin)this)));
        coll.add((Action)((Object)new DeactivateIndexAction(app, this._resources, (IPlugin)this)));
        this._firebirdMenu = this.createFirebirdMenu();
        app.addToMenu(2, this._firebirdMenu);
        super.registerSessionMenu(this._firebirdMenu);
    }

    public void unload() {
        super.unload();
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FirebirdPlugin.this.updateTreeApi(session);
            }
        });
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
            }
        };
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isFirebird((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void updateTreeApi(ISession session) {
        this._treeAPI = session.getSessionInternalFrame().getObjectTreeAPI();
        this._treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexInfoTab());
        this._treeAPI.addExpander(IObjectTypes.INDEX_PARENT, (INodeExpander)new AllIndexesParentExpander());
        this._treeAPI.addExpander(DatabaseObjectType.SESSION, (INodeExpander)new DatabaseExpander(this));
        TableWithChildNodesExpander tableExp = new TableWithChildNodesExpander();
        tableExp.setTableTriggerExtractor((ITableTriggerExtractor)new FirebirdTableTriggerExtractorImpl());
        tableExp.setTableIndexExtractor((ITableIndexExtractor)new FirebirdTableIndexExtractorImpl());
        this._treeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)tableExp);
        this._treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new GeneratorDetailsTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.DATATYPE, (IObjectTab)new DomainDetailsTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab(s_stringMgr.getString("firebird.showTrigger")));
        this._treeAPI.addDetailTab(DatabaseObjectType.PROCEDURE, (IObjectTab)new ProcedureSourceTab(s_stringMgr.getString("firebird.showProcedureSource")));
        this._treeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(s_stringMgr.getString("firebird.showView")));
        ActionCollection coll = this.getApplication().getActionCollection();
        this._treeAPI.addToPopup(DatabaseObjectType.INDEX, coll.get(ActivateIndexAction.class));
        this._treeAPI.addToPopup(DatabaseObjectType.INDEX, coll.get(DeactivateIndexAction.class));
    }

    private JMenu createFirebirdMenu() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu firebirdMenu = this._resources.createMenu("firebird");
        this._resources.addToMenu(coll.get(ActivateIndexAction.class), firebirdMenu);
        this._resources.addToMenu(coll.get(DeactivateIndexAction.class), firebirdMenu);
        return firebirdMenu;
    }

    public static interface IMenuResourceKeys {
        public static final String FIREBIRD = "firebird";
    }
}

