/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.plugins.graph.GraphController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphSelectionDialogController;
import net.sourceforge.squirrel_sql.plugins.graph.Positioner;

public class AddToGraphAction
extends SquirrelAction
implements ISessionAction {
    protected ISession _session;
    protected final GraphPlugin _plugin;

    public AddToGraphAction(IApplication app, Resources rsrc, GraphPlugin plugin) {
        super(app, (IResources)rsrc);
        this._plugin = plugin;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this._session != null) {
            ObjectTreeNode[] selectedNodes = this._session.getSessionSheet().getObjectTreePanel().getSelectedNodes();
            Positioner positioner = new Positioner();
            GraphController toAddTo = null;
            for (int i = 0; i < selectedNodes.length; ++i) {
                if (selectedNodes[i].getDatabaseObjectType() == DatabaseObjectType.TABLE) {
                    // empty if block
                }
                if (null == toAddTo) {
                    GraphController[] controllers = this._plugin.getGraphControllers(this._session);
                    if (0 == controllers.length) {
                        toAddTo = this._plugin.createNewGraphControllerForSession(this._session, false);
                    } else {
                        GraphSelectionDialogController dlg = new GraphSelectionDialogController(controllers, (JFrame)this._session.getApplication().getMainFrame());
                        dlg.doModal();
                        if (!dlg.isOK()) {
                            return;
                        }
                        toAddTo = null == dlg.getSelectedController() ? this._plugin.createNewGraphControllerForSession(this._session, false) : dlg.getSelectedController();
                    }
                }
                toAddTo.addTable(selectedNodes[i], positioner);
            }
        }
    }

    public void setSession(ISession session) {
        this._session = session;
    }
}

