/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.util.ArrayList;
import java.util.Vector;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintQueryData;
import net.sourceforge.squirrel_sql.plugins.graph.GraphUtil;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModel;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ColumnInfoXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ConstraintDataXmlBean;

public class ConstraintData {
    private String _pkTableName;
    private String _fkTableName;
    private String _constraintName;
    private boolean _nonDbConstraint;
    private boolean _showThisConstraintName;
    private ConstraintQueryData _constraintQueryData = new ConstraintQueryData();
    private ArrayList<ColumnInfo> _pkCols = new ArrayList();
    private ArrayList<ColumnInfo> _fkCols = new ArrayList();

    public ConstraintData(String pkTableName, String fkTableName, String constraintName) {
        this(pkTableName, fkTableName, constraintName, false);
    }

    public ConstraintData(ConstraintDataXmlBean constraintDataXmlBean) {
        this._pkTableName = constraintDataXmlBean.getPkTableName();
        this._fkTableName = constraintDataXmlBean.getFkTableName();
        this._constraintName = constraintDataXmlBean.getConstraintName();
        this._nonDbConstraint = constraintDataXmlBean.isNonDbConstraint();
        this._showThisConstraintName = constraintDataXmlBean.isShowThisConstraintName();
        if (null != constraintDataXmlBean.getConstraintQueryDataXmlBean()) {
            this._constraintQueryData = new ConstraintQueryData(constraintDataXmlBean.getConstraintQueryDataXmlBean());
        }
        this._pkCols = new ArrayList();
        for (ColumnInfoXmlBean columnInfoXmlBean : constraintDataXmlBean.getPkColumns()) {
            this._pkCols.add(new ColumnInfo(columnInfoXmlBean));
        }
        this._fkCols = new ArrayList();
        for (ColumnInfoXmlBean columnInfoXmlBean : constraintDataXmlBean.getFkColumns()) {
            this._fkCols.add(new ColumnInfo(columnInfoXmlBean));
        }
    }

    public ConstraintData(String pkTableName, String fkTableName, String constraintName, boolean nonDbConstraint) {
        this._pkTableName = pkTableName;
        this._fkTableName = fkTableName;
        this._constraintName = constraintName;
        this._nonDbConstraint = nonDbConstraint;
    }

    public ConstraintDataXmlBean getXmlBean() {
        ConstraintDataXmlBean ret = new ConstraintDataXmlBean();
        ret.setPkTableName(this._pkTableName);
        ret.setFkTableName(this._fkTableName);
        ret.setConstraintName(this._constraintName);
        ret.setNonDbConstraint(this._nonDbConstraint);
        ret.setShowThisConstraintName(this._showThisConstraintName);
        ret.setConstraintQueryDataXmlBean(this._constraintQueryData.getXmlBean());
        ColumnInfoXmlBean[] pkColInfoXmlBeans = new ColumnInfoXmlBean[this._pkCols.size()];
        for (int i = 0; i < this._pkCols.size(); ++i) {
            pkColInfoXmlBeans[i] = this._pkCols.get(i).getXmlBean();
        }
        ret.setPkColumns(pkColInfoXmlBeans);
        ColumnInfoXmlBean[] fkColInfoXmlBeans = new ColumnInfoXmlBean[this._fkCols.size()];
        for (int i = 0; i < this._fkCols.size(); ++i) {
            fkColInfoXmlBeans[i] = this._fkCols.get(i).getXmlBean();
        }
        ret.setFkColumns(fkColInfoXmlBeans);
        return ret;
    }

    public String getPkTableName() {
        return this._pkTableName;
    }

    public ColumnInfo[] getFkColumnInfos() {
        return this._fkCols.toArray(new ColumnInfo[this._pkCols.size()]);
    }

    public ColumnInfo[] getPkColumnInfos() {
        return this._pkCols.toArray(new ColumnInfo[this._pkCols.size()]);
    }

    public String getTitle() {
        return this._fkTableName + "." + this._constraintName;
    }

    public boolean isNonDbConstraint() {
        return this._nonDbConstraint;
    }

    public String[] getDDL() {
        Vector<String> ret = new Vector<String>();
        ret.add("ALTER TABLE " + this._fkTableName);
        ret.add("ADD CONSTRAINT " + this._constraintName);
        if (this._fkCols.size() == 1) {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append("FOREIGN KEY (").append(this._fkCols.get(0).getName());
            for (i = 1; i < this._fkCols.size(); ++i) {
                sb.append(",").append(this._fkCols.get(i).getName());
            }
            sb.append(")");
            ret.add(sb.toString());
            sb.setLength(0);
            sb.append("REFERENCES ").append(this._pkTableName).append("(");
            sb.append(this._pkCols.get(0).getColumnName());
            for (i = 1; i < this._pkCols.size(); ++i) {
                sb.append(",").append(this._pkCols.get(i).getColumnName());
            }
            sb.append(")");
            ret.add(sb.toString());
        } else {
            int i;
            ret.add("FOREIGN KEY");
            ret.add("(");
            for (i = 0; i < this._fkCols.size(); ++i) {
                if (i < this._fkCols.size() - 1) {
                    ret.add("  " + this._fkCols.get(i).getName() + ",");
                    continue;
                }
                ret.add("  " + this._fkCols.get(i).getName());
            }
            ret.add(")");
            ret.add("REFERENCES " + this._pkTableName);
            ret.add("(");
            for (i = 0; i < this._pkCols.size(); ++i) {
                if (i < this._pkCols.size() - 1) {
                    ret.add("  " + this._pkCols.get(i).getColumnName() + ",");
                    continue;
                }
                ret.add("  " + this._pkCols.get(i).getColumnName());
            }
            ret.add(")");
        }
        return ret.toArray(new String[ret.size()]);
    }

    public String getConstraintName() {
        return this._constraintName;
    }

    public void removeAllColumns() {
        this._pkCols.clear();
        this._fkCols.clear();
    }

    public void setConstraintName(String name) {
        this._constraintName = name;
    }

    public boolean isShowThisConstraintName() {
        return this._showThisConstraintName;
    }

    public void setShowThisConstraintName(boolean showThisConstraintName) {
        this._showThisConstraintName = showThisConstraintName;
    }

    public ConstraintQueryData getConstraintQueryData() {
        return this._constraintQueryData;
    }

    public void setColumnInfos(ArrayList<ColumnInfo> pkCols, ArrayList<ColumnInfo> fkCols) {
        this._pkCols = pkCols;
        this._fkCols = fkCols;
    }

    public void addColumnInfos(ColumnInfo pkCol, ColumnInfo fkCol) {
        this._pkCols.add(pkCol);
        this._fkCols.add(fkCol);
    }

    public boolean matches(ConstraintData other) {
        return GraphUtil.columnsMatch(other._pkCols, this._pkCols) && GraphUtil.columnsMatch(other._fkCols, this._fkCols);
    }

    public boolean hasOverlap(ConstraintData other) {
        if (!other._pkTableName.equalsIgnoreCase(this._pkTableName) || !other._fkTableName.equalsIgnoreCase(this._fkTableName)) {
            return false;
        }
        for (ColumnInfo pkCol : this._pkCols) {
            for (ColumnInfo otherPkCol : other._pkCols) {
                if (!pkCol.equals(otherPkCol)) continue;
                return true;
            }
        }
        for (ColumnInfo fkCol : this._fkCols) {
            for (ColumnInfo otherFkCol : other._fkCols) {
                if (!fkCol.equals(otherFkCol)) continue;
                return true;
            }
        }
        return false;
    }

    public void replaceColumnClonesInConstraintsByRefrences(TableFramesModel tableFramesModel) {
        int i;
        for (i = 0; i < this._pkCols.size(); ++i) {
            this._pkCols.set(i, tableFramesModel.findColumn(this._pkTableName, this._pkCols.get(i).getColumnName()));
        }
        for (i = 0; i < this._fkCols.size(); ++i) {
            this._fkCols.set(i, tableFramesModel.findColumn(this._fkTableName, this._fkCols.get(i).getColumnName()));
        }
    }
}

