/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.plugins.graph.AddTableRequestListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPanelController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.LazyLoadListener;
import net.sourceforge.squirrel_sql.plugins.graph.Mode;
import net.sourceforge.squirrel_sql.plugins.graph.Positioner;
import net.sourceforge.squirrel_sql.plugins.graph.SqlScriptAcessor;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameController;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModel;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereTreeNodeStructure;
import net.sourceforge.squirrel_sql.plugins.graph.window.TabToWindowHandler;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphControllerXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphXmlSerializer;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.OrderStructureXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.PrintXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.SelectStructureXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.TableFrameControllerXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ZoomerXmlBean;

public class GraphController {
    private ISession _session;
    private GraphPanelController _panelController;
    private TableFramesModel _tableFramesModel = new TableFramesModel();
    private static final int BORDER_X = 30;
    private static final int BORDER_Y = 10;
    private AddTableRequestListener _addTableRequestListener;
    private GraphDesktopListener _graphDesktopListener;
    private GraphPlugin _plugin;
    private TabToWindowHandler _tabToWindowHandler;
    private GraphXmlSerializer _xmlSerializer;
    private boolean _lazyLoadDone;

    public GraphController(ISession session, GraphPlugin plugin, GraphXmlSerializer xmlSerializer, boolean showDndDesktopImageAtStartup) {
        this._session = session;
        this._plugin = plugin;
        this._graphDesktopListener = new GraphDesktopListener(){

            @Override
            public void saveGraphRequested() {
                GraphController.this.saveGraph();
            }

            @Override
            public void renameRequest(String newName) {
                GraphController.this.renameGraph(newName);
            }

            @Override
            public void removeRequest() {
                GraphController.this.removeGraph();
            }

            @Override
            public void refreshAllTablesRequested() {
                GraphController.this.refreshAllTables();
            }

            @Override
            public void scriptAllTablesRequested() {
                GraphController.this.scriptAllTables();
            }

            @Override
            public void allTablesPkConstOrderRequested() {
                GraphController.this._tableFramesModel.allTablesPkConstOrder();
            }

            @Override
            public void allTablesByNameOrderRequested() {
                GraphController.this._tableFramesModel.allTablesByNameOrder();
            }

            @Override
            public void allTablesDbOrderRequested() {
                GraphController.this._tableFramesModel.allTablesDbOrder();
            }

            @Override
            public void allTablesFilteredSelectedOrderRequested() {
                GraphController.this._tableFramesModel.allTablesFilteredSelectedOrder();
            }

            @Override
            public void showQualifiedTableNamesRequested() {
                GraphController.this._tableFramesModel.refreshTableNames();
            }

            @Override
            public void tablesDropped(List<ITableInfo> tis, Point dropPoint) {
                GraphController.this.onTablesDropped(tis, dropPoint);
            }

            @Override
            public void toggleWindowTab() {
                GraphController.this._tabToWindowHandler.toggleWindowTab();
            }
        };
        this._panelController = new GraphPanelController(this._tableFramesModel, this._graphDesktopListener, this._session, this._plugin, showDndDesktopImageAtStartup);
        this._tabToWindowHandler = new TabToWindowHandler(this._panelController, this._session, this._plugin);
        this._xmlSerializer = null == xmlSerializer ? new GraphXmlSerializer(this._plugin, this._session, this._tabToWindowHandler.getTitle(), null) : xmlSerializer;
        this._addTableRequestListener = new AddTableRequestListener(){

            @Override
            public void addTablesRequest(String[] tablenames, String schema, String catalog) {
                GraphController.this.onAddTablesRequest(tablenames, schema, catalog);
            }
        };
        GraphControllerXmlBean graphControllerXmlBean = null;
        if (null != xmlSerializer) {
            graphControllerXmlBean = this._xmlSerializer.read();
            this._tabToWindowHandler.setTitle(graphControllerXmlBean.getTitle());
            Mode modeIndex = Mode.getForIndex(graphControllerXmlBean.getModeIndex());
            ZoomerXmlBean zoomerXmlBean = graphControllerXmlBean.getZoomerXmlBean();
            PrintXmlBean printXmlBean = graphControllerXmlBean.getPrintXmlBean();
            boolean queryHideNoJoins = graphControllerXmlBean.isQueryHideNoJoins();
            WhereTreeNodeStructure whereTreeNodeStructure = graphControllerXmlBean.getWhereTreeNodeStructure();
            OrderStructureXmlBean orderStructure = graphControllerXmlBean.getOrderStructure();
            SelectStructureXmlBean selectStructure = graphControllerXmlBean.getSelectStructure();
            this._panelController.initMode(modeIndex, zoomerXmlBean, printXmlBean, queryHideNoJoins, selectStructure, whereTreeNodeStructure, orderStructure);
            this._panelController.getDesktopController().setShowConstraintNames(graphControllerXmlBean.isShowConstraintNames());
            this._panelController.getDesktopController().setShowQualifiedTableNames(graphControllerXmlBean.isShowQualifiedTableNames());
        } else {
            this._tabToWindowHandler.setTitle(this._plugin.patchName(this._tabToWindowHandler.getTitle(), this._session));
            this._panelController.initMode(Mode.DEFAULT, null, null, false, null, null, null);
        }
        final GraphControllerXmlBean finalGraphControllerXmlBean = graphControllerXmlBean;
        LazyLoadListener lazyLoadListener = new LazyLoadListener(){

            @Override
            public void lazyLoadTables() {
                GraphController.this.onLazyLoadTables(finalGraphControllerXmlBean);
            }
        };
        this._tabToWindowHandler.showGraph(lazyLoadListener);
    }

    private void onLazyLoadTables(GraphControllerXmlBean graphControllerXmlBean) {
        if (null != graphControllerXmlBean && !this._lazyLoadDone) {
            this._lazyLoadDone = true;
            TableFrameControllerXmlBean[] tableFrameControllerXmls = graphControllerXmlBean.getTableFrameControllerXmls();
            for (int i = 0; i < tableFrameControllerXmls.length; ++i) {
                this.addTableIntern(new Positioner(), null, null, null, tableFrameControllerXmls[i]);
            }
            final GraphControllerXmlBean finalGraphControllerXmlBean = graphControllerXmlBean;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GraphController.this._tableFramesModel.hideNoJoins(finalGraphControllerXmlBean.isQueryHideNoJoins());
                    GraphController.this._tableFramesModel.replaceColumnClonesInConstraintsByRefrences();
                }
            });
        }
    }

    private void onTablesDropped(List<ITableInfo> tis, Point dropPoint) {
        Positioner positioner = new Positioner(dropPoint);
        for (ITableInfo ti : tis) {
            this.addTableIntern(positioner, ti.getSimpleName(), ti.getSchemaName(), ti.getCatalogName(), null);
        }
    }

    private void scriptAllTables() {
        Vector<TableFrameController> tblCtrls = this._tableFramesModel.getTblCtrls();
        ITableInfo[] tableInfos = new ITableInfo[tblCtrls.size()];
        for (int i = 0; i < tblCtrls.size(); ++i) {
            TableFrameController tableFrameController = tblCtrls.get(i);
            tableInfos[i] = tableFrameController.getTableInfo();
        }
        Window parent = SwingUtilities.windowForComponent(this._panelController.getGraphPanel());
        SqlScriptAcessor.scriptTablesToSQLEntryArea(parent, this._session, tableInfos);
    }

    private void refreshAllTables() {
        this._tableFramesModel.refreshAllTables();
    }

    private void removeGraph() {
        this._xmlSerializer.remove();
        this._tabToWindowHandler.removeGraph();
        this._plugin.removeGraphController(this, this._session);
    }

    private void renameGraph(String newName) {
        if (newName.equals(this._tabToWindowHandler.getTitle())) {
            return;
        }
        newName = this._plugin.patchName(newName, this._session);
        this._xmlSerializer.rename(newName);
        this._tabToWindowHandler.renameGraph(newName);
        this.saveGraph();
    }

    public void saveGraph() {
        GraphControllerXmlBean xmlBean = new GraphControllerXmlBean();
        xmlBean.setTitle(this._tabToWindowHandler.getTitle());
        xmlBean.setShowConstraintNames(this._panelController.getDesktopController().isShowConstraintNames());
        xmlBean.setZoomerXmlBean(this._panelController.getDesktopController().getZoomer().getXmlBean());
        xmlBean.setPrintXmlBean(this._panelController.getDesktopController().getZoomPrintController().getPrintXmlBean());
        xmlBean.setModeIndex(this._panelController.getModeManager().getMode().getIndex());
        xmlBean.setQueryHideNoJoins(this._panelController.getModeManager().isQueryHideNoJoins());
        xmlBean.setWhereTreeNodeStructure(this._panelController.getModeManager().getWhereTreeNodeStructure());
        xmlBean.setOrderStructure(this._panelController.getModeManager().getOrderStructure());
        xmlBean.setSelectStructure(this._panelController.getModeManager().getSelectStructure());
        Vector<TableFrameController> tblCtrls = this._tableFramesModel.getTblCtrls();
        TableFrameControllerXmlBean[] frameXmls = new TableFrameControllerXmlBean[tblCtrls.size()];
        for (int i = 0; i < tblCtrls.size(); ++i) {
            TableFrameController tableFrameController = tblCtrls.get(i);
            frameXmls[i] = tableFrameController.getXmlBean();
        }
        xmlBean.setTableFrameControllerXmls(frameXmls);
        this._xmlSerializer.write(xmlBean);
    }

    private void onAddTablesRequest(String[] tablenames, String schema, String catalog) {
        Positioner positioner = new Positioner();
        for (int i = 0; i < tablenames.length; ++i) {
            this.addTableIntern(positioner, tablenames[i], schema, catalog, null);
        }
    }

    public void addTable(ObjectTreeNode selectedNode, Positioner positioner) {
        String catalog = selectedNode.getDatabaseObjectInfo().getCatalogName();
        String schema = selectedNode.getDatabaseObjectInfo().getSchemaName();
        String table = selectedNode.getDatabaseObjectInfo().getSimpleName();
        this.addTableIntern(positioner, table, schema, catalog, null);
    }

    private void addTableIntern(final Positioner positioner, String tableName, String schemaName, String catalogName, final TableFrameControllerXmlBean xmlBean) {
        final TableFrameController tfc = null == xmlBean ? new TableFrameController(this._plugin, this._session, this._panelController.getDesktopController(), this._addTableRequestListener, tableName, schemaName, catalogName, null) : new TableFrameController(this._plugin, this._session, this._panelController.getDesktopController(), this._addTableRequestListener, null, null, null, xmlBean);
        if (this._tableFramesModel.containsTable(tfc)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean readingXml = null != xmlBean;
                GraphController.this._panelController.getDesktopController().addFrame(tfc.getFrame());
                GraphController.this._tableFramesModel.addTable(tfc, readingXml);
                if (!readingXml) {
                    GraphController.this.calcPosition(tfc, positioner);
                }
            }
        });
    }

    private void calcPosition(TableFrameController tfc, Positioner positioner) {
        Dimension frmSize = tfc.getFrame().getSize();
        if (null == positioner.getDropPointClone()) {
            int y = 0;
            while ((double)y < this._panelController.getDesktopController().getDesktopPane().getSize().getHeight()) {
                int x = 0;
                while ((double)x < this._panelController.getDesktopController().getDesktopPane().getSize().getWidth()) {
                    Point leftUp = new Point(x, y);
                    Point rightDown = new Point(x + frmSize.width, y + frmSize.height);
                    if (this.isInDesktop(leftUp) && this.isInDesktop(rightDown) && !this.isRectangleOccupied(leftUp, rightDown, tfc)) {
                        tfc.getFrame().setBounds(leftUp.x, leftUp.y, tfc.getFrame().getBounds().width, tfc.getFrame().getBounds().height);
                        return;
                    }
                    x += frmSize.width + 30;
                }
                y += frmSize.height + 10;
            }
        }
        int cascadeIndent = tfc.getFrame().getTitlePane().getSize().height;
        if (null == positioner.getRefPoint()) {
            if (null != positioner.getDropPointClone()) {
                positioner.setRefPoint(positioner.getDropPointClone());
            } else {
                positioner.setRefPoint(new Point(cascadeIndent, cascadeIndent));
            }
        } else {
            Point refPoint = positioner.getRefPoint();
            positioner.setRefPoint(new Point(refPoint.x + cascadeIndent, refPoint.y + cascadeIndent));
        }
        int x = positioner.getRefPoint().x;
        while ((double)x < this._panelController.getDesktopController().getDesktopPane().getSize().getWidth()) {
            int y = positioner.getRefPoint().y;
            while ((double)y < this._panelController.getDesktopController().getDesktopPane().getSize().getHeight()) {
                Point leftUp = new Point(x, y);
                Point rightDown = new Point(x + frmSize.width, y + frmSize.height);
                if (this.isInDesktop(leftUp) && this.isInDesktop(rightDown)) {
                    tfc.getFrame().setBounds(leftUp.x, leftUp.y, tfc.getFrame().getBounds().width, tfc.getFrame().getBounds().height);
                    positioner.getRefPoint().y += cascadeIndent;
                    return;
                }
                y += cascadeIndent;
            }
            positioner.getRefPoint().y = cascadeIndent;
            x += cascadeIndent;
        }
    }

    private boolean isRectangleOccupied(Point leftUp, Point rightDown, TableFrameController toExclude) {
        Vector<TableFrameController> tblCtrls = this._tableFramesModel.getTblCtrls();
        for (int i = 0; i < tblCtrls.size(); ++i) {
            Rectangle rectTfc;
            Rectangle rectParam;
            Rectangle2D interSect;
            TableFrameController tfc = tblCtrls.get(i);
            if (tfc.equals(toExclude) || !(0.0 < (interSect = (rectParam = new Rectangle(leftUp.x - 30, leftUp.y - 10, rightDown.x - leftUp.x + 30, rightDown.y - leftUp.y + 10)).createIntersection(rectTfc = tfc.getFrame().getBounds())).getWidth()) || !(0.0 < interSect.getHeight())) continue;
            return true;
        }
        return false;
    }

    private boolean isInDesktop(Point p) {
        return this._panelController.getDesktopController().getDesktopPane().getSize().width >= p.x && this._panelController.getDesktopController().getDesktopPane().getSize().height >= p.y;
    }

    public String getTitle() {
        return this._tabToWindowHandler.getTitle();
    }

    public String toString() {
        return this.getTitle();
    }

    public void sessionEnding() {
        this._panelController.sessionEnding();
    }

    public void showQueryBuilderInWindowBesidesObjectTree() {
        this._panelController.getModeManager().setMode(Mode.QUERY_BUILDER);
        this._tabToWindowHandler.showInWindowBesidesObjectTree();
    }
}

