/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeDndTransfer;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintHit;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintHitData;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintView;
import net.sourceforge.squirrel_sql.plugins.graph.EdgesGraphComponent;
import net.sourceforge.squirrel_sql.plugins.graph.EdgesListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphComponent;
import net.sourceforge.squirrel_sql.plugins.graph.GraphControllerPopupListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopPane;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.Mode;
import net.sourceforge.squirrel_sql.plugins.graph.ModeManager;
import net.sourceforge.squirrel_sql.plugins.graph.ModeManagerListener;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrame;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModel;
import net.sourceforge.squirrel_sql.plugins.graph.ZoomPrintController;
import net.sourceforge.squirrel_sql.plugins.graph.Zoomer;

public class GraphDesktopController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GraphDesktopController.class);
    private GraphDesktopPane _desktopPane;
    private ConstraintView _lastPressedConstraintView;
    private JPopupMenu _popUp;
    private JMenuItem _mnuSaveGraph;
    private JMenuItem _mnuRenameGraph;
    private JMenuItem _mnuRemoveGraph;
    private JMenuItem _mnuRefreshAllTables;
    private JMenuItem _mnuScriptAllTables;
    private JMenuItem _mnuSelectAllTables;
    private JMenuItem _mnuSelectTablesByName;
    private JCheckBoxMenuItem _mnuShowConstraintNames;
    private JCheckBoxMenuItem _mnuShowQualifiedTableNames;
    private JMenuItem _mnuToggleWindowTab;
    private GraphDesktopListener _listener;
    private ISession _session;
    private GraphPlugin _plugin;
    private ModeManager _modeManager;
    private JMenuItem _mnuAllTablesDbOrder;
    private JMenuItem _mnuAllTablesByNameOrder;
    private JMenuItem _mnuAllTablesPkConstOrder;
    private JMenuItem _mnuAllFilteredSelectedOrder;
    private GraphPluginResources _graphPluginResources;
    private GraphControllerPopupListener _currentGraphControllerPopupListener;

    public GraphDesktopController(GraphDesktopListener listener, ISession session, GraphPlugin plugin, ModeManager modeManager, boolean showDndDesktopImageAtStartup) {
        this._listener = listener;
        this._session = session;
        this._plugin = plugin;
        this._graphPluginResources = new GraphPluginResources((IPlugin)this._plugin);
        ImageIcon startUpImage = null;
        if (showDndDesktopImageAtStartup) {
            startUpImage = this._graphPluginResources.getIcon("dnd");
        }
        this._desktopPane = new GraphDesktopPane(this._session.getApplication(), startUpImage);
        this._desktopPane.setBackground(Color.white);
        this._modeManager = modeManager;
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    GraphDesktopController.this.onTablesDroped(dtde);
                }
            });
        }
        catch (TooManyListenersException e) {
            throw new RuntimeException(e);
        }
        this._desktopPane.setDropTarget(dt);
        this._desktopPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GraphDesktopController.this.onMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GraphDesktopController.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GraphDesktopController.this.onMouseReleased(e);
            }
        });
        this._desktopPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                GraphDesktopController.this.onMouseDragged(e);
            }
        });
        this.createPopUp();
    }

    private void onTablesDroped(DropTargetDropEvent dtde) {
        try {
            Object transferData = dtde.getTransferable().getTransferData(dtde.getTransferable().getTransferDataFlavors()[0]);
            if (transferData instanceof ObjectTreeDndTransfer) {
                ObjectTreeDndTransfer objectTreeDndTransfer = (ObjectTreeDndTransfer)transferData;
                if (!objectTreeDndTransfer.getSessionIdentifier().equals(this._session.getIdentifier())) {
                    JOptionPane.showMessageDialog(SwingUtilities.windowForComponent((Component)((Object)this._desktopPane)), s_stringMgr.getString("GraphDesktopController.tableDropedFormOtherSession"));
                    return;
                }
                this._listener.tablesDropped(objectTreeDndTransfer.getSelectedTables(), dtde.getLocation());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    EdgesListener createEdgesListener() {
        return new EdgesListener(){

            @Override
            public void edgesGraphComponentChanged(EdgesGraphComponent edgesGraphComponent, boolean put) {
                GraphDesktopController.this.onEdgesGraphComponentChanged(edgesGraphComponent, put);
            }
        };
    }

    private void onEdgesGraphComponentChanged(EdgesGraphComponent edgesGraphComponent, boolean put) {
        if (put) {
            this._desktopPane.putGraphComponents(new GraphComponent[]{edgesGraphComponent});
        } else {
            this._desktopPane.removeGraphComponents(new GraphComponent[]{edgesGraphComponent});
        }
        this._desktopPane.repaint();
    }

    private void createPopUp() {
        this._popUp = new JPopupMenu();
        this._mnuSaveGraph = new JMenuItem(s_stringMgr.getString("graph.saveGraph"));
        this._mnuSaveGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onSaveGraph();
            }
        });
        this._mnuRenameGraph = new JMenuItem(s_stringMgr.getString("graph.renameGraph"));
        this._mnuRenameGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onRenameGraph();
            }
        });
        this._mnuRemoveGraph = new JMenuItem(s_stringMgr.getString("graph.removeGraph"));
        this._mnuRemoveGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onRemoveGraph();
            }
        });
        this._mnuRefreshAllTables = new JMenuItem(s_stringMgr.getString("graph.refreshAllTables"));
        this._mnuRefreshAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onRefreshAllTables();
            }
        });
        this._mnuScriptAllTables = new JMenuItem(s_stringMgr.getString("graph.scriptAllTables"));
        this._mnuScriptAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onScriptAllTables();
            }
        });
        this._mnuSelectAllTables = new JMenuItem(s_stringMgr.getString("graph.selectAllTables"));
        this._mnuSelectAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onSelectAllTables();
            }
        });
        this._mnuSelectTablesByName = new JMenuItem(s_stringMgr.getString("graph.selectTablesByName"));
        this._mnuSelectTablesByName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onSelectTablesByName();
            }
        });
        this._mnuShowConstraintNames = new JCheckBoxMenuItem(s_stringMgr.getString("graph.showConstr"));
        this._mnuShowConstraintNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this._desktopPane.repaint();
            }
        });
        this._mnuShowQualifiedTableNames = new JCheckBoxMenuItem(s_stringMgr.getString("graph.showQualifiedTableNames"));
        this._mnuShowQualifiedTableNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onShowQualifiedTableNames();
            }
        });
        ImageIcon toWInIcon = this._graphPluginResources.getIcon("ToWindow");
        this._mnuToggleWindowTab = new JMenuItem(s_stringMgr.getString("graph.toggleWindowTab"), toWInIcon);
        this._mnuToggleWindowTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onToggleWindowTab();
            }
        });
        this._mnuAllTablesDbOrder = new JMenuItem(s_stringMgr.getString("graph.allTablesDbOrderRequested"));
        this._mnuAllTablesDbOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onAllTablesDbOrder();
            }
        });
        this._mnuAllTablesByNameOrder = new JMenuItem(s_stringMgr.getString("graph.allTablesByNameOrderRequested"));
        this._mnuAllTablesByNameOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onAllTablesByNameOrder();
            }
        });
        this._mnuAllTablesPkConstOrder = new JMenuItem(s_stringMgr.getString("graph.allTablesPkConstOrderRequested"));
        this._mnuAllTablesPkConstOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onAllTablesPkConstOrder();
            }
        });
        this._mnuAllFilteredSelectedOrder = new JMenuItem(s_stringMgr.getString("graph.allTablesFilteredSelectedOrderRequested"));
        this._mnuAllFilteredSelectedOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktopController.this.onAllTablesFilteredSelectedOrder();
            }
        });
        this._popUp.add(this._mnuSaveGraph);
        this._popUp.add(this._mnuRenameGraph);
        this._popUp.add(this._mnuRemoveGraph);
        this._popUp.add(new JSeparator());
        this._popUp.add(this._mnuRefreshAllTables);
        this._popUp.add(this._mnuScriptAllTables);
        this._popUp.add(new JSeparator());
        this._popUp.add(this._mnuSelectAllTables);
        this._popUp.add(this._mnuSelectTablesByName);
        this._popUp.add(new JSeparator());
        this._popUp.add(this._mnuAllTablesDbOrder);
        this._popUp.add(this._mnuAllTablesByNameOrder);
        this._popUp.add(this._mnuAllTablesPkConstOrder);
        this._popUp.add(this._mnuAllFilteredSelectedOrder);
        this._popUp.add(new JSeparator());
        this._popUp.add(this._mnuShowConstraintNames);
        this._popUp.add(this._mnuShowQualifiedTableNames);
        this._popUp.add(new JSeparator());
        this._popUp.add(this._mnuToggleWindowTab);
        this._popUp.add(new JSeparator());
        this._popUp.add(this._modeManager.getModeMenuItem());
        this._modeManager.addModeManagerListener(new ModeManagerListener(){

            @Override
            public void modeChanged(Mode newMode) {
                GraphDesktopController.this._popUp.setVisible(false);
            }
        });
        this._popUp.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GraphDesktopController.this.onPopupMenuWillBecomeInvisible();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void onPopupMenuWillBecomeInvisible() {
        if (null != this._currentGraphControllerPopupListener) {
            this._currentGraphControllerPopupListener.hiding();
            this._currentGraphControllerPopupListener = null;
        }
    }

    private void onShowQualifiedTableNames() {
        this._listener.showQualifiedTableNamesRequested();
    }

    private void onAllTablesPkConstOrder() {
        this._listener.allTablesPkConstOrderRequested();
    }

    private void onAllTablesByNameOrder() {
        this._listener.allTablesByNameOrderRequested();
    }

    private void onAllTablesDbOrder() {
        this._listener.allTablesDbOrderRequested();
    }

    private void onAllTablesFilteredSelectedOrder() {
        this._listener.allTablesFilteredSelectedOrderRequested();
    }

    private void onToggleWindowTab() {
        this._listener.toggleWindowTab();
    }

    private void onScriptAllTables() {
        this._listener.scriptAllTablesRequested();
    }

    private void onSelectAllTables() {
        for (JInternalFrame f : this._desktopPane.getAllFrames()) {
            if (!(f instanceof TableFrame)) continue;
            this._desktopPane.addGroupFrame((TableFrame)f);
        }
    }

    private void onSelectTablesByName() {
        String namePattern = JOptionPane.showInputDialog((Component)((Object)this._desktopPane), s_stringMgr.getString("graph.selectTablesByName.message"), s_stringMgr.getString("graph.selectTablesByName.title"), 3);
        if (null == namePattern || 0 == namePattern.trim().length()) {
            return;
        }
        this._desktopPane.clearGroupFrames();
        for (JInternalFrame f : this._desktopPane.getAllFrames()) {
            TableFrame tf;
            if (!(f instanceof TableFrame) || !(tf = (TableFrame)f).getTitle().matches(namePattern.replace('?', '.').replace("*", ".*"))) continue;
            this._desktopPane.addGroupFrame(tf);
        }
    }

    private void onRefreshAllTables() {
        this._listener.refreshAllTablesRequested();
    }

    private void onRemoveGraph() {
        Window parent = SwingUtilities.windowForComponent((Component)((Object)this._desktopPane));
        int res = JOptionPane.showConfirmDialog(parent, s_stringMgr.getString("graph.delGraph"));
        if (res == 0) {
            this._listener.removeRequest();
        }
    }

    private void onRenameGraph() {
        Window parent = SwingUtilities.windowForComponent((Component)((Object)this._desktopPane));
        String newName = JOptionPane.showInputDialog(parent, (Object)s_stringMgr.getString("graph.newName"));
        if (null != newName && 0 != newName.trim().length()) {
            this._listener.renameRequest(newName);
        }
    }

    private void onSaveGraph() {
        this._listener.saveGraphRequested();
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this._mnuAllFilteredSelectedOrder.setEnabled(this._modeManager.getMode().isQueryBuilder());
            this._popUp.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void putConstraintViews(ConstraintView[] constraintViews) {
        this._desktopPane.putGraphComponents(constraintViews);
    }

    public void removeConstraintViews(ConstraintView[] constraintViews, boolean keepFoldingPoints) {
        this._desktopPane.removeGraphComponents(constraintViews);
        if (!keepFoldingPoints) {
            for (int i = 0; i < constraintViews.length; ++i) {
                constraintViews[i].removeAllFoldingPoints();
            }
        }
    }

    private void refreshSelection(ConstraintView hitOne, boolean allowDeselect) {
        if (allowDeselect) {
            hitOne.setSelected(!hitOne.isSelected());
        } else if (!hitOne.isSelected()) {
            hitOne.setSelected(true);
        }
        Vector<GraphComponent> graphComponents = this._desktopPane.getGraphComponents();
        for (int i = 0; i < graphComponents.size(); ++i) {
            ConstraintView constraintView;
            if (!(graphComponents.elementAt(i) instanceof ConstraintView) || (constraintView = (ConstraintView)graphComponents.elementAt(i)).equals(hitOne)) continue;
            constraintView.setSelected(false);
        }
    }

    public void onMouseReleased(MouseEvent e) {
        this._lastPressedConstraintView = null;
        ConstraintHitData hitData = this.findHit(e);
        if (ConstraintHit.LINE == hitData.getConstraintHit()) {
            hitData.getConstraintView().mouseReleased(e);
        } else if (ConstraintHit.NONE == hitData.getConstraintHit()) {
            this.maybeShowPopup(e);
        }
    }

    public void onMousePressed(final MouseEvent e) {
        final ConstraintHitData hitData = this.findHit(e);
        if (ConstraintHit.LINE == hitData.getConstraintHit()) {
            this._lastPressedConstraintView = hitData.getConstraintView();
            if (4 == e.getModifiers()) {
                this.refreshSelection(hitData.getConstraintView(), false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        hitData.getConstraintView().mousePressed(e);
                    }
                });
            } else {
                hitData.getConstraintView().mousePressed(e);
            }
        } else if (ConstraintHit.NONE == hitData.getConstraintHit()) {
            this.maybeShowPopup(e);
        }
    }

    public void onMouseClicked(final MouseEvent e) {
        final ConstraintHitData hitData = this.findHit(e);
        if (ConstraintHit.LINE == hitData.getConstraintHit()) {
            this.refreshSelection(hitData.getConstraintView(), 16 == e.getModifiers());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    hitData.getConstraintView().mouseClicked(e);
                }
            });
        }
    }

    private void onMouseDragged(MouseEvent e) {
        if (null != this._lastPressedConstraintView) {
            this._lastPressedConstraintView.mouseDragged(e);
        }
    }

    private ConstraintHitData findHit(MouseEvent e) {
        Vector<GraphComponent> graphComponents = this._desktopPane.getGraphComponents();
        for (int i = 0; i < graphComponents.size(); ++i) {
            ConstraintView constraintView;
            ConstraintHit constraintHit;
            GraphComponent graphComponent = graphComponents.elementAt(i);
            if (!(graphComponent instanceof ConstraintView) || ConstraintHit.NONE == (constraintHit = (constraintView = (ConstraintView)graphComponents.elementAt(i)).hitMe(e))) continue;
            return new ConstraintHitData(constraintView, constraintHit);
        }
        return new ConstraintHitData(null, ConstraintHit.NONE);
    }

    public void repaint() {
        this._desktopPane.repaint();
    }

    public void addFrame(JInternalFrame frame) {
        this._desktopPane.hideStartupImage();
        this._desktopPane.add(frame);
    }

    public GraphDesktopPane getDesktopPane() {
        return this._desktopPane;
    }

    public boolean isShowConstraintNames() {
        return this._mnuShowConstraintNames.isSelected();
    }

    public void setShowConstraintNames(boolean showConstraintNames) {
        this._mnuShowConstraintNames.setSelected(showConstraintNames);
    }

    public Zoomer getZoomer() {
        return this._modeManager.getZoomer();
    }

    public ZoomPrintController getZoomPrintController() {
        return this._modeManager.getZoomPrintController();
    }

    public void sessionEnding() {
        this._modeManager.sessionEnding();
    }

    public void setShowQualifiedTableNames(boolean showQualifiedTableNames) {
        this._mnuShowQualifiedTableNames.setSelected(showQualifiedTableNames);
    }

    public boolean isShowQualifiedTableNames() {
        return this._mnuShowQualifiedTableNames.isSelected();
    }

    public ModeManager getModeManager() {
        return this._modeManager;
    }

    public GraphPluginResources getResource() {
        return this._graphPluginResources;
    }

    public void removeGraph() {
        this.onRemoveGraph();
    }

    public void showPopupAbove(Point loc, GraphControllerPopupListener graphControllerPopupListener) {
        if (this._popUp.isVisible()) {
            this._popUp.setVisible(false);
        } else {
            this._popUp.show((Component)((Object)this._desktopPane), 0, 0);
            this._popUp.setLocation(loc.x, loc.y - this._popUp.getHeight());
        }
        this._currentGraphControllerPopupListener = graphControllerPopupListener;
    }

    public void hidePopup() {
        this._popUp.setVisible(false);
    }

    public TableFramesModel getTableFramesModel() {
        return this._modeManager.getTableFramesModel();
    }
}

