/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.mainpanel.BaseMainPanelTab;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPanelController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.LazyLoadListener;

public class GraphMainPanelTab
extends BaseMainPanelTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GraphMainPanelTab.class);
    private GraphPanelController _panelController;
    private JPanel _tabComponent;
    private JLabel _lblTitle;
    private JButton _btnToWindow;
    private LazyLoadListener _lazyLoadListener;

    public GraphMainPanelTab(GraphPanelController panelController, GraphPlugin plugin) {
        this._panelController = panelController;
        this._tabComponent = new JPanel(new BorderLayout(3, 0));
        this._tabComponent.setOpaque(false);
        this._lblTitle = new JLabel(s_stringMgr.getString("graph.newGraph"));
        this._lblTitle.setOpaque(false);
        this._tabComponent.add((Component)this._lblTitle, "Center");
        ImageIcon icon = new GraphPluginResources((IPlugin)plugin).getIcon("ToWindow");
        this._btnToWindow = new JButton(icon);
        this._btnToWindow.setBorder(BorderFactory.createEmptyBorder());
        this._btnToWindow.setOpaque(false);
        this._tabComponent.add((Component)this._btnToWindow, "East");
    }

    protected void refreshComponent() {
        this._panelController.repaint();
        this._lazyLoadListener.lazyLoadTables();
    }

    public String getTitle() {
        return this._lblTitle.getText();
    }

    public Component getTabComponent() {
        return this._tabComponent;
    }

    public String getHint() {
        return s_stringMgr.getString("graph.rightClickTable");
    }

    public Component getComponent() {
        return this._panelController.getGraphPanel();
    }

    public void setTitle(String title) {
        this._lblTitle.setText(title);
    }

    public JButton getToWindowButton() {
        return this._btnToWindow;
    }

    public void removeGraph() {
        this._panelController.removeGraph();
    }

    public void setLazyLoadListener(LazyLoadListener lazyLoadListener) {
        this._lazyLoadListener = lazyLoadListener;
    }
}

