/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.graph.EdgesListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphControllerFacade;
import net.sourceforge.squirrel_sql.plugins.graph.GraphControllerPopupListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopPane;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.Mode;
import net.sourceforge.squirrel_sql.plugins.graph.ModeManager;
import net.sourceforge.squirrel_sql.plugins.graph.ModeManagerListener;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModel;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereTreeNodeStructure;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.OrderStructureXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.PrintXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.SelectStructureXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ZoomerXmlBean;

public class GraphPanelController {
    private GraphDesktopController _graphDesktopController;
    private JPanel _graphPanel;
    private ModeManager _modeManager;
    private JSplitPane _split;
    private JPanel _bottomPanelContainer;
    private int _standardDividerSize;

    public GraphPanelController(TableFramesModel tableFramesModel, GraphDesktopListener graphDesktopListener, ISession session, GraphPlugin plugin, boolean showDndDesktopImageAtStartup) {
        GraphControllerFacade graphControllerFacade = new GraphControllerFacade(){

            @Override
            public void showDock(JPanel panel, int lastHeight) {
                GraphPanelController.this.onShow(panel, lastHeight);
            }

            @Override
            public void hideDock() {
                GraphPanelController.this.onHide();
            }

            @Override
            public void showPopupAbove(Point loc, GraphControllerPopupListener graphControllerPopupListener) {
                GraphPanelController.this._graphDesktopController.showPopupAbove(loc, graphControllerPopupListener);
            }

            @Override
            public void hidePopup() {
                GraphPanelController.this._graphDesktopController.hidePopup();
            }

            @Override
            public void repaint() {
                GraphPanelController.this.repaint();
            }
        };
        this._modeManager = new ModeManager(tableFramesModel, session, plugin, graphControllerFacade);
        this._graphDesktopController = new GraphDesktopController(graphDesktopListener, session, plugin, this._modeManager, showDndDesktopImageAtStartup);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this._graphDesktopController.getDesktopPane()));
        this._split = new JSplitPane(0);
        this._split.setTopComponent(scrollPane);
        this._standardDividerSize = this._split.getDividerSize();
        this.onHide();
        this._graphPanel = new JPanel(new BorderLayout());
        this._graphPanel.add((Component)this._split, "Center");
        this._bottomPanelContainer = new JPanel(new GridLayout(1, 1));
        this._graphPanel.add((Component)this._bottomPanelContainer, "South");
    }

    private void onHide() {
        this._split.setDividerSize(0);
        this._split.setDividerLocation(Integer.MAX_VALUE);
    }

    private void onShow(JPanel panel, int lastHeight) {
        this._split.setBottomComponent(panel);
        this._split.setDividerLocation(this._split.getHeight() - lastHeight - this._standardDividerSize - 1);
        this._split.setDividerSize(this._standardDividerSize);
    }

    public GraphDesktopController getDesktopController() {
        return this._graphDesktopController;
    }

    public void repaint() {
        this._graphPanel.repaint();
        this._graphDesktopController.repaint();
    }

    public JPanel getGraphPanel() {
        return this._graphPanel;
    }

    public void initMode(Mode mode, ZoomerXmlBean zoomerXmlBean, PrintXmlBean printXmlBean, boolean queryHideNoJoins, SelectStructureXmlBean selectStructure, WhereTreeNodeStructure whereTreeNodeStructure, OrderStructureXmlBean orderStructure) {
        EdgesListener edgesListener = this._graphDesktopController.createEdgesListener();
        GraphDesktopPane desktopPane = this._graphDesktopController.getDesktopPane();
        this._modeManager.initMode(mode, zoomerXmlBean, printXmlBean, queryHideNoJoins, selectStructure, whereTreeNodeStructure, orderStructure, edgesListener, desktopPane);
        this.onModeChanged();
        this._modeManager.addModeManagerListener(new ModeManagerListener(){

            @Override
            public void modeChanged(Mode newMode) {
                GraphPanelController.this.onModeChanged();
            }
        });
    }

    private void onModeChanged() {
        this._bottomPanelContainer.removeAll();
        this._bottomPanelContainer.add(this._modeManager.getBottomPanel());
        this._bottomPanelContainer.revalidate();
        this._bottomPanelContainer.repaint();
        if (null != this._split.getBottomComponent()) {
            this._split.remove(this._split.getBottomComponent());
        }
        this.onHide();
    }

    public ModeManager getModeManager() {
        return this._modeManager;
    }

    public void sessionEnding() {
        this._graphDesktopController.sessionEnding();
    }

    public void removeGraph() {
        this._graphDesktopController.removeGraph();
    }
}

