/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallbackAdaptor;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.graph.AddToGraphAction;
import net.sourceforge.squirrel_sql.plugins.graph.GraphController;
import net.sourceforge.squirrel_sql.plugins.graph.NewQueryBuilderWindowAction;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphXmlSerializer;

public class GraphPlugin
extends DefaultSessionPlugin {
    private Hashtable<IIdentifier, GraphController[]> _grapControllersBySessionID = new Hashtable();
    private static ILogger s_log = LoggerController.createLogger(GraphPlugin.class);
    private PluginResources _resources;

    public String getInternalName() {
        return "graph";
    }

    public String getDescriptiveName() {
        return "Graph";
    }

    public String getVersion() {
        return "2.0";
    }

    public String getAuthor() {
        return "Gerd Wagner";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        IApplication app = this.getApplication();
        this._resources = new PluginResources("net.sourceforge.squirrel_sql.plugins.graph.graph", (IPlugin)this);
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new AddToGraphAction(app, (Resources)this._resources, this)));
        coll.add((Action)((Object)new NewQueryBuilderWindowAction(app, this._resources, this)));
    }

    public void unload() {
        super.unload();
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        GraphXmlSerializer[] serializers = GraphXmlSerializer.getGraphXmSerializers(this, session);
        GraphController[] controllers = new GraphController[serializers.length];
        for (int i = 0; i < controllers.length; ++i) {
            controllers[i] = new GraphController(session, this, serializers[i], false);
        }
        this._grapControllersBySessionID.put(session.getIdentifier(), controllers);
        IObjectTreeAPI api = session.getSessionInternalFrame().getObjectTreeAPI();
        ActionCollection coll = this.getApplication().getActionCollection();
        api.addToPopup(DatabaseObjectType.TABLE, coll.get(AddToGraphAction.class));
        session.addSeparatorToToolbar();
        session.addToToolbar(coll.get(NewQueryBuilderWindowAction.class));
        return new PluginSessionCallbackAdaptor((IPlugin)this);
    }

    public void sessionEnding(ISession session) {
        GraphController[] controllers = this._grapControllersBySessionID.remove(session.getIdentifier());
        for (int i = 0; i < controllers.length; ++i) {
            controllers[i].sessionEnding();
        }
    }

    public GraphController[] getGraphControllers(ISession session) {
        return this._grapControllersBySessionID.get(session.getIdentifier());
    }

    public String patchName(String name, ISession session) {
        boolean incremented;
        int postfix = 0;
        if ("Objects".equals(name)) {
            ++postfix;
        }
        if ("SQL".equals(name)) {
            ++postfix;
        }
        GraphController[] controllers = this._grapControllersBySessionID.get(session.getIdentifier());
        do {
            incremented = false;
            for (int i = 0; i < controllers.length; ++i) {
                if (0 == postfix) {
                    if (!controllers[i].getTitle().equals(name)) continue;
                    ++postfix;
                    incremented = true;
                    continue;
                }
                if (!controllers[i].getTitle().equals(name + "_" + postfix)) continue;
                ++postfix;
                incremented = true;
            }
        } while (incremented);
        if (0 == postfix) {
            return name;
        }
        return name + "_" + postfix;
    }

    public GraphController createNewGraphControllerForSession(ISession session, boolean showDndDesktopImageAtStartup) {
        GraphController[] controllers = this._grapControllersBySessionID.get(session.getIdentifier());
        Vector<GraphController> v = new Vector<GraphController>();
        if (null != controllers) {
            v.addAll(Arrays.asList(controllers));
        }
        GraphController ret = new GraphController(session, this, null, showDndDesktopImageAtStartup);
        v.add(ret);
        controllers = v.toArray(new GraphController[v.size()]);
        this._grapControllersBySessionID.put(session.getIdentifier(), controllers);
        return ret;
    }

    public void removeGraphController(GraphController toRemove, ISession session) {
        GraphController[] controllers = this._grapControllersBySessionID.get(session.getIdentifier());
        Vector<GraphController> v = new Vector<GraphController>();
        for (int i = 0; i < controllers.length; ++i) {
            if (controllers[i].equals(toRemove)) continue;
            v.add(controllers[i]);
        }
        controllers = v.toArray(new GraphController[v.size()]);
        this._grapControllersBySessionID.put(session.getIdentifier(), controllers);
    }
}

