/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import net.sourceforge.squirrel_sql.plugins.graph.AggregateFunctions;
import net.sourceforge.squirrel_sql.plugins.graph.Sorting;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.QueryFilterOperators;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.QueryDataXmlBean;

public class QueryData {
    private String _filterValue;
    private QueryFilterOperators _operator = QueryFilterOperators.EQUAL;
    private AggregateFunctions _aggregateFunction = AggregateFunctions.NONE;
    private boolean _inSelectClause;
    private Sorting _sorting = Sorting.NONE;

    public QueryData(QueryDataXmlBean queryDataXmlBean) {
        if (null != queryDataXmlBean) {
            this._inSelectClause = queryDataXmlBean.isInSelectClause();
            this._filterValue = queryDataXmlBean.getFilterValue();
            this._operator = QueryFilterOperators.getForIndex(queryDataXmlBean.getOperatorIndex());
            this._aggregateFunction = AggregateFunctions.getForIndex(queryDataXmlBean.getAggregateFunctionIndex());
            this._sorting = Sorting.getByIndex(queryDataXmlBean.getSortingIndex());
        }
    }

    public QueryData() {
    }

    public void setFilterValue(String filterValue) {
        this._filterValue = filterValue;
    }

    public String getFilterValue() {
        return this._filterValue;
    }

    public void setOperator(QueryFilterOperators operator) {
        this._operator = operator;
    }

    public QueryFilterOperators getOperator() {
        return this._operator;
    }

    public boolean isFiltered() {
        if (QueryFilterOperators.isNoArgOperator(this._operator)) {
            return true;
        }
        return null != this._filterValue && 0 != this._filterValue.trim().length();
    }

    public void setAggregateFunction(AggregateFunctions aggregateFunction) {
        this._aggregateFunction = aggregateFunction;
    }

    public AggregateFunctions getAggregateFunction() {
        return this._aggregateFunction;
    }

    public boolean isInSelectClause() {
        return this._inSelectClause;
    }

    public void setInSelectClause(boolean b) {
        this._inSelectClause = b;
        if (!b) {
            this._aggregateFunction = AggregateFunctions.NONE;
        }
    }

    public void clearFilter() {
        this._filterValue = null;
        this._operator = QueryFilterOperators.EQUAL;
    }

    public Sorting getSorting() {
        return this._sorting;
    }

    public void setSorting(Sorting sorting) {
        this._sorting = sorting;
    }

    public boolean isSorted() {
        return this._sorting != Sorting.NONE;
    }

    public boolean isSortedAsc() {
        return this._sorting != Sorting.ASC;
    }
}

