/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.event.SQLExecutionAdapter;
import net.sourceforge.squirrel_sql.plugins.graph.HideDockButtonHandler;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.GraphQueryResultPanel;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SyncListener;

public class GraphQueryResultPanelCtrl {
    private GraphQueryResultPanel _graphQueryResultPanel;
    private String _lastSQL;
    private boolean _isExecuting;
    private String _nextSQL;

    public GraphQueryResultPanelCtrl(ISession session, HideDockButtonHandler hideDockButtonHandler, final SyncListener syncListener) {
        this._graphQueryResultPanel = new GraphQueryResultPanel(session, hideDockButtonHandler);
        this._graphQueryResultPanel.btnSyncSQLNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                syncListener.synRequested();
            }
        });
        this._graphQueryResultPanel.chkAutoSyncSQL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphQueryResultPanelCtrl.this.onAutoSyncChanged(syncListener);
            }
        });
        this._graphQueryResultPanel.resultExecuterPanel.addSQLExecutionListener((ISQLExecutionListener)new SQLExecutionAdapter(){

            public void executionFinished() {
                GraphQueryResultPanelCtrl.this.onSQLExecutionFinished();
            }
        });
    }

    private void onSQLExecutionFinished() {
        this._isExecuting = false;
        if (null != this._nextSQL) {
            String nextSQL = this._nextSQL;
            this._nextSQL = null;
            this.execSQL(nextSQL);
        }
    }

    private void onAutoSyncChanged(SyncListener syncListener) {
        if (this._graphQueryResultPanel.chkAutoSyncSQL.isSelected()) {
            syncListener.synRequested();
        }
    }

    public void execSQL(String sql) {
        if (null != this._lastSQL && this._lastSQL.trim().equals(sql)) {
            return;
        }
        this._lastSQL = null;
        if (null == sql || 0 == sql.trim().length()) {
            return;
        }
        if (this._isExecuting) {
            this._nextSQL = sql;
            return;
        }
        this._isExecuting = true;
        this._graphQueryResultPanel.resultExecuterPanel.executeSQL(sql);
        this._lastSQL = sql;
    }

    public GraphQueryResultPanel getGraphQueryResultPanel() {
        return this._graphQueryResultPanel;
    }

    public boolean isAutoSync() {
        return this._graphQueryResultPanel.chkAutoSyncSQL.isSelected();
    }
}

