/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import net.sourceforge.squirrel_sql.client.session.EntryPanelManager;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.graph.HideDockButtonHandler;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.GraphQuerySQLPanel;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SyncListener;

public class GraphQuerySQLPanelCtrl {
    private GraphQuerySQLPanel _graphQuerySQLPanel;
    private EntryPanelManager _entryPanelManager;
    private static final String PREF_KEY_SQUIRREL_GRAPH_SQL_AUTO_SYNC = "Squirrel.graph.sqlAutoSync";

    public GraphQuerySQLPanelCtrl(ISession session, HideDockButtonHandler hideDockButtonHandler, final SyncListener syncListener) {
        this._entryPanelManager = new EntryPanelManager(session);
        this._entryPanelManager.init(null, null);
        this._graphQuerySQLPanel = new GraphQuerySQLPanel(this._entryPanelManager.getComponent(), hideDockButtonHandler);
        this._graphQuerySQLPanel.chkAutoSyncSQL.setSelected(Preferences.userRoot().getBoolean(PREF_KEY_SQUIRREL_GRAPH_SQL_AUTO_SYNC, true));
        this._graphQuerySQLPanel.chkAutoSyncSQL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphQuerySQLPanelCtrl.this.onAutoSyncChanged(syncListener);
            }
        });
        this._graphQuerySQLPanel.btnSyncSQLNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                syncListener.synRequested();
            }
        });
    }

    private void onAutoSyncChanged(SyncListener syncListener) {
        Preferences.userRoot().putBoolean(PREF_KEY_SQUIRREL_GRAPH_SQL_AUTO_SYNC, this._graphQuerySQLPanel.chkAutoSyncSQL.isSelected());
        if (this._graphQuerySQLPanel.chkAutoSyncSQL.isSelected()) {
            syncListener.synRequested();
        }
    }

    public GraphQuerySQLPanel getGraphQuerySQLPanel() {
        return this._graphQuerySQLPanel;
    }

    public void setSQL(String sql) {
        this._entryPanelManager.getEntryPanel().setText(sql, false);
    }

    public boolean isAutoSync() {
        return this._graphQuerySQLPanel.chkAutoSyncSQL.isSelected();
    }
}

