/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.xmlbeans;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphControllerXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.Version32Converter;

public class GraphXmlSerializer {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GraphXmlSerializer.class);
    private static final String XML_BEAN_POSTFIX = ".graph.xml";
    private GraphPlugin _plugin;
    private ISession _session;
    private String _graphFile;

    public GraphXmlSerializer(GraphPlugin plugin, ISession session, String title, String graphFileName) {
        try {
            this._plugin = plugin;
            this._session = session;
            String url = this._session.getAlias().getUrl();
            this._graphFile = null == graphFileName ? this.getFileName(plugin.getPluginUserSettingsFolder().getPath(), url, title) : graphFileName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(GraphControllerXmlBean xmlBean) {
        try {
            Version32Converter.markConverted(xmlBean);
            XMLBeanWriter bw = new XMLBeanWriter((Object)xmlBean);
            bw.save(this._graphFile);
            String[] params = new String[]{xmlBean.getTitle(), this._graphFile};
            String msg = s_stringMgr.getString("graph.graphSaved", params);
            this._session.showMessage(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GraphControllerXmlBean read() {
        try {
            XMLBeanReader br = new XMLBeanReader();
            br.load(this._graphFile, this.getClass().getClassLoader());
            GraphControllerXmlBean ret = (GraphControllerXmlBean)br.iterator().next();
            Version32Converter.convert(ret);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getFileName(String path, String url, String title) {
        String filePrefix = GraphXmlSerializer.javaNormalize(url) + "." + GraphXmlSerializer.javaNormalize(title);
        File p = new File(path);
        String buf = filePrefix;
        int i = 1;
        while (this.prefixExists(p, buf)) {
            buf = filePrefix + "_" + i;
            ++i;
        }
        return path + File.separator + buf + XML_BEAN_POSTFIX;
    }

    private boolean prefixExists(File path, final String filePrefix) {
        File[] files = path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().equals(filePrefix.toLowerCase() + GraphXmlSerializer.XML_BEAN_POSTFIX);
            }
        });
        return 0 < files.length;
    }

    private static String javaNormalize(String text) {
        StringBuffer buf = new StringBuffer(text.length());
        if (Character.isJavaIdentifierStart(text.charAt(0))) {
            buf.append(text.charAt(0));
        } else {
            buf.append('_');
        }
        for (int i = 1; i < text.length(); ++i) {
            if (Character.isLetterOrDigit(text.charAt(i))) {
                buf.append(text.charAt(i));
                continue;
            }
            buf.append('_');
        }
        String ret = buf.toString();
        return ret;
    }

    public static GraphXmlSerializer[] getGraphXmSerializers(GraphPlugin plugin, ISession session) {
        try {
            FileWrapper settingsPath = plugin.getPluginUserSettingsFolder();
            final String urlPrefix = GraphXmlSerializer.javaNormalize(session.getAlias().getUrl()) + ".";
            FileWrapper[] graphXmlFiles = settingsPath.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(urlPrefix);
                }
            });
            GraphXmlSerializer[] ret = new GraphXmlSerializer[graphXmlFiles.length];
            for (int i = 0; i < graphXmlFiles.length; ++i) {
                ret[i] = new GraphXmlSerializer(plugin, session, null, graphXmlFiles[i].getPath());
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void rename(String newName) {
        try {
            String url = this._session.getAlias().getUrl();
            String newGraphFile = this.getFileName(this._plugin.getPluginUserSettingsFolder().getPath(), url, newName);
            new File(this._graphFile).renameTo(new File(newGraphFile));
            String[] params = new String[]{this._graphFile, newGraphFile};
            this._session.showMessage(s_stringMgr.getString("graph.graphRenamed", params));
            this._graphFile = newGraphFile;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void remove() {
        new File(this._graphFile).delete();
        String[] params = new String[]{this._graphFile};
        this._session.showMessage(s_stringMgr.getString("graph.graphRemoved", params));
    }
}

