/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.GraphController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphSelectionDialog;

public class GraphSelectionDialogController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GraphSelectionDialogController.class);
    GraphSelectionDialog _dlg;
    private boolean _ok;
    private GraphController m_selectedController;
    private JFrame _parent;

    public GraphSelectionDialogController(GraphController[] controllers, JFrame parent) {
        this._parent = parent;
        this._dlg = new GraphSelectionDialog(parent);
        this._dlg.lstControllers.setListData(controllers);
        this._dlg.lstControllers.setSelectedIndex(0);
        this._dlg.lstControllers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GraphSelectionDialogController.this.onMouseClickedList(e);
            }
        });
        this._dlg.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphSelectionDialogController.this.onOK();
            }
        });
        this._dlg.btnCreateNewGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphSelectionDialogController.this.onCreateNewGraph();
            }
        });
        this._dlg.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphSelectionDialogController.this.onCancel();
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphSelectionDialogController.this.close();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this._dlg.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    private void onCancel() {
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onCreateNewGraph() {
        this._ok = true;
        this.close();
    }

    private void onOK() {
        this.processSelection();
    }

    private void onMouseClickedList(MouseEvent e) {
        if (1 < e.getClickCount()) {
            this.processSelection();
        }
    }

    private void processSelection() {
        if (null == this._dlg.lstControllers.getSelectedValue()) {
            JOptionPane.showMessageDialog(this._parent, s_stringMgr.getString("graph.noSel"));
            return;
        }
        this.close();
        this._ok = true;
        if (this._dlg.lstControllers.getSelectedValue() instanceof GraphController) {
            this.m_selectedController = (GraphController)this._dlg.lstControllers.getSelectedValue();
        }
    }

    public void doModal() {
        GUIUtils.centerWithinParent((Window)this._dlg);
        this._dlg.setVisible(true);
    }

    public boolean isOK() {
        return this._ok;
    }

    public GraphController getSelectedController() {
        return this.m_selectedController;
    }
}

