/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.netezza;

import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginQueryTokenizerPreferencesManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginGlobalPreferencesTab;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginQueryTokenizerPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpanderFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.SchemaExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.netezza.exp.NetezzaExtTableInodeExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.netezza.exp.NetezzaSequenceInodeExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.netezza.exp.NetezzaSynonymInodeExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.netezza.prefs.NetezzaPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.netezza.tab.ExternalTableDetailsTab;
import net.sourceforge.squirrel_sql.plugins.netezza.tab.ProcedureSourceTab;
import net.sourceforge.squirrel_sql.plugins.netezza.tab.SynonymDetailsTab;
import net.sourceforge.squirrel_sql.plugins.netezza.tab.SynonymSourceTab;
import net.sourceforge.squirrel_sql.plugins.netezza.tab.ViewSourceTab;
import net.sourceforge.squirrel_sql.plugins.netezza.tokenizer.NetezzaQueryTokenizer;

public class NetezzaPlugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(NetezzaPlugin.class);
    private PluginQueryTokenizerPreferencesManager _prefsManager = null;

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getDescriptiveName() {
        return "Netezza Plugin";
    }

    public String getInternalName() {
        return "netezza";
    }

    public String getVersion() {
        return "0.02";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isNetezza((ISQLDatabaseMetaData)session.getMetaData());
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        PluginQueryTokenizerPreferencesPanel _prefsPanel = new PluginQueryTokenizerPreferencesPanel(this._prefsManager, "Netezza");
        PluginGlobalPreferencesTab tab = new PluginGlobalPreferencesTab(_prefsPanel);
        tab.setHint(i18n.PREFS_HINT);
        tab.setTitle("Netezza");
        return new IGlobalPreferencesPanel[]{tab};
    }

    public void initialize() throws PluginException {
        this._prefsManager = new PluginQueryTokenizerPreferencesManager();
        this._prefsManager.initialize((IPlugin)this, (IQueryTokenizerPreferenceBean)new NetezzaPreferenceBean());
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        if (!DialectFactory.isNetezza((ISQLDatabaseMetaData)session.getMetaData())) {
            return null;
        }
        session.setQueryTokenizer((IQueryTokenizer)new NetezzaQueryTokenizer(this._prefsManager.getPreferences()));
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                NetezzaPlugin.this.updateObjectTree(session.getObjectTreeAPIOfActiveSessionWindow());
            }
        });
        return null;
    }

    private void updateObjectTree(IObjectTreeAPI objTree) {
        String stmtSep = this._prefsManager.getPreferences().getStatementSeparator();
        objTree.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new NetezzaSequenceInodeExpanderFactory(), DatabaseObjectType.SEQUENCE_TYPE_DBO));
        objTree.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new NetezzaSynonymInodeExpanderFactory(), DatabaseObjectType.SYNONYM_TYPE_DBO));
        objTree.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new NetezzaExtTableInodeExpanderFactory(), DatabaseObjectType.TABLE_TYPE_DBO));
        objTree.addDetailTab(DatabaseObjectType.PROCEDURE, (IObjectTab)new ProcedureSourceTab(stmtSep));
        objTree.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new DatabaseObjectInfoTab());
        objTree.addDetailTab(DatabaseObjectType.SYNONYM, (IObjectTab)new DatabaseObjectInfoTab());
        objTree.addDetailTab(DatabaseObjectType.SYNONYM, (IObjectTab)new SynonymDetailsTab());
        objTree.addDetailTab(DatabaseObjectType.SYNONYM, (IObjectTab)new SynonymSourceTab(stmtSep));
        objTree.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new DatabaseObjectInfoTab());
        objTree.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(stmtSep));
        objTree.addDetailTab(DatabaseObjectType.TABLE, (IObjectTab)new ExternalTableDetailsTab());
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String PREFS_HINT = NetezzaPlugin.access$000().getString("NetezzaPlugin.prefsHint");
    }
}

