/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.exception;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.DefaultExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class OracleExceptionFormatter
extends SessionAdapter
implements ISessionListener,
ExceptionFormatter {
    private static final ILogger s_log = LoggerController.createLogger(OracleExceptionFormatter.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OracleExceptionFormatter.class);
    private ISession _session = null;
    private DefaultExceptionFormatter formatter = new DefaultExceptionFormatter();
    private boolean offsetFunctionAvailable = false;
    private ISQLEntryPanel sqlEntryPanel = null;
    public static final String OFFSET_FUNCTION_NAME = "SQUIRREL_GET_ERROR_OFFSET";
    private static final String OFFSET_FUNCTION = "create or replace function SQUIRREL_GET_ERROR_OFFSET (query IN varchar2) return number authid current_user is      l_theCursor     integer default dbms_sql.open_cursor;      l_status        integer; begin          begin          dbms_sql.parse(  l_theCursor, query, dbms_sql.native );          exception                  when others then l_status := dbms_sql.last_error_position;          end;          dbms_sql.close_cursor( l_theCursor );          return l_status; end; ";

    public void setSession(ISession session) {
        this._session = session;
        this.sqlEntryPanel = session.getSQLPanelAPIOfActiveSessionWindow().getSQLEntryPanel();
        try {
            if (!this.isOffsetFunctionAvailable() && this.initOffsetFunction()) {
                this.offsetFunctionAvailable = true;
            }
        }
        catch (SQLException e) {
            s_log.error((Object)("setSession: Unexpected exception - " + e.getMessage()), (Throwable)e);
        }
    }

    public String format(Throwable t) throws Exception {
        int position;
        StringBuilder result = new StringBuilder(this.formatter.format(t));
        String sql = this.getCurrentSql();
        if (sql != null && (position = this.getErrorPosition(sql)) != -1) {
            result.append("\n");
            result.append(i18n.POSITION_LABEL);
            result.append(position);
            int[] bounds = this.sqlEntryPanel.getBoundsOfSQLToBeExecuted();
            int start = bounds[0];
            int newPosition = start + position;
            this.sqlEntryPanel.setCaretPosition(newPosition);
        }
        return result.toString();
    }

    public boolean formatsException(Throwable t) {
        return true;
    }

    private String getCurrentSql() {
        String result = null;
        ISQLPanelAPI api = this._session.getSQLPanelAPIOfActiveSessionWindow();
        result = api.getSQLEntryPanel().getSQLToBeExecuted();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getErrorPosition(String sql) throws SQLException {
        int result = -1;
        ISQLConnection sqlcon = this._session.getSQLConnection();
        Connection con = sqlcon.getConnection();
        CallableStatement cstmt = null;
        try {
            String callSql = "{?=call SQUIRREL_GET_ERROR_OFFSET(?)}";
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("getErrorPosition: Executing sql: " + callSql));
                s_log.debug((Object)("getErrorPosition: errant SQL was: " + sql));
            }
            cstmt = con.prepareCall(callSql);
            cstmt.registerOutParameter(1, 4);
            cstmt.setString(2, sql);
            cstmt.execute();
            result = cstmt.getInt(1);
        }
        catch (SQLException e) {
            try {
                s_log.error((Object)("getErrorPosition: Unexpected exception - " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeStatement(cstmt);
                throw throwable;
            }
            SQLUtilities.closeStatement((Statement)cstmt);
        }
        SQLUtilities.closeStatement((Statement)cstmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initOffsetFunction() throws SQLException {
        ISQLConnection sqlcon = this._session.getSQLConnection();
        Connection con = sqlcon.getConnection();
        Statement cstmt = null;
        Statement stmt = null;
        boolean result = true;
        try {
            stmt = con.createStatement();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"initOffsetFunction: Executing sql: create or replace function SQUIRREL_GET_ERROR_OFFSET (query IN varchar2) return number authid current_user is      l_theCursor     integer default dbms_sql.open_cursor;      l_status        integer; begin          begin          dbms_sql.parse(  l_theCursor, query, dbms_sql.native );          exception                  when others then l_status := dbms_sql.last_error_position;          end;          dbms_sql.close_cursor( l_theCursor );          return l_status; end; ");
            }
            stmt.executeUpdate(OFFSET_FUNCTION);
        }
        catch (SQLException e) {
            result = false;
            s_log.error((Object)("initOffsetFunction: Unexpected exception - " + e.getMessage()), (Throwable)e);
        }
        finally {
            SQLUtilities.closeStatement(cstmt);
            SQLUtilities.closeStatement((Statement)stmt);
        }
        return result;
    }

    private boolean isOffsetFunctionAvailable() throws SQLException {
        String[] functionNames;
        if (this.offsetFunctionAvailable) {
            return true;
        }
        boolean result = false;
        for (String functionName : functionNames = this._session.getMetaData().getStringFunctions()) {
            if (!OFFSET_FUNCTION_NAME.equals(functionName)) continue;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"isOffsetFunctionAvailable: Found offset function: SQUIRREL_GET_ERROR_OFFSET");
            }
            result = true;
            break;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"isOffsetFunctionAvailable: Couldn't locate offset function: SQUIRREL_GET_ERROR_OFFSET");
        }
        return result;
    }

    public void allSessionsClosed() {
        this._session.getApplication().getSessionManager().removeSessionListener((ISessionListener)this);
        this._session = null;
    }

    public void sessionClosed(SessionEvent evt) {
        if (evt.getSession() == this._session) {
            this._session.getApplication().getSessionManager().removeSessionListener((ISessionListener)this);
            this._session = null;
        }
    }

    public void sessionClosing(SessionEvent evt) {
        if (evt.getSession() == this._session) {
            this._session.getApplication().getSessionManager().removeSessionListener((ISessionListener)this);
            this._session = null;
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String POSITION_LABEL = OracleExceptionFormatter.access$000().getString("OracleExceptionFormatter.positionLabel");
    }
}

