/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.invalidobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrame;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrameCallback;
import net.sourceforge.squirrel_sql.plugins.oracle.invalidobjects.GetInvalidObjectsAction;
import net.sourceforge.squirrel_sql.plugins.oracle.invalidobjects.InvalidObjectsPanel;

public class InvalidObjectsInternalFrame
extends OracleInternalFrame {
    private static final String PREF_PART_INVALID_FRAME = "InvalidFrame";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(InvalidObjectsInternalFrame.class);
    private InvalidObjectsPanel _invalidObjectsPanel;
    private InvalidObjectsToolBar _toolBar;
    private Resources _resources;

    public InvalidObjectsInternalFrame(ISession session, Resources resources) {
        super(session, s_stringMgr.getString("oracle.invalidTitle", new Object[]{session.getTitle()}));
        this._resources = resources;
        this.createGUI(session);
    }

    public InvalidObjectsPanel getDBOutputPanel() {
        return this._invalidObjectsPanel;
    }

    private void createGUI(ISession session) {
        this.addWidgetListener((WidgetListener)new WidgetAdapter(){

            public void widgetClosing(WidgetEvent e) {
                InvalidObjectsInternalFrame.super.internalFrameClosing(InvalidObjectsInternalFrame.this._toolBar.isStayOnTop(), 0);
            }
        });
        ImageIcon icon = this._resources.getIcon(((Object)((Object)this)).getClass(), "frameIcon");
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        OracleInternalFrameCallback cb = new OracleInternalFrameCallback(){

            @Override
            public void createPanelAndToolBar(boolean stayOnTop, int autoRefeshPeriod) {
                InvalidObjectsInternalFrame.this._invalidObjectsPanel = new InvalidObjectsPanel(InvalidObjectsInternalFrame.this.getSession());
                InvalidObjectsInternalFrame.this._toolBar = new InvalidObjectsToolBar(InvalidObjectsInternalFrame.this.getSession(), stayOnTop);
                JPanel contentPanel = new JPanel(new BorderLayout());
                contentPanel.add((Component)((Object)InvalidObjectsInternalFrame.this._toolBar), "North");
                contentPanel.add((Component)InvalidObjectsInternalFrame.this._invalidObjectsPanel, "Center");
                InvalidObjectsInternalFrame.this.setContentPane(contentPanel);
            }
        };
        this.initFromPrefs(PREF_PART_INVALID_FRAME, cb);
    }

    private class InvalidObjectsToolBar
    extends OracleInternalFrame.OracleToolBar {
        InvalidObjectsToolBar(ISession session, boolean stayOnTop) {
            super(InvalidObjectsInternalFrame.this);
            this.createGUI(session, stayOnTop);
        }

        private void createGUI(ISession session, boolean stayOnTop) {
            IApplication app = session.getApplication();
            this.setUseRolloverButtons(true);
            this.setFloatable(false);
            this.add((Action)((Object)new GetInvalidObjectsAction(app, InvalidObjectsInternalFrame.this._resources, InvalidObjectsInternalFrame.this._invalidObjectsPanel)));
            this.addStayOnTop(stayOnTop);
        }
    }
}

