/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.tab;

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourcePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourceTab;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.ConstraintInfo;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.ConstraintSourceBuilder;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.TriggerSourceTab;

public class ConstraintSourceTab
extends BaseSourceTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TriggerSourceTab.class);
    private static final ILogger s_log = LoggerController.createLogger(BaseSourceTab.class);
    private static String SQL = "select owner, constraint_name, constraint_type, table_name, search_condition, r_owner, r_constraint_name, delete_rule, generated from all_constraints where owner = ? and constraint_name = ?";

    public ConstraintSourceTab() {
        super(s_stringMgr.getString("oracle.showConstraintSource"));
        super.setSourcePanel((BaseSourcePanel)new ConstraintSourcePanel());
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        ISQLConnection conn = session.getSQLConnection();
        PreparedStatement pstmt = conn.prepareStatement(SQL);
        pstmt.setString(1, doi.getSchemaName());
        pstmt.setString(2, doi.getSimpleName());
        return pstmt;
    }

    private final class ConstraintSourcePanel
    extends BaseSourcePanel {
        private static final long serialVersionUID = 1L;
        private JTextArea textArea;

        ConstraintSourcePanel() {
            super((LayoutManager)new BorderLayout());
            this.textArea = new JTextArea();
            this.textArea.setEditable(false);
            this.add(this.textArea, "Center");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(ISession session, PreparedStatement stmt) {
            this.textArea.setWrapStyleWord(true);
            ConstraintSourceBuilder csb = new ConstraintSourceBuilder(session);
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery();
                if (rs.next()) {
                    ConstraintInfo ci = new ConstraintInfo(rs.getString(1), rs.getString(2), ConstraintInfo.ConstraintType.valueOf(rs.getString(3)), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(8), rs.getString(9));
                    csb.buildConstraintSource(ci);
                    if (csb.getConstraintSource() != null) {
                        this.textArea.setText(csb.getConstraintSource());
                    } else {
                        this.textArea.setText("Source NOT available");
                    }
                }
            }
            catch (Exception ex) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Unexpected exception while formatting object source code", (Throwable)ex);
                }
                session.showErrorMessage((Throwable)ex);
            }
            finally {
                SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
            }
        }
    }
}

