/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark;

import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.AddBookmarkAction;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.Bookmark;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BookmarkManager;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BoomarksExternalServiceImpl;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.CompleteBookmarkAction;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.DefaultBookmarksFactory;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.EditBookmarksAction;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.RunBookmarkAction;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkPreferencesController;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkResources;

public class SQLBookmarkPlugin
extends DefaultSessionPlugin {
    private static final ILogger s_log = LoggerController.createLogger(SQLBookmarkPlugin.class);
    private ArrayList<ISQLPanelAPI> _sqlPanelAPIsListeningForBookmarks = new ArrayList();
    private static final String BOOKMARKS_PROPS_FILE = "bookmarks.properties";
    static final String BOOKMARK_PROP_DEFAULT_MARKS_IN_POPUP = "squirrelMarksInPopup";
    private Properties _boomarkProps;
    public static final String RESOURCE_PATH = "net.sourceforge.squirrel_sql.plugins.sqlbookmark.sqlbookmark";
    private static ILogger logger = LoggerController.createLogger(SQLBookmarkPlugin.class);
    private PluginResources resources;
    private JMenu menu;
    private BookmarkManager bookmarkManager;

    public String getVersion() {
        return "2.0.1";
    }

    public String getAuthor() {
        return "Joseph Mocker";
    }

    public String getContributors() {
        return "Gerd Wagner";
    }

    public String getInternalName() {
        return "sqlbookmark";
    }

    public String getDescriptiveName() {
        return "SQL Bookmark Plugin";
    }

    public String getHelpFileName() {
        return "readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    protected PluginResources getResources() {
        return this.resources;
    }

    protected String getResourceString(String name) {
        return this.resources.getString(name);
    }

    BookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    protected void setBookmarkManager(BookmarkManager bookmarks) {
        this.bookmarkManager = bookmarks;
    }

    public Object getExternalService() {
        return new BoomarksExternalServiceImpl(this);
    }

    public synchronized void initialize() throws PluginException {
        IApplication app;
        block2: {
            super.initialize();
            app = this.getApplication();
            this.resources = new SQLBookmarkResources(RESOURCE_PATH, (IPlugin)this);
            this.bookmarkManager = new BookmarkManager(this);
            try {
                this.bookmarkManager.load();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block2;
                logger.error((Object)"Problem loading bookmarkManager", (Throwable)e);
            }
        }
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new AddBookmarkAction(app, (Resources)this.resources, this)));
        coll.add((Action)((Object)new EditBookmarksAction(app, (Resources)this.resources, this)));
        coll.add((Action)((Object)new RunBookmarkAction(app, (Resources)this.resources, this)));
        this.createMenu();
        this.rebuildMenu();
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SQLBookmarkPlugin.this.addBookmarkAction(session);
            }
        });
        PluginSessionCallback ret = new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
                ActionCollection coll = SQLBookmarkPlugin.this.getApplication().getActionCollection();
                sqlInternalFrame.addSeparatorToToolbar();
                sqlInternalFrame.addToToolbar(coll.get(AddBookmarkAction.class));
                sqlInternalFrame.addToToolbar(coll.get(EditBookmarksAction.class));
                sqlInternalFrame.addToToolsPopUp("bookmarkadd", coll.get(AddBookmarkAction.class));
                sqlInternalFrame.addToToolsPopUp("bookmarkedit", coll.get(EditBookmarksAction.class));
                ISQLPanelAPI sqlPaneAPI = sqlInternalFrame.getSQLPanelAPI();
                CompleteBookmarkAction cba = new CompleteBookmarkAction(sess.getApplication(), SQLBookmarkPlugin.this.resources, sqlPaneAPI.getSQLEntryPanel(), SQLBookmarkPlugin.this);
                JMenuItem item = sqlPaneAPI.addToSQLEntryAreaMenu((Action)((Object)cba));
                SQLBookmarkPlugin.this.resources.configureMenuItem((Action)((Object)cba), item);
                JTextComponent comp = sqlPaneAPI.getSQLEntryPanel().getTextComponent();
                comp.registerKeyboardAction((ActionListener)((Object)cba), SQLBookmarkPlugin.this.resources.getKeyStroke((Action)((Object)cba)), 1);
                sqlInternalFrame.addToToolsPopUp("bookmarkselect", (Action)((Object)cba));
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
            }
        };
        return ret;
    }

    private void addBookmarkAction(ISession session) {
        ActionCollection coll = this.getApplication().getActionCollection();
        session.addSeparatorToToolbar();
        session.addToToolbar(coll.get(AddBookmarkAction.class));
        session.addToToolbar(coll.get(EditBookmarksAction.class));
        session.getSessionInternalFrame().addToToolsPopUp("bookmarkadd", coll.get(AddBookmarkAction.class));
        session.getSessionInternalFrame().addToToolsPopUp("bookmarkedit", coll.get(EditBookmarksAction.class));
        ISQLPanelAPI sqlPaneAPI = session.getSessionInternalFrame().getSQLPanelAPI();
        CompleteBookmarkAction cba = new CompleteBookmarkAction(session.getApplication(), this.resources, sqlPaneAPI.getSQLEntryPanel(), this);
        JMenuItem item = sqlPaneAPI.addToSQLEntryAreaMenu((Action)((Object)cba));
        this.resources.configureMenuItem((Action)((Object)cba), item);
        JTextComponent comp = sqlPaneAPI.getSQLEntryPanel().getTextComponent();
        comp.registerKeyboardAction((ActionListener)((Object)cba), this.resources.getKeyStroke((Action)((Object)cba)), 1);
        session.getSessionInternalFrame().addToToolsPopUp("bookmarkselect", (Action)((Object)cba));
    }

    protected void rebuildMenu() {
        ActionCollection coll = this.getApplication().getActionCollection();
        this.menu.removeAll();
        this.resources.addToMenu(coll.get(AddBookmarkAction.class), this.menu);
        this.menu.add(new JSeparator());
        Iterator<Bookmark> i = this.bookmarkManager.iterator();
        while (i.hasNext()) {
            Bookmark o;
            Bookmark bookmark = o = i.next();
            this.addBookmarkItem(bookmark);
        }
        String defaultMarksInPopup = this.getBookmarkProperties().getProperty(BOOKMARK_PROP_DEFAULT_MARKS_IN_POPUP, "false");
        if (Boolean.valueOf(defaultMarksInPopup).booleanValue()) {
            Bookmark[] defaultBookmarks = DefaultBookmarksFactory.getDefaultBookmarks();
            for (int i2 = 0; i2 < defaultBookmarks.length; ++i2) {
                this.addBookmarkItem(defaultBookmarks[i2]);
            }
        }
    }

    private void createMenu() {
        IApplication app = this.getApplication();
        this.menu = this.resources.createMenu("bookmarks");
        app.addToMenu(2, this.menu);
    }

    protected void addBookmarkItem(Bookmark bookmark) {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        SquirrelAction action = (SquirrelAction)coll.get(RunBookmarkAction.class);
        JMenuItem item = new JMenuItem((Action)action);
        item.setText(bookmark.getName());
        this.menu.add(item);
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        return new IGlobalPreferencesPanel[]{new SQLBookmarkPreferencesController(this)};
    }

    public void addSQLPanelAPIListeningForBookmarks(ISQLPanelAPI sqlApi) {
        if (!this._sqlPanelAPIsListeningForBookmarks.contains(sqlApi)) {
            this._sqlPanelAPIsListeningForBookmarks.add(sqlApi);
        }
    }

    public void removeSQLPanelAPIListeningForBookmarks(ISQLPanelAPI sqlApi) {
        this._sqlPanelAPIsListeningForBookmarks.remove(sqlApi);
    }

    public void removeALLSQLPanelsAPIListeningForBookmarks() {
        this._sqlPanelAPIsListeningForBookmarks = new ArrayList();
    }

    public ISQLPanelAPI[] getSQLPanelAPIsListeningForBookmarks() {
        return this._sqlPanelAPIsListeningForBookmarks.toArray(new ISQLPanelAPI[this._sqlPanelAPIsListeningForBookmarks.size()]);
    }

    Properties getBookmarkProperties() {
        FileInputStream fis = null;
        try {
            Serializable usf;
            if (null == this._boomarkProps) {
                usf = this.getPluginUserSettingsFolder();
                File boomarkPropsFile = new File((File)usf, BOOKMARKS_PROPS_FILE);
                if (!boomarkPropsFile.exists()) {
                    this._boomarkProps = new Properties();
                } else {
                    fis = new FileInputStream(boomarkPropsFile);
                    this._boomarkProps = new Properties();
                    this._boomarkProps.load(fis);
                }
            }
            usf = this._boomarkProps;
            return usf;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    s_log.error((Object)("Unable to close output stream: " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    void saveBookmarkProperties() {
        FileOutputStream fos = null;
        try {
            if (null == this._boomarkProps) {
                return;
            }
            File usf = this.getPluginUserSettingsFolder();
            File boomarkPropsFile = new File(usf, BOOKMARKS_PROPS_FILE);
            fos = new FileOutputStream(boomarkPropsFile);
            this._boomarkProps.store(fos, "Bookmark properties");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    s_log.error((Object)("Unable to close output stream: " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    private static interface IMenuResourceKeys {
        public static final String BOOKMARKS = "bookmarks";
    }
}

