/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BookmarEditController;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.Bookmark;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BookmarkManager;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.DefaultBookmarksFactory;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.RunBookmarkCommand;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkPreferencesPanel;

public class SQLBookmarkPreferencesController
implements IGlobalPreferencesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLBookmarkPreferencesController.class);
    protected SQLBookmarkPreferencesPanel _pnlPrefs;
    protected IApplication _app;
    protected SQLBookmarkPlugin _plugin;
    private DefaultMutableTreeNode _nodeSquirrelMarks;
    private DefaultMutableTreeNode _nodeUserMarks;

    public SQLBookmarkPreferencesController(SQLBookmarkPlugin plugin) {
        this._plugin = plugin;
    }

    public void initialize(IApplication app) {
        this._app = app;
        this._pnlPrefs.btnEdit.setText(s_stringMgr.getString("sqlbookmark.btnTextEdit"));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        this._nodeSquirrelMarks = new DefaultMutableTreeNode(s_stringMgr.getString("sqlbookmark.nodeSquirrelMarks"));
        this._nodeUserMarks = new DefaultMutableTreeNode(s_stringMgr.getString("sqlbookmark.nodeUserMarks"));
        root.add(this._nodeUserMarks);
        root.add(this._nodeSquirrelMarks);
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        this._pnlPrefs.treBookmarks.setModel(dtm);
        this._pnlPrefs.treBookmarks.setRootVisible(false);
        this._pnlPrefs.treBookmarks.getSelectionModel().setSelectionMode(1);
        Bookmark[] defaultBookmarks = DefaultBookmarksFactory.getDefaultBookmarks();
        for (int i = 0; i < defaultBookmarks.length; ++i) {
            this._nodeSquirrelMarks.add(new DefaultMutableTreeNode(defaultBookmarks[i]));
        }
        Iterator<Bookmark> i = this._plugin.getBookmarkManager().iterator();
        while (i.hasNext()) {
            Bookmark mark = i.next();
            this._nodeUserMarks.add(new DefaultMutableTreeNode(mark));
        }
        this._pnlPrefs.treBookmarks.expandPath(new TreePath(dtm.getPathToRoot(this._nodeUserMarks)));
        String propDefaultMarksInPopup = this._plugin.getBookmarkProperties().getProperty("squirrelMarksInPopup", "false");
        this._pnlPrefs.chkSquirrelMarksInPopup.setSelected(Boolean.valueOf(propDefaultMarksInPopup));
        this._pnlPrefs.treBookmarks.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SQLBookmarkPreferencesController.this.onTreeSelectionChanged(e);
            }
        });
        this._pnlPrefs.btnRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLBookmarkPreferencesController.this.onRun();
            }
        });
        this._pnlPrefs.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLBookmarkPreferencesController.this.onAdd();
            }
        });
        this._pnlPrefs.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLBookmarkPreferencesController.this.onEdit();
            }
        });
        this._pnlPrefs.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLBookmarkPreferencesController.this.onDelete();
            }
        });
        this._pnlPrefs.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLBookmarkPreferencesController.this.onUp();
            }
        });
        this._pnlPrefs.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLBookmarkPreferencesController.this.onDown();
            }
        });
    }

    public void uninitialize(IApplication app) {
        this._plugin.removeALLSQLPanelsAPIListeningForBookmarks();
    }

    public String getTitle() {
        return this._plugin.getResourceString("prefs.title");
    }

    public String getHint() {
        return this._plugin.getResourceString("prefs.hint");
    }

    public void applyChanges() {
        BookmarkManager bookmarks = this._plugin.getBookmarkManager();
        bookmarks.removeAll();
        for (int i = 0; i < this._nodeUserMarks.getChildCount(); ++i) {
            Bookmark bookmark = (Bookmark)((DefaultMutableTreeNode)this._nodeUserMarks.getChildAt(i)).getUserObject();
            bookmarks.add(bookmark);
        }
        this._plugin.rebuildMenu();
        bookmarks.save();
        this._plugin.getBookmarkProperties().put("squirrelMarksInPopup", "" + this._pnlPrefs.chkSquirrelMarksInPopup.isSelected());
        this._plugin.saveBookmarkProperties();
    }

    public Component getPanelComponent() {
        this._pnlPrefs = new SQLBookmarkPreferencesPanel(this._plugin);
        return this._pnlPrefs;
    }

    private void onTreeSelectionChanged(TreeSelectionEvent e) {
        if (null == e.getPath()) {
            return;
        }
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        if (!(dmtn.getUserObject() instanceof Bookmark)) {
            return;
        }
        if (dmtn.getParent() == this._nodeSquirrelMarks) {
            this._pnlPrefs.btnUp.setEnabled(false);
            this._pnlPrefs.btnDown.setEnabled(false);
            this._pnlPrefs.btnDel.setEnabled(false);
            this._pnlPrefs.btnEdit.setText(s_stringMgr.getString("sqlbookmark.btnTextView"));
        } else {
            this._pnlPrefs.btnUp.setEnabled(true);
            this._pnlPrefs.btnDown.setEnabled(true);
            this._pnlPrefs.btnDel.setEnabled(true);
            this._pnlPrefs.btnEdit.setText(s_stringMgr.getString("sqlbookmark.btnTextEdit"));
        }
    }

    private void onRun() {
        DefaultMutableTreeNode selNode = null;
        if (null != this._pnlPrefs.treBookmarks.getSelectionPath()) {
            selNode = (DefaultMutableTreeNode)this._pnlPrefs.treBookmarks.getSelectionPath().getLastPathComponent();
        }
        if (null == selNode || !(selNode.getUserObject() instanceof Bookmark)) {
            this._app.getMessageHandler().showErrorMessage(s_stringMgr.getString("sqlbookmark.noRunSelection"));
            return;
        }
        ISQLPanelAPI[] apis = this._plugin.getSQLPanelAPIsListeningForBookmarks();
        if (0 == apis.length) {
            JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), s_stringMgr.getString("sqlbookmark.noSQLPanel"));
            return;
        }
        Bookmark bm = (Bookmark)selNode.getUserObject();
        for (int i = 0; i < apis.length; ++i) {
            ISQLPanelAPI api = apis[i];
            new RunBookmarkCommand((Frame)this._app.getMainFrame(), api.getSession(), bm, this._plugin, api.getSQLEntryPanel()).execute();
        }
    }

    public void onAdd() {
        BookmarEditController ctrlr = new BookmarEditController((Frame)this._app.getMainFrame(), null, true);
        if (ctrlr.isCancelled()) {
            return;
        }
        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(ctrlr.getBookmark());
        this._nodeUserMarks.add(newChild);
        ((DefaultTreeModel)this._pnlPrefs.treBookmarks.getModel()).nodeStructureChanged(this._nodeUserMarks);
        this.selectNode(newChild);
    }

    private void selectNode(DefaultMutableTreeNode toSel) {
        Object[] pathToRoot = ((DefaultTreeModel)this._pnlPrefs.treBookmarks.getModel()).getPathToRoot(toSel);
        this._pnlPrefs.treBookmarks.setSelectionPath(new TreePath(pathToRoot));
    }

    public void onEdit() {
        DefaultMutableTreeNode selNode = null;
        if (null != this._pnlPrefs.treBookmarks.getSelectionPath()) {
            selNode = (DefaultMutableTreeNode)this._pnlPrefs.treBookmarks.getSelectionPath().getLastPathComponent();
        }
        if (null == selNode || !(selNode.getUserObject() instanceof Bookmark)) {
            this._app.getMessageHandler().showErrorMessage(s_stringMgr.getString("sqlbookmark.noEditSelection"));
            return;
        }
        boolean editable = selNode.getParent() == this._nodeUserMarks;
        BookmarEditController ctrlr = new BookmarEditController((Frame)this._app.getMainFrame(), (Bookmark)selNode.getUserObject(), editable);
        if (ctrlr.isCancelled()) {
            return;
        }
        selNode.setUserObject(ctrlr.getBookmark());
    }

    public void onDelete() {
        DefaultMutableTreeNode selNode = null;
        if (null != this._pnlPrefs.treBookmarks.getSelectionPath()) {
            selNode = (DefaultMutableTreeNode)this._pnlPrefs.treBookmarks.getSelectionPath().getLastPathComponent();
        }
        if (null == selNode || !(selNode.getUserObject() instanceof Bookmark)) {
            this._app.getMessageHandler().showErrorMessage(s_stringMgr.getString("sqlbookmark.noDeleteSelection"));
            return;
        }
        int ret = JOptionPane.showConfirmDialog((Component)this._app.getMainFrame(), s_stringMgr.getString("sqlbookmark.deleteConfirm"));
        if (0 != ret) {
            return;
        }
        DefaultMutableTreeNode nextSel = selNode.getNextSibling();
        if (null == nextSel) {
            nextSel = selNode.getPreviousSibling();
        }
        this._nodeUserMarks.remove(selNode);
        ((DefaultTreeModel)this._pnlPrefs.treBookmarks.getModel()).nodeStructureChanged(this._nodeUserMarks);
        this.selectNode(nextSel);
    }

    private void onUp() {
        DefaultMutableTreeNode selNode = null;
        if (null != this._pnlPrefs.treBookmarks.getSelectionPath()) {
            selNode = (DefaultMutableTreeNode)this._pnlPrefs.treBookmarks.getSelectionPath().getLastPathComponent();
        }
        if (null == selNode || !(selNode.getUserObject() instanceof Bookmark) || 0 == this._nodeUserMarks.getIndex(selNode)) {
            return;
        }
        int selIx = this._nodeUserMarks.getIndex(selNode);
        this._nodeUserMarks.insert(selNode, selIx - 1);
        ((DefaultTreeModel)this._pnlPrefs.treBookmarks.getModel()).nodeStructureChanged(this._nodeUserMarks);
        this.selectNode(selNode);
    }

    private void onDown() {
        DefaultMutableTreeNode selNode = null;
        if (null != this._pnlPrefs.treBookmarks.getSelectionPath()) {
            selNode = (DefaultMutableTreeNode)this._pnlPrefs.treBookmarks.getSelectionPath().getLastPathComponent();
        }
        if (null == selNode || !(selNode.getUserObject() instanceof Bookmark) || this._nodeUserMarks.getChildCount() - 1 == this._nodeUserMarks.getIndex(selNode)) {
            return;
        }
        int selIx = this._nodeUserMarks.getIndex(selNode);
        this._nodeUserMarks.insert(selNode, selIx + 1);
        ((DefaultTreeModel)this._pnlPrefs.treBookmarks.getModel()).nodeStructureChanged(this._nodeUserMarks);
        this.selectNode(selNode);
    }
}

