/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlval.AppPreferencesPanel;
import net.sourceforge.squirrel_sql.plugins.sqlval.SessionSettingsPanel;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServicePreferences;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSessionProperties;
import net.sourceforge.squirrel_sql.plugins.sqlval.cmd.ConnectCommand;
import net.sourceforge.squirrel_sql.plugins.sqlval.cmd.DisconnectCommand;

public class LogonDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(LogonDialog.class);
    private static final ILogger s_log = LoggerController.createLogger(LogonDialog.class);
    private final ISession _session;
    private final WebServicePreferences _prefs;
    private final WebServiceSessionProperties _sessionProps;
    private AppPreferencesPanel _appPrefsPnl;
    private SessionSettingsPanel _confirmPnl;

    public LogonDialog(ISession session, WebServicePreferences prefs, WebServiceSessionProperties sessionProps) {
        super((Frame)session.getApplication().getMainFrame(), s_stringMgr.getString("sqlval.logon"), true);
        if (session == null) {
            throw new IllegalArgumentException("ISession = null");
        }
        if (prefs == null) {
            throw new IllegalArgumentException("WebServicePreferences = null");
        }
        if (sessionProps == null) {
            throw new IllegalArgumentException("WebServiceSessionProperties = null");
        }
        this._session = session;
        this._prefs = prefs;
        this._sessionProps = sessionProps;
        this.createGUI();
        try {
            new DisconnectCommand(this._session, this._prefs, this._sessionProps).execute();
        }
        catch (BaseException ex) {
            s_log.error((Object)ex);
        }
    }

    private void performClose() {
        this.dispose();
    }

    private void performOk() {
        this._appPrefsPnl.save();
        this._confirmPnl.save();
        ConnectCommand cmd = new ConnectCommand(this._session, this._prefs, this._sessionProps);
        try {
            cmd.execute();
            this.dispose();
        }
        catch (Throwable th) {
            String msg = "Error occured when talking to the web service";
            s_log.error((Object)"Error occured when talking to the web service", th);
            this._session.getApplication().showErrorDialog("Error occured when talking to the web service", th);
        }
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder());
        this.setContentPane(contentPane);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(1, 4, 1, 4);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this._appPrefsPnl = new AppPreferencesPanel(this._prefs);
        contentPane.add((Component)this._appPrefsPnl, gbc);
        gbc.weighty = 0.0;
        ++gbc.gridy;
        this._confirmPnl = new SessionSettingsPanel(this._prefs, this._sessionProps);
        contentPane.add((Component)this._confirmPnl, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.createButtonsPanel(), gbc);
        this.pack();
        GUIUtils.centerWithinParent((Window)this);
        this.setResizable(true);
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("sqlval.logonOk"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogonDialog.this.performOk();
            }
        });
        JButton closeBtn = new JButton(s_stringMgr.getString("sqlval.logonClose"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogonDialog.this.performClose();
            }
        });
        GUIUtils.setJButtonSizesTheSame((JButton[])new JButton[]{okBtn, closeBtn});
        pnl.add(okBtn);
        pnl.add(closeBtn);
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }
}

