/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JMenu;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallbackAdaptor;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISQLPanelListener;
import net.sourceforge.squirrel_sql.client.session.event.SQLPanelAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SQLPanelEvent;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.sqlval.ValidatorGlobalPreferencesTab;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServicePreferences;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSession;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSessionProperties;
import net.sourceforge.squirrel_sql.plugins.sqlval.action.ConnectAction;
import net.sourceforge.squirrel_sql.plugins.sqlval.action.DisconnectAction;
import net.sourceforge.squirrel_sql.plugins.sqlval.action.ValidateSQLAction;

public class SQLValidatorPlugin
extends DefaultSessionPlugin {
    private static final ILogger s_log = LoggerController.createLogger(SQLValidatorPlugin.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLValidatorPlugin.class);
    private static final String USER_PREFS_FILE_NAME = "prefs.xml";
    private static final String PREFS_KEY = "sessionprefs";
    private WebServicePreferences _prefs;
    private FileWrapper _userSettingsFolder;
    private IResources _resources;
    private IPluginResourcesFactory _resourcesFactory = new PluginResourcesFactory();
    private ISQLPanelListener _lis = new SQLPanelListener();

    public void setResourcesFactory(IPluginResourcesFactory resourcesFactory) {
        this._resourcesFactory = resourcesFactory;
    }

    public String getInternalName() {
        return "sqlval";
    }

    public String getDescriptiveName() {
        return s_stringMgr.getString("sqlval.descriptivename");
    }

    public String getVersion() {
        return "0.13";
    }

    public String getAuthor() {
        return "Colin Bell";
    }

    public String getContributors() {
        return "Olof Edlund";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        this._resources = this._resourcesFactory.createResource(((Object)((Object)this)).getClass().getName(), (IPlugin)this);
        try {
            this._userSettingsFolder = this.getPluginUserSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        this.loadPrefs();
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new ConnectAction(app, this._resources, this._prefs, this)));
        coll.add((Action)((Object)new DisconnectAction(app, this._resources, this._prefs, this)));
        coll.add((Action)((Object)new ValidateSQLAction(app, this._resources, this._prefs, this)));
        this.createMenu();
    }

    public void unload() {
        this.savePrefs();
        super.unload();
    }

    public void sessionCreated(final ISession session) {
        super.sessionCreated(session);
        final WebServiceSessionProperties props = new WebServiceSessionProperties(this._prefs);
        session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                props.setSQLConnection(session.getSQLConnection());
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        session.putPluginObject((IPlugin)SQLValidatorPlugin.this, SQLValidatorPlugin.PREFS_KEY, (Object)props);
                    }
                });
            }
        });
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        session.getSessionInternalFrame().getSQLPanelAPI().addSQLPanelListener(this._lis);
        this.setupSQLEntryArea(session);
        return new PluginSessionCallbackAdaptor((IPlugin)this);
    }

    public void sessionEnding(ISession session) {
        WebServiceSession wss;
        session.getSessionInternalFrame().getSQLPanelAPI().removeSQLPanelListener(this._lis);
        WebServiceSessionProperties wssp = this.getWebServiceSessionProperties(session);
        if (wssp != null && (wss = wssp.getWebServiceSession()) != null) {
            wss.close();
        }
        session.removePluginObject((IPlugin)this, PREFS_KEY);
        super.sessionEnding(session);
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        return new IGlobalPreferencesPanel[]{new ValidatorGlobalPreferencesTab(this._prefs)};
    }

    IResources getResources() {
        return this._resources;
    }

    public WebServiceSessionProperties getWebServiceSessionProperties(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        return (WebServiceSessionProperties)session.getPluginObject((IPlugin)this, PREFS_KEY);
    }

    private void setupSQLEntryArea(ISession session) {
        ISQLPanelAPI api = session.getSessionInternalFrame().getSQLPanelAPI();
        ActionCollection coll = this.getApplication().getActionCollection();
        api.addToSQLEntryAreaMenu(coll.get(ValidateSQLAction.class));
    }

    private void loadPrefs() {
        try {
            XMLBeanReader doc = new XMLBeanReader();
            doc.load(this.fileWrapperFactory.create(this._userSettingsFolder, USER_PREFS_FILE_NAME), ((Object)((Object)this)).getClass().getClassLoader());
            Iterator it = doc.iterator();
            if (it.hasNext()) {
                this._prefs = (WebServicePreferences)it.next();
            }
        }
        catch (FileNotFoundException ignore) {
            s_log.info((Object)"prefs.xml not found - will be created");
        }
        catch (Exception ex) {
            s_log.error((Object)"Error occured reading from preferences file: prefs.xml", (Throwable)ex);
        }
        if (this._prefs == null) {
            this._prefs = new WebServicePreferences();
        }
        this._prefs.setClientName(Version.getApplicationName() + "/" + this.getDescriptiveName());
        this._prefs.setClientVersion(Version.getShortVersion() + "/" + this.getVersion());
    }

    private void savePrefs() {
        try {
            XMLBeanWriter wtr = new XMLBeanWriter((Object)this._prefs);
            wtr.save(this.fileWrapperFactory.create(this._userSettingsFolder, USER_PREFS_FILE_NAME));
        }
        catch (Exception ex) {
            s_log.error((Object)"Error occured writing to preferences file: prefs.xml", (Throwable)ex);
        }
    }

    private void createMenu() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu menu = this._resources.createMenu("sqlval");
        this._resources.addToMenu(coll.get(ConnectAction.class), menu);
        this._resources.addToMenu(coll.get(DisconnectAction.class), menu);
        this._resources.addToMenu(coll.get(ValidateSQLAction.class), menu);
        app.addToMenu(2, menu);
    }

    private class SQLPanelListener
    extends SQLPanelAdapter {
        private SQLPanelListener() {
        }

        public void sqlEntryAreaReplaced(SQLPanelEvent evt) {
            SQLValidatorPlugin.this.setupSQLEntryArea(evt.getSession());
        }
    }

    private static interface IMenuResourceKeys {
        public static final String SQLVAL = "sqlval";
    }
}

