/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPluginResources;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.NetbeansSQLEntryPanel;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.RSyntaxSQLEntryPanel;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;

public class ReplaceAction
extends SquirrelAction
implements ISQLPanelAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ReplaceAction.class);
    private ISession _session;
    private ISQLEntryPanel _isqlEntryPanel;

    public ReplaceAction(IApplication app, SyntaxPluginResources rsrc) throws IllegalArgumentException {
        super(app, (Resources)rsrc);
    }

    public ReplaceAction(IApplication app, SyntaxPluginResources rsrc, ISQLEntryPanel isqlEntryPanel) {
        this(app, rsrc);
        this._isqlEntryPanel = isqlEntryPanel;
    }

    public void actionPerformed(ActionEvent evt) {
        if (null != this._isqlEntryPanel) {
            this.doActionPerformed(this._isqlEntryPanel, evt);
        }
        if (null != this._session) {
            ISQLEntryPanel sqlEntryPanel = this._session.getSQLPanelAPIOfActiveSessionWindow().getSQLEntryPanel();
            this.doActionPerformed(sqlEntryPanel, evt);
        }
    }

    private void doActionPerformed(ISQLEntryPanel sqlEntryPanel, ActionEvent evt) {
        if (sqlEntryPanel instanceof NetbeansSQLEntryPanel) {
            NetbeansSQLEntryPanel nsep = (NetbeansSQLEntryPanel)sqlEntryPanel;
            nsep.showReplaceDialog(evt);
        } else if (sqlEntryPanel instanceof RSyntaxSQLEntryPanel) {
            SquirrelRSyntaxTextArea rsep = (SquirrelRSyntaxTextArea)((Object)sqlEntryPanel.getTextComponent());
            rsep.showReplaceDialog(evt);
        } else {
            String msg = s_stringMgr.getString("syntax.replaceOnlyOnRecommendedEditors");
            JOptionPane.showMessageDialog((Component)this._session.getApplication().getMainFrame(), msg);
        }
    }

    public void setSQLPanel(ISQLPanelAPI panel) {
        this._session = null != panel ? panel.getSession() : null;
        this.setEnabled(null != this._session);
    }
}

