/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.util.HashMap;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanelFactory;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.AutoCorrector;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.ToolsPopupHandler;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.NetbeansSQLEntryAreaFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.oster.OsterSQLEntryAreaFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.RSyntaxSQLEntryAreaFactory;

public class SQLEntryPanelFactoryProxy
implements ISQLEntryPanelFactory {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLEntryPanelFactoryProxy.class);
    private NetbeansSQLEntryAreaFactory _netbeansFactory;
    private OsterSQLEntryAreaFactory _osterFactory;
    private SyntaxPlugin _syntaxPugin;
    private ISQLEntryPanelFactory _originalFactory;
    private RSyntaxSQLEntryAreaFactory _rsyntaxFactory;

    SQLEntryPanelFactoryProxy(SyntaxPlugin syntaxPugin, ISQLEntryPanelFactory originalFactory) {
        this._originalFactory = originalFactory;
        this._rsyntaxFactory = new RSyntaxSQLEntryAreaFactory(syntaxPugin);
        this._netbeansFactory = new NetbeansSQLEntryAreaFactory(syntaxPugin);
        this._osterFactory = new OsterSQLEntryAreaFactory(syntaxPugin);
        this._syntaxPugin = syntaxPugin;
    }

    public void sessionEnding(ISession session) {
        this._netbeansFactory.sessionEnding(session);
        this._rsyntaxFactory.sessionEnding(session);
    }

    public ISQLEntryPanel createSQLEntryPanel(final ISession session, HashMap<String, Object> props) {
        ISQLEntryPanel newPnl;
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        SyntaxPreferences prefs = this.getPreferences(session);
        ISQLEntryPanel pnl = this.getPanel(session);
        if (prefs.getUseRSyntaxTextArea()) {
            newPnl = this._rsyntaxFactory.createSQLEntryPanel(session, props);
        } else if (prefs.getUseNetbeansTextControl()) {
            newPnl = this._netbeansFactory.createSQLEntryPanel(session, props);
        } else if (prefs.getUseOsterTextControl()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    session.showMessage(s_stringMgr.getString("syntax.osterWarning"));
                }
            });
            newPnl = this._osterFactory.createSQLEntryPanel(session);
        } else {
            newPnl = this._originalFactory.createSQLEntryPanel(session, props);
        }
        new ToolsPopupHandler(this._syntaxPugin).initToolsPopup(props, newPnl);
        new AutoCorrector(newPnl.getTextComponent(), this._syntaxPugin);
        if (null == pnl || !newPnl.getClass().equals(pnl.getClass())) {
            this.removePanel(session);
            this.savePanel(session, newPnl);
        }
        return newPnl;
    }

    private SyntaxPreferences getPreferences(ISession session) {
        return (SyntaxPreferences)session.getPluginObject((IPlugin)this._syntaxPugin, "prefs");
    }

    private void removePanel(ISession session) {
        session.removePluginObject((IPlugin)this._syntaxPugin, "sqlentry");
    }

    private ISQLEntryPanel getPanel(ISession session) {
        return (ISQLEntryPanel)session.getPluginObject((IPlugin)this._syntaxPugin, "sqlentry");
    }

    private void savePanel(ISession session, ISQLEntryPanel pnl) {
        session.putPluginObject((IPlugin)this._syntaxPugin, "sqlentry", (Object)pnl);
    }
}

