/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.netbeans;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.undo.UndoManager;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.client.session.parser.IParserEventsProcessor;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsAdapter;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ErrorInfo;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.plugins.syntax.KeyManager;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.NetbeansPropertiesWrapper;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.SQLKit;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.SQLSettingsInitializer;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.SyntaxFactory;
import org.netbeans.editor.BaseSettingsInitializer;
import org.netbeans.editor.Settings;

public class NetbeansSQLEditorPane
extends JEditorPane {
    private static final long serialVersionUID = -7433339152923153176L;
    private boolean _parsingInitialized;
    private ISession _session;
    private ErrorInfo[] _currentErrorInfos = new ErrorInfo[0];
    private SyntaxPreferences _prefs;
    private SyntaxFactory _syntaxFactory;
    private SyntaxPlugin _plugin;
    private IIdentifier _sqlEntryPanelIdentifier;
    private SessionAdapter _sessionListener;
    private NetbeansPropertiesWrapper _propertiesWrapper;

    public NetbeansSQLEditorPane(ISession session, SyntaxPreferences prefs, SyntaxFactory syntaxFactory, SyntaxPlugin plugin, IIdentifier sqlEntryPanelIdentifier, NetbeansPropertiesWrapper propertiesWrapper) {
        this._session = session;
        this._prefs = prefs;
        this._syntaxFactory = syntaxFactory;
        this._plugin = plugin;
        this._sqlEntryPanelIdentifier = sqlEntryPanelIdentifier;
        this._propertiesWrapper = propertiesWrapper;
        this._syntaxFactory.putEditorPane(this._session, this);
        Settings.removeInitializer((String)"base-settings-initializer");
        Settings.addInitializer((Settings.Initializer)new BaseSettingsInitializer(), (int)0);
        Settings.removeInitializer((String)"sql-settings-initializer");
        Font font = this._session.getProperties().getFontInfo().createFont();
        Settings.addInitializer((Settings.Initializer)new SQLSettingsInitializer(SQLKit.class, this._prefs, font, this._plugin));
        this.setEditorKit((EditorKit)((Object)new SQLKit(syntaxFactory)));
        this.modifyKeyStrokes();
        Document doc = this.getDocument();
        this._syntaxFactory.putDocument(this._session, this._propertiesWrapper, doc);
        this._sessionListener = new SessionAdapter(){

            public void sessionClosed(SessionEvent evt) {
                NetbeansSQLEditorPane.this.dispose(evt);
            }
        };
        this._session.getApplication().getSessionManager().addSessionListener((ISessionListener)this._sessionListener);
        this.setToolTipText("Just to make getToolTiptext() to be called");
        new KeyManager(this);
    }

    private void modifyKeyStrokes() {
        KeyStroke ctrlEnterStroke = KeyStroke.getKeyStroke(10, 2);
        this.getKeymap().removeKeyStrokeBinding(ctrlEnterStroke);
        KeyStroke ctrlJStroke = KeyStroke.getKeyStroke(74, 2);
        this.getKeymap().removeKeyStrokeBinding(ctrlJStroke);
        KeyStroke ctrlTStroke = KeyStroke.getKeyStroke(84, 2);
        this.getKeymap().removeKeyStrokeBinding(ctrlTStroke);
        KeyStroke ctrlShiftFStroke = KeyStroke.getKeyStroke(70, 3);
        this.getKeymap().removeKeyStrokeBinding(ctrlShiftFStroke);
        KeyStroke ctrlDStroke = KeyStroke.getKeyStroke(68, 2);
        this.getKeymap().removeKeyStrokeBinding(ctrlDStroke);
        KeyStroke ctrlSubstractStroke = KeyStroke.getKeyStroke(109, 2);
        this.getKeymap().removeKeyStrokeBinding(ctrlSubstractStroke);
        KeyStroke ctrlShiftSubstractStroke = KeyStroke.getKeyStroke(109, 3);
        this.getKeymap().removeKeyStrokeBinding(ctrlShiftSubstractStroke);
        KeyStroke ctrlShiftXStroke = KeyStroke.getKeyStroke(88, 3);
        this.getKeymap().removeKeyStrokeBinding(ctrlShiftXStroke);
        KeyStroke ctrlShiftCStroke = KeyStroke.getKeyStroke(67, 3);
        this.getKeymap().removeKeyStrokeBinding(ctrlShiftCStroke);
        KeyStroke ctrlF3Stroke = KeyStroke.getKeyStroke(114, 2);
        this.getKeymap().removeKeyStrokeBinding(ctrlF3Stroke);
        KeyStroke ks = KeyStroke.getKeyStroke(155, 1);
        final Action origAction = this.getKeymap().getAction(ks);
        AbstractAction triggerParserAction = new AbstractAction(){
            private static final long serialVersionUID = 1158324060321498929L;

            @Override
            public void actionPerformed(ActionEvent e) {
                origAction.actionPerformed(e);
                if (NetbeansSQLEditorPane.this._session.getActiveSessionWindow().hasSQLPanelAPI()) {
                    IIdentifier entryPanelId = NetbeansSQLEditorPane.this._session.getSQLPanelAPIOfActiveSessionWindow().getSQLEntryPanel().getIdentifier();
                    NetbeansSQLEditorPane.this.triggerParser(entryPanelId);
                }
            }
        };
        this.getKeymap().addActionForKeyStroke(ks, triggerParserAction);
    }

    private void triggerParser(IIdentifier entryPanelId) {
        IParserEventsProcessor parserEventsProcessor = this._propertiesWrapper.getParserEventsProcessor(entryPanelId, this._session);
        if (null != parserEventsProcessor) {
            parserEventsProcessor.triggerParser();
        }
    }

    public void updateFromPreferences() {
        Settings.removeInitializer((String)"base-settings-initializer");
        Settings.addInitializer((Settings.Initializer)new BaseSettingsInitializer(), (int)0);
        Settings.removeInitializer((String)"sql-settings-initializer");
        Font font = this._session.getProperties().getFontInfo().createFont();
        Settings.addInitializer((Settings.Initializer)new SQLSettingsInitializer(SQLKit.class, this._prefs, font, this._plugin));
        this.modifyKeyStrokes();
        Document doc = this.getDocument();
        this._syntaxFactory.putDocument(this._session, this._propertiesWrapper, doc);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int pos = this.viewToModel(event.getPoint());
        this.initParsing();
        for (int i = 0; i < this._currentErrorInfos.length; ++i) {
            if (this._currentErrorInfos[i].beginPos - 1 > pos || pos > this._currentErrorInfos[i].endPos) continue;
            return this._currentErrorInfos[i].message;
        }
        return null;
    }

    private void initParsing() {
        if (!this._parsingInitialized && null != this._propertiesWrapper.getParserEventsProcessor(this._sqlEntryPanelIdentifier, this._session)) {
            this._parsingInitialized = true;
            this._propertiesWrapper.getParserEventsProcessor(this._sqlEntryPanelIdentifier, this._session).addParserEventsListener((ParserEventsListener)new ParserEventsAdapter(){

                public void errorsFound(ErrorInfo[] errorInfos) {
                    NetbeansSQLEditorPane.this.onErrorsFound(errorInfos);
                }
            });
        }
    }

    private void onErrorsFound(ErrorInfo[] errorInfos) {
        this._currentErrorInfos = errorInfos;
    }

    @Override
    public String getText() {
        return super.getText().replaceAll("\r\n", "\n");
    }

    public void addUndoableEditListener(UndoableEditListener um) {
        this.getDocument().addUndoableEditListener(um);
    }

    public void setUndoManager(UndoManager manager) {
        this.getDocument().addUndoableEditListener(manager);
        this.getDocument().putProperty("undo-manager", manager);
    }

    public IIdentifier getSqlEntryPanelIdentifier() {
        return this._sqlEntryPanelIdentifier;
    }

    private void dispose(SessionEvent evt) {
        if (evt.getSession().getIdentifier().equals(this._session.getIdentifier())) {
            Settings.removeInitializer((String)"sql-settings-initializer");
            this._session.getApplication().getSessionManager().removeSessionListener((ISessionListener)this._sessionListener);
            this._session = null;
        }
    }
}

