/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.netbeans;

import java.util.HashMap;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.NetbeansSQLEntryPanel;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.SquirrelNBDialogFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.SyntaxFactory;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.modules.editor.NbImplementationProvider;

public class NetbeansSQLEntryAreaFactory {
    private SyntaxPlugin _plugin;
    private SyntaxFactory _syntaxFactory;
    private HashMap<IIdentifier, NetbeansSQLEntryPanel> _panels = new HashMap();

    public NetbeansSQLEntryAreaFactory(SyntaxPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null NetbeansPlugin passed");
        }
        this._plugin = plugin;
        this._syntaxFactory = new SyntaxFactory();
        DialogSupport.setDialogFactory((DialogSupport.DialogFactory)new SquirrelNBDialogFactory(this._plugin));
        ImplementationProvider.registerDefault((ImplementationProvider)new NbImplementationProvider());
    }

    public ISQLEntryPanel createSQLEntryPanel(ISession session, HashMap<String, Object> props) throws IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        SyntaxPreferences prefs = this.getPreferences(session);
        NetbeansSQLEntryPanel panel = new NetbeansSQLEntryPanel(session, prefs, this._syntaxFactory, this._plugin, props);
        this._panels.put(session.getIdentifier(), panel);
        return panel;
    }

    private SyntaxPreferences getPreferences(ISession session) {
        return (SyntaxPreferences)session.getPluginObject((IPlugin)this._plugin, "prefs");
    }

    public void sessionEnding(ISession sess) {
        this._syntaxFactory.sessionEnding(sess);
        IIdentifier id = sess.getIdentifier();
        if (id != null && this._panels.containsKey(id)) {
            NetbeansSQLEntryPanel panel = this._panels.get(id);
            if (panel != null) {
                panel.sessionEnding();
            }
            this._panels.remove(id);
        }
    }
}

