/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.netbeans;

import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.dnd.FileEditorDropTargetListener;
import net.sourceforge.squirrel_sql.client.session.BaseSQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.client.session.parser.IParserEventsProcessor;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.NetbeansPropertiesWrapper;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.NetbeansSQLEditorPane;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.SQLKit;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.SyntaxFactory;

public class NetbeansSQLEntryPanel
extends BaseSQLEntryPanel {
    private static final ILogger s_log = LoggerController.createLogger(NetbeansSQLEntryPanel.class);
    private IApplication _app;
    private NetbeansSQLEditorPane _textArea;
    private SyntaxFactory _syntaxFactory;
    private ISession _session;
    private SyntaxPlugin _plugin;
    private NetbeansPropertiesWrapper _propertiesWrapper;
    private DropTarget dt;

    NetbeansSQLEntryPanel(ISession session, SyntaxPreferences prefs, SyntaxFactory syntaxFactory, SyntaxPlugin plugin, HashMap<String, Object> props) {
        super(session.getApplication());
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this._propertiesWrapper = new NetbeansPropertiesWrapper(props);
        this._plugin = plugin;
        this._syntaxFactory = syntaxFactory;
        this._session = session;
        this._plugin = plugin;
        this._app = session.getApplication();
        this._textArea = new NetbeansSQLEditorPane(session, prefs, syntaxFactory, this._plugin, this.getIdentifier(), this._propertiesWrapper);
        this.dt = new DropTarget(this._textArea, (DropTargetListener)new FileEditorDropTargetListener(session));
    }

    public int getCaretLineNumber() {
        int pos = this.getCaretPosition();
        Document doc = this._textArea.getDocument();
        Element docElem = doc.getDefaultRootElement();
        return docElem.getElementIndex(pos);
    }

    public JTextComponent getTextComponent() {
        return this._textArea;
    }

    public boolean getDoesTextComponentHaveScroller() {
        return false;
    }

    public String getText() {
        return this._textArea.getText();
    }

    public void setFont(Font font) {
    }

    public String getSelectedText() {
        return this._textArea.getSelectedText();
    }

    public void setText(String text) {
        this.setText(text, true);
        this.triggerParser();
    }

    public void setText(String text, boolean select) {
        this._textArea.setText(text);
        if (select) {
            this.setSelectionEnd(this._textArea.getDocument().getLength());
            this.setSelectionStart(0);
        }
        this.triggerParser();
    }

    public void appendText(String sqlScript) {
        this.appendText(sqlScript, false);
    }

    public void appendText(String sqlScript, boolean select) {
        Document doc = this._textArea.getDocument();
        try {
            int start = 0;
            if (select) {
                start = doc.getLength();
            }
            doc.insertString(doc.getLength(), sqlScript, null);
            if (select) {
                this.setSelectionEnd(doc.getLength());
                this.setSelectionStart(start);
            }
            this.triggerParser();
        }
        catch (Exception ex) {
            s_log.error((Object)"Error appending text to text area", (Throwable)ex);
        }
    }

    public int getCaretPosition() {
        return this._textArea.getCaretPosition();
    }

    public void setCaretPosition(int value) {
        this._textArea.setCaretPosition(value);
    }

    public void setTabSize(int tabSize) {
        this._textArea.getDocument().putProperty("tabSize", tabSize);
    }

    public int getSelectionStart() {
        return this._textArea.getSelectionStart();
    }

    public void setSelectionStart(int pos) {
        this._textArea.setSelectionStart(pos);
    }

    public int getSelectionEnd() {
        return this._textArea.getSelectionEnd();
    }

    public void setSelectionEnd(int pos) {
        this._textArea.setSelectionEnd(pos);
    }

    public void replaceSelection(String sqlScript) {
        this._textArea.replaceSelection(sqlScript);
        this.triggerParser();
    }

    private void triggerParser() {
        IParserEventsProcessor parserEventsProcessor = this._propertiesWrapper.getParserEventsProcessor(this.getIdentifier(), this._session);
        if (null != parserEventsProcessor) {
            parserEventsProcessor.triggerParser();
        }
    }

    public boolean hasFocus() {
        return this._textArea.hasFocus();
    }

    public void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetbeansSQLEntryPanel.this._textArea.requestFocus();
            }
        });
    }

    public void addMouseListener(MouseListener lis) {
        this._textArea.addMouseListener(lis);
    }

    public void removeMouseListener(MouseListener lis) {
        this._textArea.removeMouseListener(lis);
    }

    public void updateFromPreferences() {
        this._textArea.updateFromPreferences();
    }

    public boolean hasOwnUndoableManager() {
        return false;
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this._textArea.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this._textArea.getDocument().removeUndoableEditListener(listener);
    }

    public int getCaretLinePosition() {
        String textTillCarret = this.getText().substring(0, this.getCaretPosition());
        int lineFeedIndex = textTillCarret.lastIndexOf(10);
        if (-1 == lineFeedIndex) {
            return this.getCaretPosition();
        }
        return this.getCaretPosition() - lineFeedIndex - 1;
    }

    public void addCaretListener(CaretListener lis) {
        this._textArea.addCaretListener(lis);
    }

    public void removeCaretListener(CaretListener lis) {
        this._textArea.removeCaretListener(lis);
    }

    public void addSQLTokenListener(SQLTokenListener tl) {
        this._syntaxFactory.addSQLTokenListeners(this._session, tl);
    }

    public void removeSQLTokenListener(SQLTokenListener tl) {
        this._syntaxFactory.removeSQLTokenListeners(this._session, tl);
    }

    public ISession getSession() {
        return this._session;
    }

    public void showFindDialog(ActionEvent evt) {
        SQLKit kit = (SQLKit)((Object)this._textArea.getEditorKit());
        kit.getActionByName("find").actionPerformed(evt);
    }

    public void showReplaceDialog(ActionEvent evt) {
        SQLKit kit = (SQLKit)((Object)this._textArea.getEditorKit());
        kit.getActionByName("replace").actionPerformed(evt);
    }

    public void setUndoManager(UndoManager manager) {
        this._textArea.setUndoManager(manager);
    }

    public void sessionEnding() {
        this._session = null;
    }
}

