/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.netbeans;

import java.awt.Font;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.SQLSettingsDefaults;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.SQLTokenContext;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.java.JavaLayerTokenContext;
import org.netbeans.editor.ext.java.JavaSettingsDefaults;

public class SQLSettingsInitializer
extends Settings.AbstractInitializer {
    public static final String NAME = "sql-settings-initializer";
    private Class<?> sqlKitClass;
    private SyntaxPreferences _syntaxPreferences;
    private static int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private SyntaxPlugin _plugin;
    private Font _font;
    public static final MultiKeyBinding[] squirrelKeyBindings = new MultiKeyBinding[]{new MultiKeyBinding(KeyStroke.getKeyStroke(70, MENU_MASK), "find"), new MultiKeyBinding(KeyStroke.getKeyStroke(65488, 0), "find"), new MultiKeyBinding(KeyStroke.getKeyStroke(72, MENU_MASK), "replace"), new MultiKeyBinding(KeyStroke.getKeyStroke(71, 2), "goto"), new MultiKeyBinding(KeyStroke.getKeyStroke(27, 0), "escape"), new MultiKeyBinding(KeyStroke.getKeyStroke(85, 3), "to-upper-case"), new MultiKeyBinding(KeyStroke.getKeyStroke(76, 3), "to-lower-case"), new MultiKeyBinding(KeyStroke.getKeyStroke(118, 3), "toggle-highlight-search")};
    public static final String ACCELERATOR_STRING_TO_UPPER_CASE = "ctrl shift u";
    public static final String ACCELERATOR_STRING_TO_LOWER_CASE = "ctrl shift l";

    public SQLSettingsInitializer(Class<?> sqlKitClass, SyntaxPreferences syntaxPreferences, Font font, SyntaxPlugin plugin) {
        super(NAME);
        this.sqlKitClass = sqlKitClass;
        this._syntaxPreferences = syntaxPreferences;
        this._plugin = plugin;
        this._font = font;
    }

    public void updateSettingsMap(Class kitClass, Map map) {
        Map settingsMap = map;
        if (kitClass == BaseKit.class) {
            new SQLSettingsDefaults.SQLTokenColoringInitializer(this._syntaxPreferences, this._font).updateSettingsMap(kitClass, settingsMap);
            new SQLSettingsDefaults.SQLLayerTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
            SettingsUtil.updateListSetting((Map)settingsMap, (String)"key-bindings", (Object[])squirrelKeyBindings);
            settingsMap.put("find-highlight-search", Boolean.FALSE);
        }
        if (kitClass == this.sqlKitClass) {
            SettingsUtil.updateListSetting((Map)settingsMap, (String)"key-bindings", (Object[])JavaSettingsDefaults.getJavaKeyBindings());
            SettingsUtil.updateListSetting((Map)settingsMap, (String)"token-context-list", (Object[])new TokenContext[]{SQLTokenContext.context, JavaLayerTokenContext.context});
            SettingsUtil.updateListSetting((Map)settingsMap, (String)"coloring-name-list", (Object[])new String[]{"highlight-caret-row", "highlight-match-brace"});
            settingsMap.put("highlight-caret-row", ExtSettingsDefaults.defaultHighlightCaretRow);
            settingsMap.put("highlight-match-brace", ExtSettingsDefaults.defaultHighlightMatchBrace);
            SettingsUtil.setColoring((Map)settingsMap, (String)"highlight-caret-row", (Object)ExtSettingsDefaults.defaultHighlightCaretRowColoring);
            SettingsUtil.setColoring((Map)settingsMap, (String)"highlight-match-brace", (Object)ExtSettingsDefaults.defaultHighlightMatchBraceColoring);
            settingsMap.put("text-limit-line-visible", this._syntaxPreferences.isTextLimitLineVisible());
            settingsMap.put("line-number-visible", Boolean.TRUE);
            settingsMap.put("text-limit-width", this._syntaxPreferences.getTextLimitLineWidth());
            settingsMap.put("abbrev-map", SQLSettingsDefaults.getAbbrevMap(this._plugin));
            settingsMap.put("macro-map", JavaSettingsDefaults.getJavaMacroMap());
            settingsMap.put("caret-simple-match-brace", JavaSettingsDefaults.defaultCaretSimpleMatchBrace);
            settingsMap.put("highlight-match-brace", JavaSettingsDefaults.defaultHighlightMatchBrace);
            settingsMap.put("identifier-acceptor", JavaSettingsDefaults.defaultIdentifierAcceptor);
            settingsMap.put("abbrev-reset-acceptor", JavaSettingsDefaults.defaultAbbrevResetAcceptor);
            settingsMap.put("word-match-match-case", JavaSettingsDefaults.defaultWordMatchMatchCase);
            settingsMap.put("word-match-static-words", "Exception IntrospectionException FileNotFoundException IOException ArrayIndexOutOfBoundsException ClassCastException ClassNotFoundException CloneNotSupportedException NullPointerException NumberFormatException SQLException IllegalAccessException IllegalArgumentException");
            settingsMap.put("java-format-space-before-parenthesis", JavaSettingsDefaults.defaultJavaFormatSpaceBeforeParenthesis);
            settingsMap.put("java-format-space-after-comma", JavaSettingsDefaults.defaultJavaFormatSpaceAfterComma);
            settingsMap.put("java-format-newline-before-brace", JavaSettingsDefaults.defaultJavaFormatNewlineBeforeBrace);
            settingsMap.put("java-format-leading-space-in-comment", JavaSettingsDefaults.defaultJavaFormatLeadingSpaceInComment);
            settingsMap.put("java-format-leading-star-in-comment", JavaSettingsDefaults.defaultJavaFormatLeadingStarInComment);
            settingsMap.put("indent-hot-chars-acceptor", JavaSettingsDefaults.defaultIndentHotCharsAcceptor);
            settingsMap.put("reindent-with-text-before", Boolean.FALSE);
            settingsMap.put("pair-characters-completion", JavaSettingsDefaults.defaultPairCharactersCompletion);
            settingsMap.put("goto-class-case-sensitive", JavaSettingsDefaults.defaultGotoClassCaseSensitive);
            settingsMap.put("goto-class-show-inner-classes", JavaSettingsDefaults.defaultGotoClassShowInnerClasses);
            settingsMap.put("goto-class-show-library-classes", JavaSettingsDefaults.defaultGotoClassShowLibraryClasses);
            Coloring col = new Coloring(this._font, SettingsDefaults.defaultForeColor, SettingsDefaults.defaultBackColor);
            SettingsUtil.setColoring((Map)settingsMap, (String)"default", (Object)col);
        }
    }
}

