/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.netbeans;

import java.util.Arrays;
import java.util.Vector;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.ISyntaxHighlightTokenMatcher;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsAdapter;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ErrorInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.NetbeansPropertiesWrapper;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.NetbeansSQLEditorPane;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.SQLTokenContext;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;

public class SQLSyntax
extends Syntax {
    private static ILogger s_log = LoggerController.createLogger(SQLSyntax.class);
    private static final int ISI_WHITESPACE = 2;
    private static final int ISI_LINE_COMMENT = 4;
    private static final int ISI_BLOCK_COMMENT = 5;
    private static final int ISI_STRING = 6;
    private static final int ISI_STRING_A_BSLASH = 7;
    private static final int ISI_CHAR = 8;
    private static final int ISI_CHAR_A_BSLASH = 9;
    private static final int ISI_IDENTIFIER = 10;
    private static final int ISA_MINUS = 11;
    private static final int ISA_EQ = 12;
    private static final int ISA_GT = 13;
    private static final int ISA_GTGT = 14;
    private static final int ISA_GTGTGT = 15;
    private static final int ISA_LT = 16;
    private static final int ISA_LTLT = 17;
    private static final int ISA_PLUS = 18;
    private static final int ISA_SLASH = 19;
    private static final int ISA_STAR = 20;
    private static final int ISA_STAR_I_BLOCK_COMMENT = 21;
    private static final int ISA_PIPE = 22;
    private static final int ISA_PERCENT = 23;
    private static final int ISA_AND = 24;
    private static final int ISA_XOR = 25;
    private static final int ISA_EXCLAMATION = 26;
    private static final int ISA_ZERO = 27;
    private static final int ISI_INT = 28;
    private static final int ISI_OCTAL = 29;
    private static final int ISI_DOUBLE = 30;
    private static final int ISI_DOUBLE_EXP = 31;
    private static final int ISI_HEX = 32;
    private static final int ISA_DOT = 33;
    private ISession _sess;
    private NetbeansSQLEditorPane _editorPane;
    private NetbeansPropertiesWrapper _props;
    private Vector<ErrorInfo> _currentErrorInfos = new Vector();
    private boolean _parsingInitialized;
    private ISyntaxHighlightTokenMatcher _tokenMatcher;

    public SQLSyntax(ISession sess, NetbeansSQLEditorPane editorPane, NetbeansPropertiesWrapper props) {
        this._sess = sess;
        this._editorPane = editorPane;
        this._props = props;
        this.tokenContextPath = SQLTokenContext.contextPath;
        this._tokenMatcher = props.getSyntaxHighlightTokenMatcher(this._sess, this._editorPane);
    }

    private void initParsing() {
        if (!this._parsingInitialized && null != this._props.getParserEventsProcessor(this._editorPane.getSqlEntryPanelIdentifier(), this._sess)) {
            this._parsingInitialized = true;
            this._props.getParserEventsProcessor(this._editorPane.getSqlEntryPanelIdentifier(), this._sess).addParserEventsListener((ParserEventsListener)new ParserEventsAdapter(){

                public void errorsFound(ErrorInfo[] errorInfos) {
                    SQLSyntax.this.onErrorsFound(errorInfos);
                }
            });
        }
    }

    private void onErrorsFound(ErrorInfo[] errorInfos) {
        boolean errorsChanged = false;
        if (this._currentErrorInfos.size() == errorInfos.length) {
            for (int i = 0; i < errorInfos.length; ++i) {
                if (errorInfos[i].equals((Object)this._currentErrorInfos.get(i))) continue;
                errorsChanged = true;
                break;
            }
        } else {
            errorsChanged = true;
        }
        if (errorsChanged) {
            this._currentErrorInfos.clear();
            this._currentErrorInfos.addAll(Arrays.asList(errorInfos));
            this._editorPane.repaint();
        }
    }

    protected TokenID parseToken() {
        this.initParsing();
        while (this.offset < this.stopOffset) {
            char actChar = this.buffer[this.offset];
            block0 : switch (this.state) {
                case -1: {
                    switch (actChar) {
                        case '\'': {
                            this.state = 6;
                            break block0;
                        }
                        case '-': {
                            this.state = 11;
                            break block0;
                        }
                        case '=': {
                            this.state = 12;
                            break block0;
                        }
                        case '>': {
                            this.state = 13;
                            break block0;
                        }
                        case '<': {
                            this.state = 16;
                            break block0;
                        }
                        case '+': {
                            this.state = 18;
                            break block0;
                        }
                        case '/': {
                            this.state = 19;
                            break block0;
                        }
                        case '*': {
                            this.state = 20;
                            break block0;
                        }
                        case '|': {
                            this.state = 22;
                            break block0;
                        }
                        case '%': {
                            this.state = 23;
                            break block0;
                        }
                        case '&': {
                            this.state = 24;
                            break block0;
                        }
                        case '^': {
                            this.state = 25;
                            break block0;
                        }
                        case '~': {
                            ++this.offset;
                            return SQLTokenContext.NEG;
                        }
                        case '!': {
                            this.state = 26;
                            break block0;
                        }
                        case '0': {
                            this.state = 27;
                            break block0;
                        }
                        case '.': {
                            this.state = 33;
                            break block0;
                        }
                        case ',': {
                            ++this.offset;
                            return SQLTokenContext.COMMA;
                        }
                        case ';': {
                            ++this.offset;
                            return SQLTokenContext.SEMICOLON;
                        }
                        case ':': {
                            ++this.offset;
                            return SQLTokenContext.COLON;
                        }
                        case '?': {
                            ++this.offset;
                            return SQLTokenContext.QUESTION;
                        }
                        case '(': {
                            ++this.offset;
                            return SQLTokenContext.LPAREN;
                        }
                        case ')': {
                            ++this.offset;
                            return SQLTokenContext.RPAREN;
                        }
                        case '[': {
                            ++this.offset;
                            return SQLTokenContext.LBRACKET;
                        }
                        case ']': {
                            ++this.offset;
                            return SQLTokenContext.RBRACKET;
                        }
                        case '{': {
                            ++this.offset;
                            return SQLTokenContext.LBRACE;
                        }
                        case '}': {
                            ++this.offset;
                            return SQLTokenContext.RBRACE;
                        }
                        case '@': {
                            ++this.offset;
                            return SQLTokenContext.ANNOTATION;
                        }
                    }
                    if (Character.isWhitespace(actChar)) {
                        this.state = 2;
                        break;
                    }
                    if (Character.isDigit(actChar)) {
                        this.state = 28;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(actChar)) {
                        this.state = 10;
                        break;
                    }
                    ++this.offset;
                    return SQLTokenContext.INVALID_CHAR;
                }
                case 2: {
                    if (Character.isWhitespace(actChar)) break;
                    this.state = -1;
                    return SQLTokenContext.WHITESPACE;
                }
                case 4: {
                    switch (actChar) {
                        case '\n': {
                            this.state = -1;
                            return SQLTokenContext.LINE_COMMENT;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (actChar) {
                        case '*': {
                            this.state = 21;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (actChar) {
                        case '\\': {
                            this.state = 7;
                            break block0;
                        }
                        case '\n': {
                            this.state = -1;
                            this.supposedTokenID = SQLTokenContext.STRING_LITERAL;
                            return this.supposedTokenID;
                        }
                        case '\'': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.STRING_LITERAL;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (actChar) {
                        case '\'': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 6;
                    break;
                }
                case 8: {
                    switch (actChar) {
                        case '\\': {
                            this.state = 9;
                            break block0;
                        }
                        case '\n': {
                            this.state = -1;
                            this.supposedTokenID = SQLTokenContext.CHAR_LITERAL;
                            return this.supposedTokenID;
                        }
                        case '\'': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.CHAR_LITERAL;
                        }
                    }
                    break;
                }
                case 9: {
                    switch (actChar) {
                        case '\'': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 8;
                    break;
                }
                case 10: {
                    if (Character.isJavaIdentifierPart(actChar)) break;
                    this.state = -1;
                    return this.findMatchingTokenID();
                }
                case 11: {
                    switch (actChar) {
                        case '-': {
                            this.state = 4;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.MINUS;
                }
                case 19: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.DIV_EQ;
                        }
                        case '*': {
                            this.state = 5;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.DIV;
                }
                case 12: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            return SQLTokenContext.EQ_EQ;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.EQ;
                }
                case 13: {
                    switch (actChar) {
                        case '>': {
                            this.state = 14;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return SQLTokenContext.GT_EQ;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.GT;
                }
                case 14: {
                    switch (actChar) {
                        case '>': {
                            this.state = 15;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return SQLTokenContext.RSSHIFT_EQ;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.RSSHIFT;
                }
                case 15: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            return SQLTokenContext.RUSHIFT_EQ;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.RUSHIFT;
                }
                case 16: {
                    switch (actChar) {
                        case '<': {
                            this.state = 17;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return SQLTokenContext.LT_EQ;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.LT;
                }
                case 17: {
                    switch (actChar) {
                        case '<': {
                            this.state = -1;
                            ++this.offset;
                            return SQLTokenContext.INVALID_OPERATOR;
                        }
                        case '=': {
                            ++this.offset;
                            return SQLTokenContext.LSHIFT_EQ;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.LSHIFT;
                }
                case 18: {
                    switch (actChar) {
                        case '+': {
                            ++this.offset;
                            return SQLTokenContext.PLUS_PLUS;
                        }
                        case '=': {
                            ++this.offset;
                            return SQLTokenContext.PLUS_EQ;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.PLUS;
                }
                case 20: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            return SQLTokenContext.MUL_EQ;
                        }
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.INVALID_COMMENT_END;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.MUL;
                }
                case 21: {
                    switch (actChar) {
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.BLOCK_COMMENT;
                        }
                    }
                    --this.offset;
                    this.state = 5;
                    break;
                }
                case 22: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.OR_EQ;
                        }
                        case '|': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.OR_OR;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.OR;
                }
                case 23: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.MOD_EQ;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.MOD;
                }
                case 24: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.AND_EQ;
                        }
                        case '&': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.AND_AND;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.AND;
                }
                case 25: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.XOR_EQ;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.XOR;
                }
                case 26: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.NOT_EQ;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.NOT;
                }
                case 27: {
                    switch (actChar) {
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                        case 'X': 
                        case 'x': {
                            this.state = 32;
                            break block0;
                        }
                        case 'L': 
                        case 'l': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.LONG_LITERAL;
                        }
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.DOUBLE_LITERAL;
                        }
                        case '8': 
                        case '9': {
                            this.state = -1;
                            ++this.offset;
                            return SQLTokenContext.INVALID_OCTAL_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (Character.isDigit(actChar)) {
                        this.state = 29;
                        break;
                    }
                    this.state = -1;
                    return SQLTokenContext.INT_LITERAL;
                }
                case 28: {
                    switch (actChar) {
                        case 'L': 
                        case 'l': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.LONG_LITERAL;
                        }
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.DOUBLE_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (actChar >= '0' && actChar <= '9') break;
                    this.state = -1;
                    return SQLTokenContext.INT_LITERAL;
                }
                case 29: {
                    if (actChar >= '0' && actChar <= '7') break;
                    this.state = -1;
                    return SQLTokenContext.OCTAL_LITERAL;
                }
                case 30: {
                    switch (actChar) {
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.DOUBLE_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (actChar >= '0' && actChar <= '9' || actChar == '.') break;
                    this.state = -1;
                    return SQLTokenContext.DOUBLE_LITERAL;
                }
                case 31: {
                    switch (actChar) {
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.DOUBLE_LITERAL;
                        }
                    }
                    if (Character.isDigit(actChar) || actChar == '-' || actChar == '+') break;
                    this.state = -1;
                    return SQLTokenContext.DOUBLE_LITERAL;
                }
                case 32: {
                    if (actChar >= 'a' && actChar <= 'f' || actChar >= 'A' && actChar <= 'F' || Character.isDigit(actChar)) break;
                    this.state = -1;
                    return SQLTokenContext.HEX_LITERAL;
                }
                case 33: {
                    if (Character.isDigit(actChar)) {
                        this.state = 30;
                        break;
                    }
                    if (actChar == '.' && this.offset + 1 < this.stopOffset && this.buffer[this.offset + 1] == '.') {
                        this.offset += 2;
                        this.state = -1;
                        return SQLTokenContext.ELLIPSIS;
                    }
                    this.state = -1;
                    return SQLTokenContext.DOT;
                }
            }
            ++this.offset;
        }
        if (this.lastBuffer) {
            switch (this.state) {
                case 2: {
                    this.state = -1;
                    return SQLTokenContext.WHITESPACE;
                }
                case 10: {
                    this.state = -1;
                    return this.findMatchingTokenID();
                }
                case 4: {
                    return SQLTokenContext.LINE_COMMENT;
                }
                case 5: 
                case 21: {
                    return SQLTokenContext.BLOCK_COMMENT;
                }
                case 6: 
                case 7: {
                    return SQLTokenContext.STRING_LITERAL;
                }
                case 8: 
                case 9: {
                    return SQLTokenContext.CHAR_LITERAL;
                }
                case 27: 
                case 28: {
                    this.state = -1;
                    return SQLTokenContext.INT_LITERAL;
                }
                case 29: {
                    this.state = -1;
                    return SQLTokenContext.OCTAL_LITERAL;
                }
                case 30: 
                case 31: {
                    this.state = -1;
                    return SQLTokenContext.DOUBLE_LITERAL;
                }
                case 32: {
                    this.state = -1;
                    return SQLTokenContext.HEX_LITERAL;
                }
                case 33: {
                    this.state = -1;
                    return SQLTokenContext.DOT;
                }
                case 11: {
                    this.state = -1;
                    return SQLTokenContext.LINE_COMMENT;
                }
                case 19: {
                    this.state = -1;
                    return SQLTokenContext.DIV;
                }
                case 12: {
                    this.state = -1;
                    return SQLTokenContext.EQ;
                }
                case 13: {
                    this.state = -1;
                    return SQLTokenContext.GT;
                }
                case 14: {
                    this.state = -1;
                    return SQLTokenContext.RSSHIFT;
                }
                case 15: {
                    this.state = -1;
                    return SQLTokenContext.RUSHIFT;
                }
                case 16: {
                    this.state = -1;
                    return SQLTokenContext.LT;
                }
                case 17: {
                    this.state = -1;
                    return SQLTokenContext.LSHIFT;
                }
                case 18: {
                    this.state = -1;
                    return SQLTokenContext.PLUS;
                }
                case 20: {
                    this.state = -1;
                    return SQLTokenContext.MUL;
                }
                case 22: {
                    this.state = -1;
                    return SQLTokenContext.OR;
                }
                case 23: {
                    this.state = -1;
                    return SQLTokenContext.MOD;
                }
                case 24: {
                    this.state = -1;
                    return SQLTokenContext.AND;
                }
                case 25: {
                    this.state = -1;
                    return SQLTokenContext.XOR;
                }
                case 26: {
                    this.state = -1;
                    return SQLTokenContext.NOT;
                }
            }
        }
        switch (this.state) {
            case 2: {
                return SQLTokenContext.WHITESPACE;
            }
        }
        return null;
    }

    private TokenID findMatchingTokenID() {
        TokenID tid = this.matchError(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
        tid = tid != null ? tid : this.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
        tid = tid != null ? tid : this.matchTable(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
        tid = tid != null ? tid : this.matchFunction(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
        tid = tid != null ? tid : this.matchDataType(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
        tid = tid != null ? tid : this.matchStatementSeparator(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
        tid = tid != null ? tid : this.matchColumn(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
        return tid != null ? tid : SQLTokenContext.IDENTIFIER;
    }

    public String getStateName(int stateNumber) {
        switch (stateNumber) {
            case 2: {
                return "ISI_WHITESPACE";
            }
            case 4: {
                return "ISI_LINE_COMMENT";
            }
            case 5: {
                return "ISI_BLOCK_COMMENT";
            }
            case 6: {
                return "ISI_STRING";
            }
            case 7: {
                return "ISI_STRING_A_BSLASH";
            }
            case 8: {
                return "ISI_CHAR";
            }
            case 9: {
                return "ISI_CHAR_A_BSLASH";
            }
            case 10: {
                return "ISI_IDENTIFIER";
            }
            case 11: {
                return "ISA_MINUS";
            }
            case 12: {
                return "ISA_EQ";
            }
            case 13: {
                return "ISA_GT";
            }
            case 14: {
                return "ISA_GTGT";
            }
            case 15: {
                return "ISA_GTGTGT";
            }
            case 16: {
                return "ISA_LT";
            }
            case 17: {
                return "ISA_LTLT";
            }
            case 18: {
                return "ISA_PLUS";
            }
            case 19: {
                return "ISA_SLASH";
            }
            case 20: {
                return "ISA_STAR";
            }
            case 21: {
                return "ISA_STAR_I_BLOCK_COMMENT";
            }
            case 22: {
                return "ISA_PIPE";
            }
            case 23: {
                return "ISA_PERCENT";
            }
            case 24: {
                return "ISA_AND";
            }
            case 25: {
                return "ISA_XOR";
            }
            case 26: {
                return "ISA_EXCLAMATION";
            }
            case 27: {
                return "ISA_ZERO";
            }
            case 28: {
                return "ISI_INT";
            }
            case 29: {
                return "ISI_OCTAL";
            }
            case 30: {
                return "ISI_DOUBLE";
            }
            case 31: {
                return "ISI_DOUBLE_EXP";
            }
            case 32: {
                return "ISI_HEX";
            }
            case 33: {
                return "ISA_DOT";
            }
        }
        return super.getStateName(stateNumber);
    }

    private TokenID matchTable(char[] buffer, int offset, int len) {
        if (this._tokenMatcher.isTable(buffer, offset, len)) {
            return SQLTokenContext.TABLE;
        }
        return null;
    }

    private TokenID matchFunction(char[] buffer, int offset, int len) {
        if (this._tokenMatcher.isFunction(buffer, offset, len)) {
            return SQLTokenContext.FUNCTION;
        }
        return null;
    }

    private TokenID matchDataType(char[] buffer, int offset, int len) {
        if (this._tokenMatcher.isDataType(buffer, offset, len)) {
            return SQLTokenContext.DATA_TYPE;
        }
        return null;
    }

    private TokenID matchStatementSeparator(char[] buffer, int offset, int len) {
        if (this._tokenMatcher.isStatementSeparator(buffer, offset, len)) {
            return SQLTokenContext.STATEMENT_SEPARATOR;
        }
        return null;
    }

    private TokenID matchColumn(char[] buffer, int offset, int len) {
        if (this._tokenMatcher.isColumn(buffer, offset, len)) {
            return SQLTokenContext.COLUMN;
        }
        return null;
    }

    private TokenID matchKeyword(char[] buffer, int offset, int len) {
        if (this._tokenMatcher.isKeyword(buffer, offset, len)) {
            return SQLTokenContext.PACKAGE;
        }
        return null;
    }

    private TokenID matchError(char[] buffer, int offset, int len) {
        int absolutePosition = this.stopPosition + offset - this.stopOffset;
        for (int i = 0; i < this._currentErrorInfos.size(); ++i) {
            ErrorInfo errInf = this._currentErrorInfos.elementAt(i);
            if (absolutePosition <= errInf.beginPos && errInf.endPos <= absolutePosition + len) {
                return SQLTokenContext.ERROR;
            }
            if (absolutePosition != errInf.beginPos) continue;
            return SQLTokenContext.ERROR;
        }
        return null;
    }

    public void addSQLTokenListener(SQLTokenListener tl) {
        this._tokenMatcher.addSQLTokenListener(tl);
    }

    public void removeSQLTokenListener(SQLTokenListener tl) {
        this._tokenMatcher.removeSQLTokenListener(tl);
    }
}

