/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.netbeans;

import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.ISyntaxHighlightTokenMatcher;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.client.session.schemainfo.CaseInsensitiveString;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.NetbeansSQLEditorPane;

public class SqlSyntaxHighlightTokenMatcher
implements ISyntaxHighlightTokenMatcher {
    private ISession _sess;
    private NetbeansSQLEditorPane _editorPane;
    private CaseInsensitiveString _caseInsensitiveStringBuffer = new CaseInsensitiveString();
    private Hashtable<CaseInsensitiveString, String> _knownTables = new Hashtable();
    private Vector<SQLTokenListener> _sqlTokenListeners = new Vector();

    public SqlSyntaxHighlightTokenMatcher(ISession sess, NetbeansSQLEditorPane editorPane) {
        this._sess = sess;
        this._editorPane = editorPane;
    }

    public boolean isError(int offset, int len) {
        return false;
    }

    public boolean isTable(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len);
        int tableExtRes = this._sess.getSchemaInfo().isTableExt(this._caseInsensitiveStringBuffer);
        if (2 == tableExtRes || 1 == tableExtRes) {
            String table = this._knownTables.get(this._caseInsensitiveStringBuffer);
            if (null == table) {
                table = new String(buffer, offset, len);
                this._knownTables.put(new CaseInsensitiveString(table), table);
            }
            if (1 == tableExtRes) {
                this._editorPane.repaint();
            }
            this.fireTableOrViewFound(table);
            return true;
        }
        return false;
    }

    private void fireTableOrViewFound(String tableOrViewName) {
        for (int i = 0; i < this._sqlTokenListeners.size(); ++i) {
            SQLTokenListener sqlTokenListener = this._sqlTokenListeners.elementAt(i);
            sqlTokenListener.tableOrViewFound(tableOrViewName);
        }
    }

    public void addSQLTokenListener(SQLTokenListener tl) {
        this.removeSQLTokenListener(tl);
        this._sqlTokenListeners.add(tl);
    }

    public boolean isFunction(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len);
        if (this._sess.getSchemaInfo().isFunction(this._caseInsensitiveStringBuffer)) {
            return true;
        }
        return this._sess.getSchemaInfo().isProcedure(this._caseInsensitiveStringBuffer);
    }

    public boolean isDataType(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len);
        return this._sess.getSchemaInfo().isDataType(this._caseInsensitiveStringBuffer);
    }

    public boolean isStatementSeparator(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len);
        String statSep = this._sess.getQueryTokenizer().getSQLStatementSeparator();
        if (statSep.length() != len) {
            return false;
        }
        for (int i = 0; i < statSep.length(); ++i) {
            if (buffer[offset + i] == statSep.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isColumn(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len);
        return this._sess.getSchemaInfo().isColumn(this._caseInsensitiveStringBuffer);
    }

    public boolean isKeyword(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len);
        return this._sess.getSchemaInfo().isKeyword(this._caseInsensitiveStringBuffer);
    }

    public void removeSQLTokenListener(SQLTokenListener tl) {
        this._sqlTokenListeners.remove(tl);
    }
}

