/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.netbeans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;
import org.netbeans.editor.DialogSupport;

public class SquirrelNBDialogFactory
extends WindowAdapter
implements DialogSupport.DialogFactory,
ActionListener {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SquirrelNBDialogFactory.class);
    private JButton cancelButton;
    private SyntaxPlugin _plugin;
    private boolean _findHintProvided;

    public SquirrelNBDialogFactory(SyntaxPlugin plugin) {
        this._plugin = plugin;
    }

    JPanel createButtonPanel(JButton[] buttons, boolean sidebuttons) {
        int count = buttons.length;
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.setBorder(new EmptyBorder(new Insets(sidebuttons ? 5 : 0, sidebuttons ? 0 : 5, 5, 5)));
        GridLayout lm = new GridLayout(sidebuttons ? count : 1, sidebuttons ? 1 : count, 5, 5);
        JPanel innerPanel = new JPanel(lm);
        for (int i = 0; i < count; ++i) {
            innerPanel.add(buttons[i]);
        }
        outerPanel.add((Component)innerPanel, sidebuttons ? "North" : "East");
        return outerPanel;
    }

    public Dialog createDialog(String title, JPanel panel, boolean modal, JButton[] buttons, boolean sidebuttons, int defaultIndex, int cancelIndex, ActionListener listener) {
        if (!this._findHintProvided && "find".equalsIgnoreCase(title)) {
            ISession[] activeSessions = new ISession[]{this._plugin.getApplication().getSessionManager().getActiveSession()};
            for (int i = 0; i < activeSessions.length; ++i) {
                activeSessions[i].showMessage(s_stringMgr.getString("syntax.findExplain"));
            }
            this._findHintProvided = true;
        }
        JDialog dlg = new JDialog((Frame)this._plugin.getApplication().getMainFrame(), title, modal);
        dlg.setDefaultCloseOperation(0);
        dlg.getContentPane().add((Component)panel, "Center");
        JPanel buttonPanel = this.createButtonPanel(buttons, sidebuttons);
        String buttonAlign = sidebuttons ? "East" : "South";
        dlg.getContentPane().add((Component)buttonPanel, buttonAlign);
        if (listener != null) {
            for (int i = 0; i < buttons.length; ++i) {
                ActionListener[] actionListeners = buttons[i].getActionListeners();
                boolean found = false;
                for (int j = 0; j < actionListeners.length; ++j) {
                    if (!actionListeners[j].equals(listener)) continue;
                    found = true;
                }
                if (found) continue;
                buttons[i].addActionListener(listener);
            }
        }
        if (defaultIndex >= 0) {
            dlg.getRootPane().setDefaultButton(buttons[defaultIndex]);
        }
        if (cancelIndex >= 0) {
            this.cancelButton = buttons[cancelIndex];
            dlg.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0, true), 2);
            dlg.addWindowListener(this);
        }
        dlg.pack();
        GUIUtils.centerWithinParent((Window)dlg);
        return dlg;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.cancelButton.doClick(10);
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this.cancelButton.doClick(10);
    }
}

