/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.netbeans;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.text.Document;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.NetbeansPropertiesWrapper;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.NetbeansSQLEditorPane;
import net.sourceforge.squirrel_sql.plugins.syntax.netbeans.SQLSyntax;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Syntax;

public class SyntaxFactory {
    private Hashtable<Document, DocumentAssignedObjects> _documentAssignedObjectsByDocument = new Hashtable();
    private Hashtable<IIdentifier, ArrayList<NetbeansSQLEditorPane>> _editorPanesBySessionID = new Hashtable();
    private Hashtable<IIdentifier, Vector<SQLSyntax>> _syntaxesBySessionID = new Hashtable();
    private Hashtable<IIdentifier, Vector<SQLTokenListener>> _sqlTokenListenersBySession = new Hashtable();
    private Hashtable<IIdentifier, ArrayList<Document>> _documentsBySessionID = new Hashtable();

    public SyntaxFactory() {
        final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.editor.Bundle");
        LocaleSupport.addLocalizer((LocaleSupport.Localizer)new LocaleSupport.Localizer(){

            public String getString(String key) {
                if ("status-bar-insert".equals(key)) {
                    return "INS";
                }
                if ("status-bar-overwrite".equals(key)) {
                    return "OVR";
                }
                return bundle.getString(key);
            }
        });
    }

    public Syntax getSyntax(Document doc) {
        Vector<SQLSyntax> syntaxes;
        DocumentAssignedObjects docAssigendObjs = this._documentAssignedObjectsByDocument.get(doc);
        if (null == docAssigendObjs) {
            return new Syntax();
        }
        ArrayList<NetbeansSQLEditorPane> editors = this._editorPanesBySessionID.get(docAssigendObjs.getSession().getIdentifier());
        NetbeansSQLEditorPane editorMatchingDocument = null;
        for (NetbeansSQLEditorPane editor : editors) {
            if (!doc.equals(editor.getDocument())) continue;
            editorMatchingDocument = editor;
            break;
        }
        if (null == editorMatchingDocument) {
            throw new IllegalStateException("No Editor matching document found");
        }
        SQLSyntax syntax = new SQLSyntax(docAssigendObjs.getSession(), editorMatchingDocument, docAssigendObjs.getProperties());
        Vector<SQLTokenListener> tokenListeners = this._sqlTokenListenersBySession.get(docAssigendObjs.getSession().getIdentifier());
        if (null != tokenListeners) {
            for (int i = 0; i < tokenListeners.size(); ++i) {
                SQLTokenListener tl = tokenListeners.elementAt(i);
                syntax.addSQLTokenListener(tl);
            }
        }
        if (null == (syntaxes = this._syntaxesBySessionID.get(docAssigendObjs.getSession().getIdentifier()))) {
            syntaxes = new Vector();
            this._syntaxesBySessionID.put(docAssigendObjs.getSession().getIdentifier(), syntaxes);
        }
        syntaxes.add(syntax);
        return syntax;
    }

    public void addSQLTokenListeners(ISession sess, SQLTokenListener tl) {
        Vector<Object> tokenListeners = this._sqlTokenListenersBySession.get(sess.getIdentifier());
        if (null == tokenListeners) {
            tokenListeners = new Vector();
            this._sqlTokenListenersBySession.put(sess.getIdentifier(), tokenListeners);
        }
        tokenListeners.add(tl);
        Vector<SQLSyntax> syntaxes = this._syntaxesBySessionID.get(sess.getIdentifier());
        if (null != syntaxes) {
            for (int i = 0; i < syntaxes.size(); ++i) {
                SQLSyntax syntax = syntaxes.elementAt(i);
                syntax.addSQLTokenListener(tl);
            }
        }
    }

    public void removeSQLTokenListeners(ISession sess, SQLTokenListener tl) {
        Vector<SQLTokenListener> tokenListeners = this._sqlTokenListenersBySession.get(sess.getIdentifier());
        if (null == tokenListeners) {
            return;
        }
        tokenListeners.remove(tl);
        Vector<SQLSyntax> syntaxes = this._syntaxesBySessionID.get(sess.getIdentifier());
        for (int i = 0; i < syntaxes.size(); ++i) {
            SQLSyntax syntax = syntaxes.elementAt(i);
            syntax.removeSQLTokenListener(tl);
        }
    }

    public void putEditorPane(ISession sess, NetbeansSQLEditorPane editor) {
        ArrayList<NetbeansSQLEditorPane> buf = this._editorPanesBySessionID.get(sess.getIdentifier());
        if (null == buf) {
            buf = new ArrayList();
            this._editorPanesBySessionID.put(sess.getIdentifier(), buf);
        }
        buf.remove(editor);
        buf.add(editor);
    }

    public void putDocument(ISession session, NetbeansPropertiesWrapper wrp, Document document) {
        this._documentAssignedObjectsByDocument.put(document, new DocumentAssignedObjects(session, wrp));
        ArrayList<Document> docs = this._documentsBySessionID.get(session.getIdentifier());
        if (null == docs) {
            docs = new ArrayList();
            this._documentsBySessionID.put(session.getIdentifier(), docs);
        }
        docs.add(document);
    }

    public void sessionEnding(ISession sess) {
        ArrayList<Document> docs = this._documentsBySessionID.remove(sess.getIdentifier());
        if (null != docs) {
            for (Document doc : docs) {
                this._documentAssignedObjectsByDocument.remove(doc);
            }
        }
        this._editorPanesBySessionID.remove(sess.getIdentifier());
        this._syntaxesBySessionID.remove(sess.getIdentifier());
        this._sqlTokenListenersBySession.remove(sess.getIdentifier());
    }

    private static class DocumentAssignedObjects {
        private ISession _session;
        private NetbeansPropertiesWrapper _wrp;

        public DocumentAssignedObjects(ISession session, NetbeansPropertiesWrapper wrp) {
            this._session = session;
            this._wrp = wrp;
        }

        public ISession getSession() {
            return this._session;
        }

        public NetbeansPropertiesWrapper getProperties() {
            return this._wrp;
        }
    }
}

