/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.oster;

import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseListener;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.dnd.FileEditorDropTargetListener;
import net.sourceforge.squirrel_sql.client.session.BaseSQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.oster.OsterTextControl;

public class OsterSQLEntryPanel
extends BaseSQLEntryPanel {
    private static final ILogger s_log = LoggerController.createLogger(OsterSQLEntryPanel.class);
    private IApplication _app;
    private OsterTextControl _textArea;
    private DropTarget dt;
    private ISession _session;

    OsterSQLEntryPanel(ISession session, SyntaxPreferences prefs) {
        super(session.getApplication());
        this._session = session;
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        if (prefs == null) {
            throw new IllegalArgumentException("Null Preferences passed");
        }
        this._app = session.getApplication();
        this._textArea = new OsterTextControl(session, prefs, this.getIdentifier());
        this.dt = new DropTarget(this._textArea, (DropTargetListener)new FileEditorDropTargetListener(session));
    }

    public void endColorerThread() {
        this._textArea.endColorerThread();
    }

    public JTextComponent getTextComponent() {
        return this._textArea;
    }

    public boolean getDoesTextComponentHaveScroller() {
        return false;
    }

    public String getText() {
        return this._textArea.getText();
    }

    public void setFont(Font font) {
        this._textArea.setFont(font);
    }

    public String getSelectedText() {
        return this._textArea.getSelectedText();
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean select) {
        this._textArea.setText(text);
        if (select) {
            this.setSelectionEnd(this._textArea.getDocument().getLength());
            this.setSelectionStart(0);
        }
    }

    public void appendText(String sqlScript) {
        this.appendText(sqlScript, false);
    }

    public void appendText(String sqlScript, boolean select) {
        Document doc = this._textArea.getDocument();
        try {
            int start = 0;
            if (select) {
                start = doc.getLength();
            }
            doc.insertString(doc.getLength(), sqlScript, null);
            if (select) {
                this.setSelectionEnd(doc.getLength());
                this.setSelectionStart(start);
            }
        }
        catch (Exception ex) {
            s_log.error((Object)"Error appending text to text area", (Throwable)ex);
        }
    }

    public int getCaretPosition() {
        return this._textArea.getCaretPosition();
    }

    public void setCaretPosition(int value) {
        this._textArea.setCaretPosition(value);
    }

    public void setTabSize(int tabSize) {
        this._textArea.getDocument().putProperty("tabSize", tabSize);
    }

    public int getSelectionStart() {
        return this._textArea.getSelectionStart();
    }

    public void setSelectionStart(int pos) {
        this._textArea.setSelectionStart(pos);
    }

    public int getSelectionEnd() {
        return this._textArea.getSelectionEnd();
    }

    public void setSelectionEnd(int pos) {
        this._textArea.setSelectionEnd(pos);
    }

    public void replaceSelection(String sqlScript) {
        this._textArea.replaceSelection(sqlScript);
    }

    public boolean hasFocus() {
        return this._textArea.hasFocus();
    }

    public void requestFocus() {
        this._textArea.requestFocus();
    }

    public void addMouseListener(MouseListener lis) {
        this._textArea.addMouseListener(lis);
    }

    public void removeMouseListener(MouseListener lis) {
        this._textArea.removeMouseListener(lis);
    }

    public void updateFromPreferences() {
        this._textArea.updateFromPreferences();
    }

    public boolean hasOwnUndoableManager() {
        return false;
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this._textArea.getDocument().addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this._textArea.getDocument().removeUndoableEditListener(listener);
    }

    public void setUndoManager(UndoManager manager) {
    }

    public int getCaretLineNumber() {
        int pos = this.getCaretPosition();
        StyledDocument doc = this._textArea.getStyledDocument();
        Element docElem = doc.getDefaultRootElement();
        return docElem.getElementIndex(pos);
    }

    public int getCaretLinePosition() {
        String textTillCarret = this.getText().substring(0, this.getCaretPosition());
        int lineFeedIndex = textTillCarret.lastIndexOf(10);
        if (-1 == lineFeedIndex) {
            return this.getCaretPosition();
        }
        return this.getCaretPosition() - lineFeedIndex - 1;
    }

    public void addCaretListener(CaretListener lis) {
        this._textArea.addCaretListener(lis);
    }

    public void removeCaretListener(CaretListener lis) {
        this._textArea.removeCaretListener(lis);
    }

    public void addSQLTokenListener(SQLTokenListener tl) {
        this._textArea.addSQLTokenListener(tl);
    }

    public void removeSQLTokenListener(SQLTokenListener tl) {
        this._textArea.removeSQLTokenListener(tl);
    }

    public ISession getSession() {
        return this._session;
    }
}

