/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.oster;

import com.Ostermiller.Syntax.Lexer.Lexer;
import com.Ostermiller.Syntax.Lexer.SQLLexer;
import com.Ostermiller.Syntax.Lexer.Token;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.sourceforge.squirrel_sql.client.session.ExtendedColumnInfo;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsAdapter;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ErrorInfo;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfo;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.syntax.KeyManager;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxStyle;

public class OsterTextControl
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private static final ILogger s_log = LoggerController.createLogger(OsterTextControl.class);
    private final ISession _session;
    private Object doclock = new Object();
    private HighLightedDocument document;
    private DocumentReader documentReader;
    private Lexer syntaxLexer;
    private Colorer colorer;
    private Hashtable<String, SimpleAttributeSet> styles = new Hashtable();
    private final SyntaxPreferences _syntaxPrefs;
    private Vector<SQLTokenListener> _sqlTokenListeners = new Vector();
    private Vector<ErrorInfo> _currentErrorInfos = new Vector();
    private Vector<ErrorInfo> _oldErrorInfos = new Vector();

    OsterTextControl(ISession session, SyntaxPreferences prefs, final IIdentifier sqlEntryPanelIdentifier) {
        this._session = session;
        this._syntaxPrefs = prefs;
        this.document = new HighLightedDocument();
        this.setDocument(this.document);
        this.colorer = new Colorer();
        this.colorer.start();
        this.initStyles();
        this.documentReader = new DocumentReader(this.document);
        this.initDocument();
        this.setToolTipText("Just to make getToolTiptext() to be called");
        this.updateFromPreferences();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OsterTextControl.this.initParser(OsterTextControl.this._session, sqlEntryPanelIdentifier);
            }
        });
        new KeyManager(this);
    }

    private void initParser(ISession session, IIdentifier sqlEntryPanelIdentifier) {
        session.getParserEventsProcessor(sqlEntryPanelIdentifier).addParserEventsListener((ParserEventsListener)new ParserEventsAdapter(){

            public void errorsFound(ErrorInfo[] errorInfos) {
                OsterTextControl.this.onErrorsFound(errorInfos);
            }
        });
    }

    private void onErrorsFound(ErrorInfo[] errorInfos) {
        boolean errorsChanged = false;
        if (this._currentErrorInfos.size() == errorInfos.length) {
            for (int i = 0; i < errorInfos.length; ++i) {
                if (errorInfos[i].equals((Object)this._currentErrorInfos.get(i))) continue;
                errorsChanged = true;
                break;
            }
        } else {
            errorsChanged = true;
        }
        if (errorsChanged) {
            int i;
            this._oldErrorInfos.clear();
            this._oldErrorInfos.addAll(this._currentErrorInfos);
            this._currentErrorInfos.clear();
            this._currentErrorInfos.addAll(Arrays.asList(errorInfos));
            int heuristicDist = 20;
            for (i = 0; i < errorInfos.length; ++i) {
                int colBegin = Math.max(errorInfos[i].beginPos - heuristicDist, 0);
                int colLen = Math.min(errorInfos[i].endPos - errorInfos[i].beginPos + 2 * heuristicDist, this.getDocument().getLength() - colBegin);
                this.color(colBegin, colLen, false, null);
            }
            for (i = 0; i < this._oldErrorInfos.size(); ++i) {
                ErrorInfo errorInfo = this._oldErrorInfos.elementAt(i);
                int colBegin = Math.max(errorInfo.beginPos - heuristicDist, 0);
                int colLen = Math.min(errorInfo.endPos - errorInfo.beginPos + 2 * heuristicDist, this.getDocument().getLength() - colBegin);
                this.color(colBegin, colLen, false, null);
            }
        }
    }

    public void endColorerThread() {
        this.colorer.endThread();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        TextUI ui = this.getUI();
        if (parent != null) {
            return ui.getPreferredSize((JComponent)this).width <= parent.getSize().width;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFromPreferences() {
        Object object = this.doclock;
        synchronized (object) {
            FontInfo fi = this._session.getProperties().getFontInfo();
            SyntaxStyle style = this._syntaxPrefs.getColumnStyle();
            SimpleAttributeSet attribs = this.getMyStyle("columnName");
            this.applyStyle(attribs, style, fi);
            style = this._syntaxPrefs.getCommentStyle();
            attribs = this.getMyStyle("comment");
            this.applyStyle(attribs, style, fi);
            style = this._syntaxPrefs.getDataTypeStyle();
            attribs = this.getMyStyle("datatype");
            this.applyStyle(attribs, style, fi);
            style = this._syntaxPrefs.getErrorStyle();
            attribs = this.getMyStyle("error");
            this.applyStyle(attribs, style, fi);
            style = this._syntaxPrefs.getFunctionStyle();
            attribs = this.getMyStyle("function");
            this.applyStyle(attribs, style, fi);
            style = this._syntaxPrefs.getIdentifierStyle();
            attribs = this.getMyStyle("identifier");
            this.applyStyle(attribs, style, fi);
            style = this._syntaxPrefs.getLiteralStyle();
            attribs = this.getMyStyle("literal");
            this.applyStyle(attribs, style, fi);
            style = this._syntaxPrefs.getOperatorStyle();
            attribs = this.getMyStyle("operator");
            this.applyStyle(attribs, style, fi);
            style = this._syntaxPrefs.getReservedWordStyle();
            attribs = this.getMyStyle("reservedWord");
            this.applyStyle(attribs, style, fi);
            style = this._syntaxPrefs.getSeparatorStyle();
            attribs = this.getMyStyle("separator");
            this.applyStyle(attribs, style, fi);
            style = this._syntaxPrefs.getTableStyle();
            attribs = this.getMyStyle("tableName");
            this.applyStyle(attribs, style, fi);
            style = this._syntaxPrefs.getWhiteSpaceStyle();
            attribs = this.getMyStyle("whitespace");
            this.applyStyle(attribs, style, fi);
            this.colorAll();
        }
    }

    public void colorAll() {
        this.color(0, this.document.getLength(), false, null);
    }

    public void color(int position, int adjustment, boolean fireTableOrViewFoundEvent, String change) {
        this.colorer.color(position, adjustment, fireTableOrViewFoundEvent, change);
    }

    private SimpleAttributeSet getMyStyle(String styleName) {
        return this.styles.get(styleName);
    }

    private Token getNextToken() throws IOException {
        return this.syntaxLexer.getNextToken();
    }

    private void applyStyle(SimpleAttributeSet attribs, SyntaxStyle style, FontInfo fi) {
        StyleConstants.setFontFamily(attribs, fi.getFamily());
        StyleConstants.setFontSize(attribs, fi.getSize());
        StyleConstants.setBackground(attribs, new Color(style.getBackgroundRGB()));
        StyleConstants.setForeground(attribs, new Color(style.getTextRGB()));
        StyleConstants.setBold(attribs, style.isBold());
        StyleConstants.setItalic(attribs, style.isItalic());
    }

    private void initDocument() {
        this.syntaxLexer = new SQLLexer((Reader)this.documentReader);
        try {
            this.document.insertString(this.document.getLength(), "", this.getMyStyle("text"));
        }
        catch (BadLocationException ex) {
            s_log.error((Object)"Error setting initial document style", (Throwable)ex);
        }
    }

    private void initStyles() {
        FontInfo fi = this._session.getProperties().getFontInfo();
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attribs, fi.getFamily());
        StyleConstants.setFontSize(attribs, fi.getSize());
        StyleConstants.setBackground(attribs, Color.white);
        StyleConstants.setForeground(attribs, Color.black);
        StyleConstants.setBold(attribs, false);
        StyleConstants.setItalic(attribs, false);
        this.styles.put("body", attribs);
        attribs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attribs, fi.getFamily());
        StyleConstants.setFontSize(attribs, fi.getSize());
        StyleConstants.setBackground(attribs, Color.white);
        StyleConstants.setForeground(attribs, Color.blue);
        StyleConstants.setBold(attribs, true);
        StyleConstants.setItalic(attribs, false);
        this.styles.put("tag", attribs);
        attribs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attribs, fi.getFamily());
        StyleConstants.setFontSize(attribs, fi.getSize());
        StyleConstants.setBackground(attribs, Color.white);
        StyleConstants.setForeground(attribs, Color.blue);
        StyleConstants.setBold(attribs, false);
        StyleConstants.setItalic(attribs, false);
        this.styles.put("endtag", attribs);
        attribs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attribs, fi.getFamily());
        StyleConstants.setFontSize(attribs, fi.getSize());
        StyleConstants.setBackground(attribs, Color.white);
        StyleConstants.setForeground(attribs, Color.black);
        StyleConstants.setBold(attribs, false);
        StyleConstants.setItalic(attribs, false);
        this.styles.put("reference", attribs);
        attribs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attribs, fi.getFamily());
        StyleConstants.setFontSize(attribs, fi.getSize());
        StyleConstants.setBackground(attribs, Color.white);
        StyleConstants.setForeground(attribs, new Color(11546720));
        StyleConstants.setBold(attribs, true);
        StyleConstants.setItalic(attribs, false);
        this.styles.put("name", attribs);
        attribs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attribs, fi.getFamily());
        StyleConstants.setFontSize(attribs, fi.getSize());
        StyleConstants.setBackground(attribs, Color.white);
        StyleConstants.setForeground(attribs, new Color(11546720));
        StyleConstants.setBold(attribs, false);
        StyleConstants.setItalic(attribs, true);
        this.styles.put("value", attribs);
        attribs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attribs, fi.getFamily());
        StyleConstants.setFontSize(attribs, fi.getSize());
        StyleConstants.setBackground(attribs, Color.white);
        StyleConstants.setForeground(attribs, Color.black);
        StyleConstants.setBold(attribs, true);
        StyleConstants.setItalic(attribs, false);
        this.styles.put("text", attribs);
        SyntaxStyle style = this._syntaxPrefs.getColumnStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("columnName", attribs);
        style = this._syntaxPrefs.getCommentStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("comment", attribs);
        style = this._syntaxPrefs.getDataTypeStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("datatype", attribs);
        style = this._syntaxPrefs.getErrorStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("error", attribs);
        style = this._syntaxPrefs.getFunctionStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("function", attribs);
        style = this._syntaxPrefs.getIdentifierStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("identifier", attribs);
        style = this._syntaxPrefs.getLiteralStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("literal", attribs);
        style = this._syntaxPrefs.getOperatorStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("operator", attribs);
        style = this._syntaxPrefs.getReservedWordStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("reservedWord", attribs);
        style = this._syntaxPrefs.getSeparatorStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("separator", attribs);
        style = this._syntaxPrefs.getTableStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("tableName", attribs);
        style = this._syntaxPrefs.getWhiteSpaceStyle();
        attribs = new SimpleAttributeSet();
        this.applyStyle(attribs, style, fi);
        this.styles.put("whitespace", attribs);
        attribs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attribs, fi.getFamily());
        StyleConstants.setFontSize(attribs, fi.getSize());
        StyleConstants.setBackground(attribs, Color.white);
        StyleConstants.setForeground(attribs, new Color(10494192).darker());
        StyleConstants.setBold(attribs, false);
        StyleConstants.setItalic(attribs, false);
        this.styles.put("preprocessor", attribs);
        attribs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attribs, fi.getFamily());
        StyleConstants.setFontSize(attribs, fi.getSize());
        StyleConstants.setBackground(attribs, Color.white);
        StyleConstants.setForeground(attribs, Color.orange);
        StyleConstants.setBold(attribs, false);
        StyleConstants.setItalic(attribs, false);
        this.styles.put("unknown", attribs);
    }

    public void addSQLTokenListener(SQLTokenListener l) {
        this._sqlTokenListeners.add(l);
    }

    public void removeSQLTokenListener(SQLTokenListener l) {
        this._sqlTokenListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableOrViewFound(String name) {
        Vector<SQLTokenListener> buf;
        Vector<SQLTokenListener> vector = this._sqlTokenListeners;
        synchronized (vector) {
            buf = new Vector<SQLTokenListener>(this._sqlTokenListeners);
        }
        for (int i = 0; i < buf.size(); ++i) {
            buf.get(i).tableOrViewFound(name);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int pos = this.viewToModel(event.getPoint());
        for (int i = 0; i < this._currentErrorInfos.size(); ++i) {
            ErrorInfo errInfo = this._currentErrorInfos.elementAt(i);
            if (errInfo.beginPos - 1 > pos || pos > errInfo.endPos) continue;
            return errInfo.message;
        }
        return null;
    }

    class DocumentReader
    extends Reader {
        private long position = 0L;
        private long mark = -1L;
        private AbstractDocument document;

        public void update(int position, int adjustment) {
            if ((long)position < this.position) {
                this.position = this.position < (long)(position - adjustment) ? (long)position : (this.position += (long)adjustment);
            }
        }

        public DocumentReader(AbstractDocument document) {
            this.document = document;
        }

        @Override
        public void close() {
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.position;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() {
            if (this.position < (long)this.document.getLength()) {
                try {
                    char c = this.document.getText((int)this.position, 1).charAt(0);
                    ++this.position;
                    return c;
                }
                catch (BadLocationException x) {
                    return -1;
                }
            }
            return -1;
        }

        @Override
        public int read(char[] cbuf) {
            return this.read(cbuf, 0, cbuf.length);
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            if (this.position < (long)this.document.getLength()) {
                int length = len;
                if (this.position + (long)length >= (long)this.document.getLength()) {
                    length = this.document.getLength() - (int)this.position;
                }
                if (off + length >= cbuf.length) {
                    length = cbuf.length - off;
                }
                try {
                    String s = this.document.getText((int)this.position, length);
                    this.position += (long)length;
                    for (int i = 0; i < length; ++i) {
                        cbuf[off + i] = (char)(s.charAt(i) % 256);
                    }
                    return length;
                }
                catch (BadLocationException x) {
                    return -1;
                }
            }
            return -1;
        }

        @Override
        public boolean ready() {
            return true;
        }

        @Override
        public void reset() {
            this.position = this.mark == -1L ? 0L : this.mark;
            this.mark = -1L;
        }

        @Override
        public long skip(long n) {
            if (this.position + n <= (long)this.document.getLength()) {
                this.position += n;
                return n;
            }
            long oldPos = this.position;
            this.position = this.document.getLength();
            return (long)this.document.getLength() - oldPos;
        }

        public void seek(long n) {
            this.position = n <= (long)this.document.getLength() ? n : (long)this.document.getLength();
        }
    }

    private class HighLightedDocument
    extends DefaultStyledDocument {
        private static final long serialVersionUID = 1L;

        public HighLightedDocument() {
            this.putProperty("__EndOfLine__", "\n");
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
            OsterTextControl.this.color(offs, str.length(), true, str);
            OsterTextControl.this.documentReader.update(offs, str.length());
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            String change = this.getText(offs, len);
            super.remove(offs, len);
            OsterTextControl.this.color(offs, -len, true, change);
            OsterTextControl.this.documentReader.update(offs, -len);
        }
    }

    private class Colorer
    extends Thread {
        private boolean _endThread;
        private Vector<int[]> _currentLiteralAndCommentIntervals = new Vector();
        private Hashtable<String, String> _knownTables = new Hashtable();
        private volatile Vector<RecolorEvent> recolorEventQueue = new Vector();
        private volatile boolean asleep = false;
        private Object lock = new Object();

        private Colorer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void color(int position, int adjustment, boolean fireTableOrViewFoundEvent, String change) {
            Object object = this.lock;
            synchronized (object) {
                this.recolorEventQueue.add(new RecolorEvent(position, adjustment, fireTableOrViewFoundEvent, change));
                if (this.asleep) {
                    this.interrupt();
                }
            }
        }

        public void endThread() {
            this._endThread = true;
            if (this.asleep) {
                this.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            int colorStartPos = -1;
            int colorLen = 0;
            boolean fireTableOrViewFoundEvent = true;
            boolean tryAgain = false;
            while (true) {
                Object object = this.lock;
                // MONITORENTER : object
                if (this.recolorEventQueue.size() > 0) {
                    RecolorEvent re = this.recolorEventQueue.elementAt(0);
                    this.recolorEventQueue.removeElementAt(0);
                    if (null != re.change) {
                        this.adjustIntervalsToAdjustment(re);
                    }
                    colorStartPos = this.getColorStartPos(re);
                    colorLen = this.getColorLen(colorStartPos, re);
                    if (null != re.change && (-1 != re.change.indexOf(39) || -1 != re.change.indexOf(47) || -1 != re.change.indexOf(42) || -1 != re.change.indexOf(45) || null != this.getInvolvedLiteralOrCommentInterval(re.position))) {
                        this.reinitLiteralAndCommentIntervals();
                        int colorStartPos2 = this.getColorStartPos(re);
                        int colorLen2 = this.getColorLen(colorStartPos, re);
                        int newStartPos = Math.min(colorStartPos, colorStartPos2);
                        int newEndPos = Math.max(colorStartPos2 + colorLen2, colorStartPos + colorLen);
                        colorStartPos = newStartPos;
                        colorLen = newEndPos - newStartPos;
                    }
                    fireTableOrViewFoundEvent = re.fireTableOrViewFoundEvent;
                } else {
                    tryAgain = false;
                    colorStartPos = -1;
                    colorLen = 0;
                    fireTableOrViewFoundEvent = false;
                }
                // MONITOREXIT : object
                if (colorStartPos != -1) {
                    try {
                        SchemaInfo si = OsterTextControl.this._session.getSchemaInfo();
                        Object colorStartPos2 = OsterTextControl.this.doclock;
                        // MONITORENTER : colorStartPos2
                        OsterTextControl.this.syntaxLexer.reset((Reader)OsterTextControl.this.documentReader, 0, colorStartPos, 0);
                        OsterTextControl.this.documentReader.seek(colorStartPos);
                        Token t = OsterTextControl.this.getNextToken();
                        // MONITOREXIT : colorStartPos2
                        SimpleAttributeSet errStyle = OsterTextControl.this.getMyStyle("error");
                        ErrorInfo[] errInfoClone = OsterTextControl.this._currentErrorInfos.toArray(new ErrorInfo[0]);
                        while (t != null && t.getCharEnd() <= colorStartPos + colorLen + 1) {
                            Object object2 = OsterTextControl.this.doclock;
                            // MONITORENTER : object2
                            if (t.getCharEnd() <= OsterTextControl.this.document.getLength()) {
                                String type = t.getDescription();
                                if (type.equals("identifier")) {
                                    String data = t.getContents();
                                    if (si.isTable(data)) {
                                        String upperCaseTableName;
                                        type = "tableName";
                                        if (fireTableOrViewFoundEvent) {
                                            OsterTextControl.this.fireTableOrViewFound(t.getContents());
                                        }
                                        if (!this._knownTables.contains(upperCaseTableName = data.toUpperCase())) {
                                            this._knownTables.put(upperCaseTableName, upperCaseTableName);
                                            this.recolorColumns(upperCaseTableName);
                                        }
                                    } else if (si.isColumn(data)) {
                                        type = "columnName";
                                    } else if (si.isDataType(data)) {
                                        type = "datatype";
                                    } else if (si.isKeyword(data)) {
                                        type = "reservedWord";
                                    }
                                }
                                int begin = t.getCharBegin();
                                int len = t.getCharEnd() - t.getCharBegin();
                                SimpleAttributeSet myStyle = null;
                                for (int i = 0; i < errInfoClone.length; ++i) {
                                    if (!this.isBetween(errInfoClone[i].beginPos, errInfoClone[i].endPos, begin) || !this.isBetween(errInfoClone[i].beginPos, errInfoClone[i].endPos, begin + len - 1)) continue;
                                    myStyle = errStyle;
                                }
                                if (null == myStyle) {
                                    myStyle = OsterTextControl.this.getMyStyle(type);
                                }
                                this.setCharacterAttributes(begin, len, myStyle, true);
                            }
                            // MONITOREXIT : object2
                            object2 = OsterTextControl.this.doclock;
                            // MONITORENTER : object2
                            t = OsterTextControl.this.getNextToken();
                            // MONITOREXIT : object2
                        }
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                    tryAgain = true;
                }
                if (this._endThread) {
                    return;
                }
                this.asleep = true;
                if (!tryAgain) {
                    try {
                        Colorer.sleep(0xFFFFFFL);
                    }
                    catch (InterruptedException x) {
                        // empty catch block
                    }
                }
                if (this._endThread) {
                    return;
                }
                this.asleep = false;
            }
        }

        private void adjustIntervalsToAdjustment(RecolorEvent re) {
            for (int i = 0; i < this._currentLiteralAndCommentIntervals.size(); ++i) {
                int[] interval = this._currentLiteralAndCommentIntervals.elementAt(i);
                if (re.position < interval[0]) {
                    interval[0] = interval[0] + re.adjustment;
                }
                if (re.position >= interval[1]) continue;
                interval[1] = interval[1] + re.adjustment;
            }
        }

        private void recolorColumns(String tableName) {
            String text = OsterTextControl.this.getText().toUpperCase();
            ExtendedColumnInfo[] cols = OsterTextControl.this._session.getSchemaInfo().getExtendedColumnInfos(tableName);
            for (int i = 0; i < cols.length; ++i) {
                String upperCaseColName = cols[i].getColumnName().toUpperCase();
                int fromIndex = 0;
                while (-1 != (fromIndex = text.indexOf(upperCaseColName, fromIndex))) {
                    this.color(fromIndex, upperCaseColName.length(), false, null);
                    ++fromIndex;
                }
            }
        }

        private void reinitLiteralAndCommentIntervals() {
            try {
                this._currentLiteralAndCommentIntervals.clear();
                Document doc = OsterTextControl.this.getDocument();
                int docLen = doc.getLength();
                int[] curInterval = null;
                boolean inMultiLineComment = false;
                boolean inSinglLineComment = false;
                boolean inLiteral = false;
                for (int i = 0; i < docLen; ++i) {
                    if (i < docLen + 1 && "/*".equals(doc.getText(i, 2)) && !inMultiLineComment && !inSinglLineComment && !inLiteral) {
                        curInterval = new int[]{i++, docLen};
                        inMultiLineComment = true;
                        continue;
                    }
                    if (i < docLen + 1 && "--".equals(doc.getText(i, 2)) && !inMultiLineComment && !inSinglLineComment && !inLiteral) {
                        curInterval = new int[]{i++, docLen};
                        inSinglLineComment = true;
                        continue;
                    }
                    if (!('\'' != doc.getText(i, 1).charAt(0) || inMultiLineComment || inSinglLineComment || inLiteral)) {
                        curInterval = new int[]{i, docLen};
                        inLiteral = true;
                        continue;
                    }
                    if (i < docLen + 1 && "*/".equals(doc.getText(i, 2)) && inMultiLineComment) {
                        curInterval[1] = i + 1;
                        this._currentLiteralAndCommentIntervals.add(curInterval);
                        curInterval = null;
                        inMultiLineComment = false;
                        ++i;
                    }
                    if ('\n' == doc.getText(i, 1).charAt(0) && inSinglLineComment) {
                        curInterval[1] = i;
                        this._currentLiteralAndCommentIntervals.add(curInterval);
                        curInterval = null;
                        inSinglLineComment = false;
                    }
                    if ('\'' != doc.getText(i, 1).charAt(0) || !inLiteral) continue;
                    if (i < docLen + 1 && '\'' == doc.getText(i + 1, 1).charAt(0)) {
                        ++i;
                        continue;
                    }
                    curInterval[1] = i;
                    this._currentLiteralAndCommentIntervals.add(curInterval);
                    curInterval = null;
                    inLiteral = false;
                }
                if (null != curInterval) {
                    this._currentLiteralAndCommentIntervals.add(curInterval);
                }
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }

        private int getColorLen(int begin, RecolorEvent re) {
            try {
                int end;
                int reBegin = Math.min(re.position, re.position + re.adjustment);
                reBegin = Math.max(0, reBegin);
                int docLen = OsterTextControl.this.getDocument().getLength();
                if (end > docLen - 1) {
                    return docLen - begin;
                }
                for (end = begin + (reBegin - begin) + Math.max(0, re.adjustment); end < docLen - 1 && !Character.isWhitespace(OsterTextControl.this.getDocument().getText(end, 1).charAt(0)); ++end) {
                }
                int[] interval = this.getInvolvedLiteralOrCommentInterval(end);
                if (null != interval) {
                    return Math.max(end - begin, interval[1] - begin);
                }
                return end - begin;
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }

        private int getColorStartPos(RecolorEvent re) {
            try {
                int startPos;
                if (0 > startPos) {
                    return 0;
                }
                for (startPos = Math.min(re.position, re.position + re.adjustment); startPos > 0 && !Character.isWhitespace(OsterTextControl.this.getDocument().getText(startPos - 1, 1).charAt(0)); --startPos) {
                }
                int[] interval = this.getInvolvedLiteralOrCommentInterval(startPos);
                if (null != interval) {
                    return Math.min(startPos, interval[0]);
                }
                return startPos;
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }

        private int[] getInvolvedLiteralOrCommentInterval(int pos) {
            for (int i = 0; i < this._currentLiteralAndCommentIntervals.size(); ++i) {
                int[] interval = this._currentLiteralAndCommentIntervals.elementAt(i);
                if (interval[0] - 1 > pos || pos > interval[1] + 1) continue;
                return interval;
            }
            return null;
        }

        private boolean isBetween(int beg, int end, int p) {
            return beg <= p && p <= end;
        }

        private void setCharacterAttributes(final int offset, final int length, final AttributeSet s, final boolean replace) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OsterTextControl.this.document.setCharacterAttributes(offset, length, s, replace);
                }
            });
        }

        private class RecolorEvent {
            private int position;
            private int adjustment;
            private boolean fireTableOrViewFoundEvent;
            private String change;

            public RecolorEvent(int position, int adjustment, boolean fireTableOrViewFoundEvent, String change) {
                this.position = position;
                this.adjustment = adjustment;
                this.fireTableOrViewFoundEvent = fireTableOrViewFoundEvent;
                this.change = change;
            }
        }
    }
}

