/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax;

import java.awt.Color;
import java.awt.Font;
import javax.swing.text.StyleContext;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxStyle;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelTokenMarker;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;

public class SquirrelSyntaxScheme
extends SyntaxScheme {
    public SquirrelSyntaxScheme() {
        super(true);
    }

    public void initSytles(SyntaxPreferences prefs, FontInfo fontInfo) {
        super.restoreDefaults(fontInfo.createFont());
        Style[] stylesBuf = new Style[SquirrelTokenMarker.getNumTokenTypes()];
        System.arraycopy(this.styles, 0, stylesBuf, 0, this.styles.length);
        StyleContext sc = StyleContext.getDefaultStyleContext();
        Font boldFont = sc.getFont(fontInfo.getFamily(), 1, fontInfo.getSize());
        Font italicFont = sc.getFont(fontInfo.getFamily(), 2, fontInfo.getSize());
        stylesBuf[4] = this.createRSyntaxStyle(prefs.getReservedWordStyle(), boldFont, italicFont);
        stylesBuf[SquirrelTokenMarker.TOKEN_IDENTIFIER_TABLE] = this.createRSyntaxStyle(prefs.getTableStyle(), boldFont, italicFont);
        stylesBuf[SquirrelTokenMarker.TOKEN_IDENTIFIER_DATA_TYPE] = this.createRSyntaxStyle(prefs.getDataTypeStyle(), boldFont, italicFont);
        stylesBuf[SquirrelTokenMarker.TOKEN_IDENTIFIER_COLUMN] = this.createRSyntaxStyle(prefs.getColumnStyle(), boldFont, italicFont);
        stylesBuf[SquirrelTokenMarker.TOKEN_IDENTIFIER_FUNCTION] = this.createRSyntaxStyle(prefs.getFunctionStyle(), boldFont, italicFont);
        stylesBuf[SquirrelTokenMarker.TOKEN_IDENTIFIER_STATEMENT_SEPARATOR] = this.createRSyntaxStyle(prefs.getSeparatorStyle(), boldFont, italicFont);
        stylesBuf[15] = this.createRSyntaxStyle(prefs.getIdentifierStyle(), boldFont, italicFont);
        stylesBuf[1] = this.createRSyntaxStyle(prefs.getCommentStyle(), boldFont, italicFont);
        stylesBuf[2] = this.createRSyntaxStyle(prefs.getCommentStyle(), boldFont, italicFont);
        stylesBuf[3] = this.createRSyntaxStyle(prefs.getCommentStyle(), boldFont, italicFont);
        stylesBuf[10] = this.createRSyntaxStyle(prefs.getLiteralStyle(), boldFont, italicFont);
        stylesBuf[18] = this.createRSyntaxStyle(prefs.getOperatorStyle(), boldFont, italicFont);
        stylesBuf[16] = this.createRSyntaxStyle(prefs.getWhiteSpaceStyle(), boldFont, italicFont);
        stylesBuf[23] = this.createRSyntaxStyle(prefs.getErrorStyle(), boldFont, italicFont);
        stylesBuf[24] = this.createRSyntaxStyle(prefs.getErrorStyle(), boldFont, italicFont);
        stylesBuf[25] = this.createRSyntaxStyle(prefs.getErrorStyle(), boldFont, italicFont);
        this.styles = stylesBuf;
    }

    private Style createRSyntaxStyle(SyntaxStyle squirrelStyle, Font boldFont, Font italicFont) {
        Style style = squirrelStyle.isBold() ? new Style(new Color(squirrelStyle.getTextRGB()), new Color(squirrelStyle.getBackgroundRGB()), boldFont) : (squirrelStyle.isItalic() ? new Style(new Color(squirrelStyle.getTextRGB()), new Color(squirrelStyle.getBackgroundRGB()), italicFont) : new Style(new Color(squirrelStyle.getTextRGB()), new Color(squirrelStyle.getBackgroundRGB()), null));
        return style;
    }

    public Object clone() {
        SyntaxScheme shcs = null;
        shcs = (SyntaxScheme)super.clone();
        shcs.styles = new Style[SquirrelTokenMarker.getNumTokenTypes()];
        for (int i = 0; i < SquirrelTokenMarker.getNumTokenTypes(); ++i) {
            Style s = this.styles[i];
            if (s == null) continue;
            shcs.styles[i] = (Style)s.clone();
        }
        return shcs;
    }
}

