/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.ISquirrelSearchDialog;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.SearchDialogClosingListener;
import org.fife.ui.search.FindDialog;

public class SquirrelFindDialog
extends FindDialog
implements ISquirrelSearchDialog {
    private ArrayList<SearchDialogClosingListener> _closingListeners = new ArrayList();

    public SquirrelFindDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SquirrelFindDialog.this.close();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SquirrelFindDialog.this.fireClosing();
            }
        });
    }

    protected void escapePressed() {
        this.fireClosing();
        super.escapePressed();
    }

    @Override
    public void close() {
        this.fireClosing();
        this.setVisible(false);
        this.dispose();
    }

    private void fireClosing() {
        SearchDialogClosingListener[] listeners;
        for (SearchDialogClosingListener listener : listeners = this._closingListeners.toArray(new SearchDialogClosingListener[this._closingListeners.size()])) {
            listener.searchDialogClosing();
        }
    }

    @Override
    public boolean isMatchCase() {
        return this.caseCheckBox.isSelected();
    }

    @Override
    public boolean isWholeWord() {
        return this.wholeWordCheckBox.isSelected();
    }

    @Override
    public boolean isRegExp() {
        return this.regExpCheckBox.isSelected();
    }

    @Override
    public boolean isSearchUp() {
        return this.upButton.isSelected();
    }

    @Override
    public boolean isMarkAll() {
        return this.markAllCheckBox.isSelected();
    }

    @Override
    public JDialog getDialog() {
        return this;
    }

    @Override
    public void addClosingListener(SearchDialogClosingListener l) {
        this._closingListeners.add(l);
    }

    @Override
    public void removeClosingListener(SearchDialogClosingListener l) {
        this._closingListeners.remove(l);
    }

    @Override
    public void addFindActionListener(ActionListener actionListener) {
        this.findNextButton.addActionListener(actionListener);
    }

    @Override
    public void removeFindActionListener(ActionListener actionListener) {
        this.findNextButton.removeActionListener(actionListener);
    }

    @Override
    public void addReplaceActionListener(ActionListener actionListener) {
    }

    @Override
    public void removeReplaceActionListener(ActionListener actionListener) {
    }

    @Override
    public void addReplaceAllActionListener(ActionListener actionListener) {
    }

    @Override
    public void removeReplaceAllActionListener(ActionListener actionListener) {
    }

    @Override
    public String getReplaceString() {
        throw new UnsupportedOperationException("Only available in SquirrelReplaceDialog");
    }
}

