/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.fife.ui.EscapableDialog;
import org.fife.ui.RButton;
import org.fife.ui.ResizableFrameContentPane;

public class SquirrelGoToDialog
extends EscapableDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SquirrelGoToDialog.class);
    private JButton okButton;
    private JButton cancelButton;
    private JTextField lineNumberField;
    private int maxLineNumberAllowed;
    private int lineNumber;

    public SquirrelGoToDialog(JFrame parent) {
        super((Frame)parent);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.lineNumber = 1;
        this.maxLineNumberAllowed = 1;
        GoToListener listener = new GoToListener();
        ResizableFrameContentPane contentPane = new ResizableFrameContentPane((LayoutManager)new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setContentPane((Container)contentPane);
        JPanel enterLineNumberPane = new JPanel();
        BoxLayout box = new BoxLayout(enterLineNumberPane, 2);
        enterLineNumberPane.setLayout(box);
        this.lineNumberField = new JTextField(16);
        this.lineNumberField.setText("" + this.lineNumber);
        AbstractDocument doc = (AbstractDocument)this.lineNumberField.getDocument();
        doc.addDocumentListener(listener);
        doc.setDocumentFilter(new GoToDocumentFilter());
        enterLineNumberPane.add(new JLabel(s_stringMgr.getString("syntax.SquirrelGoToDialog.LineNumber")));
        enterLineNumberPane.add(this.lineNumberField);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        this.okButton = SquirrelGoToDialog.createRButton(s_stringMgr.getString("syntax.SquirrelGoToDialog.OKButtonLabel"), s_stringMgr.getString("syntax.SquirrelGoToDialog.OKButtonMnemonic"));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(listener);
        this.cancelButton = SquirrelGoToDialog.createRButton(s_stringMgr.getString("syntax.SquirrelGoToDialog.Cancel"), s_stringMgr.getString("syntax.SquirrelGoToDialog.CancelMnemonic"));
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(listener);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)enterLineNumberPane, "North");
        JPanel temp = new JPanel();
        temp.add(buttonPanel);
        contentPane.add((Component)temp, "South");
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(this.okButton);
        this.setTitle(s_stringMgr.getString("syntax.SquirrelGoToDialog.GotoDialogTitle"));
        this.setModal(true);
        this.applyComponentOrientation(orientation);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public static final RButton createRButton(String textKey, String mnemonicKey) {
        RButton b = new RButton(textKey);
        b.setMnemonic((int)mnemonicKey.charAt(0));
        return b;
    }

    private void attemptToGetGoToLine() {
        try {
            this.lineNumber = Integer.parseInt(this.lineNumberField.getText());
            if (this.lineNumber < 1 || this.lineNumber > this.maxLineNumberAllowed) {
                throw new NumberFormatException();
            }
            this.setVisible(false);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog((Component)((Object)this), s_stringMgr.getString("syntax.SquirrelGoToDialog.LineNumberRange", new Object[]{this.maxLineNumberAllowed}), s_stringMgr.getString("syntax.SquirrelGoToDialog.ErrorDialogTitle"), 0);
            return;
        }
    }

    protected void escapePressed() {
        this.lineNumber = -1;
        super.escapePressed();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setMaxLineNumberAllowed(int max) {
        this.maxLineNumberAllowed = max;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.lineNumber = -1;
            this.okButton.setEnabled(this.lineNumberField.getDocument().getLength() > 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SquirrelGoToDialog.this.lineNumberField.requestFocusInWindow();
                    SquirrelGoToDialog.this.lineNumberField.selectAll();
                }
            });
        }
        super.setVisible(visible);
    }

    private class GoToListener
    implements ActionListener,
    DocumentListener {
        private GoToListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("OK")) {
                SquirrelGoToDialog.this.attemptToGetGoToLine();
            } else if (command.equals("Cancel")) {
                SquirrelGoToDialog.this.escapePressed();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SquirrelGoToDialog.this.okButton.setEnabled(SquirrelGoToDialog.this.lineNumberField.getDocument().getLength() > 0);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SquirrelGoToDialog.this.okButton.setEnabled(SquirrelGoToDialog.this.lineNumberField.getDocument().getLength() > 0);
        }
    }

    static class GoToDocumentFilter
    extends DocumentFilter {
        GoToDocumentFilter() {
        }

        private final String cleanse(String text) {
            boolean beep = false;
            if (text != null) {
                int length = text.length();
                for (int i = 0; i < length; ++i) {
                    if (Character.isDigit(text.charAt(i))) continue;
                    text = text.substring(0, i) + text.substring(i + 1);
                    --i;
                    --length;
                    beep = true;
                }
            }
            if (beep) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            }
            return text;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            fb.insertString(offset, this.cleanse(text), attr);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            fb.remove(offset, length);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attr) throws BadLocationException {
            fb.replace(offset, length, this.cleanse(text), attr);
        }
    }
}

