/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JDialog;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.ISquirrelSearchDialog;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.SearchDialogClosingListener;
import org.fife.ui.search.ReplaceDialog;

public class SquirrelReplaceDialog
extends ReplaceDialog
implements ISquirrelSearchDialog {
    private ArrayList<SearchDialogClosingListener> _closingListeners = new ArrayList();
    private HashMap<ActionListener, ActionListener> _listener_listenerProxy = new HashMap();

    public SquirrelReplaceDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SquirrelReplaceDialog.this.close();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SquirrelReplaceDialog.this.fireClosing();
            }
        });
    }

    protected void escapePressed() {
        this.fireClosing();
        super.escapePressed();
    }

    @Override
    public void close() {
        this.fireClosing();
        this.setVisible(false);
        this.dispose();
    }

    private void fireClosing() {
        SearchDialogClosingListener[] listeners;
        for (SearchDialogClosingListener listener : listeners = this._closingListeners.toArray(new SearchDialogClosingListener[this._closingListeners.size()])) {
            listener.searchDialogClosing();
        }
    }

    @Override
    public boolean isMatchCase() {
        return this.caseCheckBox.isSelected();
    }

    @Override
    public boolean isWholeWord() {
        return this.wholeWordCheckBox.isSelected();
    }

    @Override
    public boolean isRegExp() {
        return this.regExpCheckBox.isSelected();
    }

    @Override
    public boolean isSearchUp() {
        return this.upButton.isSelected();
    }

    @Override
    public boolean isMarkAll() {
        return this.markAllCheckBox.isSelected();
    }

    @Override
    public JDialog getDialog() {
        return this;
    }

    @Override
    public void addClosingListener(SearchDialogClosingListener l) {
        this._closingListeners.add(l);
    }

    @Override
    public void removeClosingListener(SearchDialogClosingListener l) {
        this._closingListeners.remove(l);
    }

    @Override
    public void addFindActionListener(ActionListener actionListener) {
        this.findNextButton.addActionListener(actionListener);
    }

    @Override
    public void removeFindActionListener(ActionListener actionListener) {
        this.findNextButton.removeActionListener(actionListener);
    }

    @Override
    public void addReplaceActionListener(final ActionListener actionListener) {
        ActionListener actionListenerProxy = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SquirrelReplaceDialog.this.onReplace(e, actionListener);
            }
        };
        this.addActionListener(actionListenerProxy);
        this._listener_listenerProxy.put(actionListener, actionListenerProxy);
    }

    private void onReplace(ActionEvent e, ActionListener actionListener) {
        if ("Replace".equals(e.getActionCommand())) {
            actionListener.actionPerformed(e);
            this.findNextButton.doClick(10);
        }
    }

    private void onReplaceAll(ActionEvent e, ActionListener actionListener) {
        if ("ReplaceAll".equals(e.getActionCommand())) {
            actionListener.actionPerformed(e);
        }
    }

    @Override
    public void removeReplaceActionListener(ActionListener actionListener) {
        this.removeReplaceListener(actionListener);
    }

    private void removeReplaceListener(ActionListener actionListener) {
        ActionListener actionListenerProxy = this._listener_listenerProxy.remove(actionListener);
        if (null != actionListenerProxy) {
            this.removeActionListener(actionListenerProxy);
        }
    }

    @Override
    public void addReplaceAllActionListener(final ActionListener actionListener) {
        ActionListener actionListenerProxy = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SquirrelReplaceDialog.this.onReplaceAll(e, actionListener);
            }
        };
        this.addActionListener(actionListenerProxy);
        this._listener_listenerProxy.put(actionListener, actionListenerProxy);
    }

    @Override
    public void removeReplaceAllActionListener(ActionListener actionListener) {
        this.removeReplaceListener(actionListener);
    }
}

